/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.patchkaraf;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.StringTokenizer;
import org.xipki.patchkaraf.PatchUtil;

public class PatchFeature {
    public static void main(String[] args) {
        try {
            System.exit(PatchFeature.func(args));
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
            System.exit(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int func(String[] args) throws IOException {
        File origFile;
        if (args == null || args.length == 0 || args[0].equals("--help") || args.length % 2 != 0) {
            return PatchFeature.printUsage("");
        }
        String fileName = null;
        String repos = null;
        String features = null;
        boolean backup = true;
        for (int i = 0; i < args.length; i += 2) {
            String option = args[i];
            String value = args[i + 1];
            if ("--file".equalsIgnoreCase(option)) {
                fileName = value;
                continue;
            }
            if ("--repos".equalsIgnoreCase(option)) {
                repos = value;
                continue;
            }
            if ("--features".equalsIgnoreCase(option)) {
                features = value;
                continue;
            }
            if (!"--backup".equalsIgnoreCase(option)) continue;
            backup = Boolean.parseBoolean(value);
        }
        if (PatchUtil.isBlank(fileName)) {
            return PatchFeature.printUsage("file is not specified");
        }
        if (PatchUtil.isBlank(repos) && PatchUtil.isBlank(features)) {
            return PatchFeature.printUsage("nothing to patch");
        }
        File file = new File(fileName);
        File tmpNewFile = new File(fileName + ".new");
        BufferedReader reader = new BufferedReader(new FileReader(file));
        BufferedWriter writer = new BufferedWriter(new FileWriter(tmpNewFile));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                String value2;
                StringBuilder sb;
                String line2;
                if (line.startsWith("featuresRepositories =") && !PatchUtil.isBlank(repos)) {
                    line2 = PatchUtil.readContinuedLine(reader, line);
                    sb = new StringBuilder();
                    sb.append("featuresRepositories = \\\n");
                    StringTokenizer reposTokenizer = new StringTokenizer(repos, ", \n\r");
                    while (reposTokenizer.hasMoreTokens()) {
                        sb.append("    ").append(reposTokenizer.nextToken()).append(", \\\n");
                    }
                    value2 = line2.substring("featuresRepositories =".length()).trim();
                    reposTokenizer = new StringTokenizer(value2, ", \n\r");
                    while (reposTokenizer.hasMoreTokens()) {
                        sb.append("    ").append(reposTokenizer.nextToken()).append(", \\\n");
                    }
                    int len = sb.length();
                    sb.delete(len - 4, len);
                    writer.write(sb.toString());
                } else if (line.startsWith("featuresBoot =") && !PatchUtil.isBlank(features)) {
                    int index;
                    String phase0Features;
                    line2 = PatchUtil.readContinuedLine(reader, line);
                    sb = new StringBuilder();
                    sb.append("featuresBoot = \\\n");
                    boolean addPhase = features.startsWith("(");
                    if (addPhase) {
                        sb.append("    ( \\\n");
                    }
                    value2 = line2.substring("featuresBoot =".length()).trim();
                    StringTokenizer featuresTokenizer = new StringTokenizer(value2, ", \n\r");
                    while (featuresTokenizer.hasMoreTokens()) {
                        sb.append("    ").append(featuresTokenizer.nextToken()).append(", \\\n");
                    }
                    if (addPhase && !(phase0Features = features.substring(1, index = features.indexOf(41)).trim()).isEmpty()) {
                        features = features.substring(index + 1);
                        featuresTokenizer = new StringTokenizer(phase0Features, ", \n\r");
                        while (featuresTokenizer.hasMoreElements()) {
                            sb.append("    ").append(featuresTokenizer.nextToken()).append(", \\\n");
                        }
                    }
                    int len = sb.length();
                    sb.delete(len - 4, len);
                    if (addPhase) {
                        sb.append(")");
                    }
                    sb.append(", \\\n");
                    featuresTokenizer = new StringTokenizer(features, ", \n\r");
                    while (featuresTokenizer.hasMoreTokens()) {
                        sb.append("    ").append(featuresTokenizer.nextToken()).append(", \\\n");
                    }
                    len = sb.length();
                    sb.delete(len - 4, len);
                    writer.write(sb.toString());
                } else {
                    writer.write(line);
                }
                writer.write(10);
            }
        }
        finally {
            reader.close();
            writer.close();
        }
        if (backup && !PatchUtil.rename(file, origFile = new File(fileName + ".orig"))) {
            return PatchFeature.printUsage("could not rename " + file.getPath() + " to " + origFile.getPath());
        }
        if (!PatchUtil.rename(tmpNewFile, file)) {
            return PatchFeature.printUsage("could not rename " + tmpNewFile.getPath() + " to " + file.getPath());
        }
        System.out.println("Patched file " + fileName);
        return 0;
    }

    private static int printUsage(String message) {
        StringBuilder sb = new StringBuilder();
        if (!PatchUtil.isBlank(message)) {
            sb.append(message).append("\n");
        }
        sb.append("\nSYNTAX");
        sb.append("\n\tjava " + PatchFeature.class.getName() + " [options]");
        sb.append("\nOPTIONS");
        sb.append("\n\t--file");
        sb.append("\n\t\tFile to be patched");
        sb.append("\n\t--backup");
        sb.append("\n\t\tWhether to create a backup of the patched file (with appendix .orig)");
        sb.append("\n\t\t(defaults to true)");
        sb.append("\n\t--repos");
        sb.append("\n\t\tComma-separated repositories");
        sb.append("\n\t--features");
        sb.append("\n\t\tFeatures in form of [(f1,...,fk),]fk+1,fn where fx is the feature name");
        sb.append("\n\t--help");
        sb.append("\n\t\tDisplay this help message");
        System.out.println(sb.toString());
        return -1;
    }
}

