/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CollectionUtil {
    private CollectionUtil() {
    }

    public static boolean isEmpty(Collection<?> col) {
        return col == null || col.isEmpty();
    }

    public static boolean isEmpty(Object[] arrays) {
        return arrays == null || arrays.length == 0;
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isNonEmpty(Collection<?> col) {
        return col != null && !col.isEmpty();
    }

    public static boolean isNonEmpty(Object[] arrays) {
        return arrays != null && arrays.length > 0;
    }

    public static boolean isNonEmpty(Map<?, ?> map) {
        return map != null && !map.isEmpty();
    }

    public static <K, V> Map<K, V> unmodifiableMap(Map<? extends K, ? extends V> map) {
        return map == null ? Collections.emptyMap() : Collections.unmodifiableMap(map);
    }

    public static List<String> toLowerCaseList(List<String> list) {
        if (list == null) {
            return list;
        }
        ArrayList<String> upperList = new ArrayList<String>(list.size());
        for (String s : list) {
            upperList.add(s.toLowerCase());
        }
        return upperList;
    }

    public static Set<String> toLowerCaseSet(Set<String> set) {
        if (set == null) {
            return set;
        }
        HashSet<String> upperSet = new HashSet<String>();
        for (String s : set) {
            upperSet.add(s.toLowerCase());
        }
        return upperSet;
    }

    public static <T> Set<T> unmodifiableSet(Set<? extends T> set) {
        return set == null ? Collections.emptySet() : Collections.unmodifiableSet(set);
    }

    public static <T> Collection<T> unmodifiableCollection(Collection<? extends T> col) {
        return col == null ? Collections.emptySet() : Collections.unmodifiableCollection(col);
    }

    public static <T> List<T> unmodifiableList(List<? extends T> list) {
        return list == null ? Collections.emptyList() : Collections.unmodifiableList(list);
    }
}

