/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.util.http;

import java.io.File;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.xipki.util.ObjectCreationException;
import org.xipki.util.http.HostnameVerifiers;
import org.xipki.util.http.SSLContextBuilder;

public class SslContextConf {
    private boolean useSslConf = true;
    private String sslStoreType;
    private String sslKeystore;
    private String sslKeystorePassword;
    private String sslTruststore;
    private String sslTruststorePassword;
    private String sslHostnameVerifier;
    private SSLContext sslContext;
    private SSLSocketFactory sslSocketFactory;

    public boolean isUseSslConf() {
        return this.useSslConf;
    }

    public void setUseSslConf(boolean useSslConf) {
        this.useSslConf = useSslConf;
    }

    public String getSslStoreType() {
        return this.sslStoreType;
    }

    public void setSslStoreType(String sslStoreType) {
        this.sslStoreType = SslContextConf.emptyAsNull(sslStoreType);
    }

    public String getSslKeystore() {
        return this.sslKeystore;
    }

    public void setSslKeystore(String sslKeystore) {
        this.sslKeystore = SslContextConf.emptyAsNull(sslKeystore);
    }

    public String getSslKeystorePassword() {
        return this.sslKeystorePassword;
    }

    public void setSslKeystorePassword(String sslKeystorePassword) {
        this.sslKeystorePassword = SslContextConf.emptyAsNull(sslKeystorePassword);
    }

    public String getSslTruststore() {
        return this.sslTruststore;
    }

    public void setSslTruststore(String sslTruststore) {
        this.sslTruststore = SslContextConf.emptyAsNull(sslTruststore);
    }

    public String getSslTruststorePassword() {
        return this.sslTruststorePassword;
    }

    public void setSslTruststorePassword(String sslTruststorePassword) {
        this.sslTruststorePassword = SslContextConf.emptyAsNull(sslTruststorePassword);
    }

    public String getSslHostnameVerifier() {
        return this.sslHostnameVerifier;
    }

    public void setSslHostnameVerifier(String sslHostnameVerifier) {
        this.sslHostnameVerifier = SslContextConf.emptyAsNull(sslHostnameVerifier);
    }

    public SSLContext getSslContext() throws ObjectCreationException {
        if (!this.useSslConf) {
            return null;
        }
        if (this.sslContext == null) {
            SSLContextBuilder builder = new SSLContextBuilder();
            if (this.sslStoreType != null) {
                builder.setKeyStoreType(this.sslStoreType);
            }
            try {
                char[] password;
                if (this.sslKeystore != null) {
                    password = this.sslKeystorePassword == null ? null : this.sslKeystorePassword.toCharArray();
                    builder.loadKeyMaterial(new File(this.sslKeystore), password, password);
                }
                if (this.sslTruststorePassword != null) {
                    password = this.sslTruststorePassword == null ? null : this.sslTruststorePassword.toCharArray();
                    builder.loadTrustMaterial(new File(this.sslTruststore), password);
                }
                this.sslContext = builder.build();
            }
            catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException ex) {
                throw new ObjectCreationException("could not build SSLContext: " + ex.getMessage(), ex);
            }
        }
        return this.sslContext;
    }

    public SSLSocketFactory getSslSocketFactory() throws ObjectCreationException {
        if (!this.useSslConf) {
            return null;
        }
        if (this.sslSocketFactory == null) {
            this.getSslContext();
            this.sslSocketFactory = this.sslContext.getSocketFactory();
        }
        return this.sslSocketFactory;
    }

    public HostnameVerifier buildHostnameVerifier() throws ObjectCreationException {
        if (!this.useSslConf) {
            return null;
        }
        return HostnameVerifiers.createHostnameVerifier(this.sslHostnameVerifier);
    }

    private static String emptyAsNull(String text) {
        if (text == null) {
            return null;
        }
        if (text.trim().isEmpty()) {
            return null;
        }
        return text;
    }
}

