/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.util;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.xipki.util.Args;

public class Validity
implements Comparable<Validity> {
    private static final long MINUTE = 60000L;
    private static final long HOUR = 3600000L;
    private static final long DAY = 86400000L;
    private static final TimeZone TIMEZONE_UTC = TimeZone.getTimeZone("UTC");
    private int validity;
    private Unit unit;

    private Validity() {
    }

    public Validity(int validity, Unit unit) {
        this.validity = Args.positive(validity, "validity");
        this.unit = Args.notNull(unit, "unit");
    }

    public static Validity getInstance(String validityS) {
        int validity;
        String numValdityS;
        Unit unit;
        Args.notBlank(validityS, "validityS");
        int len = validityS.length();
        char suffix = validityS.charAt(len - 1);
        if (suffix == 'y' || suffix == 'Y') {
            unit = Unit.YEAR;
            numValdityS = validityS.substring(0, len - 1);
        } else if (suffix == 'd' || suffix == 'D') {
            unit = Unit.DAY;
            numValdityS = validityS.substring(0, len - 1);
        } else if (suffix == 'h' || suffix == 'H') {
            unit = Unit.HOUR;
            numValdityS = validityS.substring(0, len - 1);
        } else if (suffix == 'm' || suffix == 'M') {
            unit = Unit.MINUTE;
            numValdityS = validityS.substring(0, len - 1);
        } else if (suffix >= '0' && suffix <= '9') {
            unit = Unit.DAY;
            numValdityS = validityS;
        } else {
            throw new IllegalArgumentException(String.format("invalid validityS: %s", validityS));
        }
        try {
            validity = Integer.parseInt(numValdityS);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException(String.format("invalid validityS: %s", validityS));
        }
        return new Validity(validity, unit);
    }

    public void setValidity(int validity) {
        this.validity = Args.positive(validity, "validity");
    }

    public int getValidity() {
        return this.validity;
    }

    public void setUnit(Unit unit) {
        this.unit = Args.notNull(unit, "unit");
    }

    public Unit getUnit() {
        return this.unit;
    }

    public Date add(Date referenceDate) {
        switch (this.unit) {
            case YEAR: {
                int day;
                Calendar cal = Calendar.getInstance(TIMEZONE_UTC);
                cal.setTime(referenceDate);
                cal.add(1, this.validity);
                int month = cal.get(2);
                if (month == 1 && (day = cal.get(5)) > 28) {
                    int year = cal.get(1);
                    day = Validity.isLeapYear(year) ? 29 : 28;
                }
                return cal.getTime();
            }
            case DAY: {
                return new Date(referenceDate.getTime() + (long)this.validity * 86400000L);
            }
            case HOUR: {
                return new Date(referenceDate.getTime() + (long)this.validity * 3600000L);
            }
            case MINUTE: {
                return new Date(referenceDate.getTime() + (long)this.validity * 60000L);
            }
        }
        throw new IllegalStateException(String.format("should not reach here, unknown Validity.Unit %s", new Object[]{this.unit}));
    }

    private long approxMinutes() {
        switch (this.unit) {
            case YEAR: {
                return (8760L * (long)this.validity + (long)(6 * this.validity)) * 60L;
            }
            case DAY: {
                return 1440L * (long)this.validity;
            }
            case HOUR: {
                return 60L * (long)this.validity;
            }
            case MINUTE: {
                return this.validity;
            }
        }
        throw new IllegalStateException(String.format("should not reach here, unknown Validity.Unit %s", new Object[]{this.unit}));
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public int compareTo(Validity obj) {
        long thatMinutes;
        Args.notNull(obj, "obj");
        if (this.unit == obj.unit) {
            if (this.validity == obj.validity) {
                return 0;
            }
            return this.validity < obj.validity ? -1 : 1;
        }
        long thisMinutes = this.approxMinutes();
        if (thisMinutes == (thatMinutes = obj.approxMinutes())) {
            return 0;
        }
        return thisMinutes < thatMinutes ? -1 : 1;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Validity)) {
            return false;
        }
        Validity other = (Validity)obj;
        return this.unit == other.unit && this.validity == other.validity;
    }

    public String toString() {
        switch (this.unit) {
            case YEAR: {
                return this.validity + "y";
            }
            case DAY: {
                return this.validity + "d";
            }
            case HOUR: {
                return this.validity + "h";
            }
            case MINUTE: {
                return this.validity + "m";
            }
        }
        throw new IllegalStateException(String.format("should not reach here, unknown Validity.Unit %s", new Object[]{this.unit}));
    }

    private static boolean isLeapYear(int year) {
        if (year % 4 != 0) {
            return false;
        }
        if (year % 100 != 0) {
            return true;
        }
        return year % 400 == 0;
    }

    public static enum Unit {
        YEAR("y"),
        DAY("d"),
        HOUR("h"),
        MINUTE("m");

        private String suffix;

        private Unit(String suffix) {
            this.suffix = suffix;
        }

        public String getSuffix() {
            return this.suffix;
        }
    }
}

