/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.xipki.util.Base64;
import org.xipki.util.Curl;
import org.xipki.util.IoUtil;
import org.xipki.util.ObjectCreationException;
import org.xipki.util.StringUtil;
import org.xipki.util.http.SslContextConf;

public class DefaultCurl
implements Curl {
    private SSLSocketFactory sslSocketFactory;
    private HostnameVerifier hostnameVerifier;
    private SslContextConf sslContextConf;
    private boolean initialized;
    private ObjectCreationException initException;

    public void setSslContextConf(SslContextConf sslContextConf) {
        this.sslContextConf = sslContextConf;
    }

    private synchronized void initIfNotDone() throws ObjectCreationException {
        if (this.initException != null) {
            throw this.initException;
        }
        if (this.initialized) {
            return;
        }
        if (this.sslContextConf != null && this.sslContextConf.isUseSslConf()) {
            try {
                this.sslSocketFactory = this.sslContextConf.getSslSocketFactory();
                this.hostnameVerifier = this.sslContextConf.buildHostnameVerifier();
            }
            catch (ObjectCreationException ex) {
                this.initException = new ObjectCreationException("could not initialize DefaultCurl: " + ex.getMessage(), ex);
                throw this.initException;
            }
        }
        this.initialized = true;
    }

    private static void println(String text) {
        System.out.println(text);
    }

    @Override
    public Curl.CurlResult curlGet(String url, boolean verbose, Map<String, String> headers, String userPassword) throws Exception {
        this.checkUserPassword(userPassword);
        return this.curl(false, url, verbose, headers, userPassword, null);
    }

    @Override
    public Curl.CurlResult curlPost(String url, boolean verbose, Map<String, String> headers, String userPassword, byte[] content) throws Exception {
        return this.curl(true, url, verbose, headers, userPassword, content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private Curl.CurlResult curl(boolean post, String url, boolean verbose, Map<String, String> headers, String userPassword, byte[] content) throws Exception {
        if (!post && content != null) {
            throw new IllegalArgumentException("method GET cannot be used to transfer non-empty content");
        }
        this.checkUserPassword(userPassword);
        this.initIfNotDone();
        URL newUrl = new URL(url);
        HttpURLConnection httpConn = IoUtil.openHttpConn(newUrl);
        if (httpConn instanceof HttpsURLConnection) {
            if (this.sslSocketFactory != null) {
                ((HttpsURLConnection)httpConn).setSSLSocketFactory(this.sslSocketFactory);
            }
            if (this.hostnameVerifier != null) {
                ((HttpsURLConnection)httpConn).setHostnameVerifier(this.hostnameVerifier);
            }
        }
        try {
            void var11_19;
            Map<String, List<String>> properties;
            httpConn.setRequestMethod(post ? "POST" : "GET");
            httpConn.setUseCaches(false);
            if (headers != null) {
                for (String headerName : headers.keySet()) {
                    String string = headers.get(headerName);
                    httpConn.setRequestProperty(headerName, string);
                }
            }
            if (userPassword != null) {
                httpConn.setRequestProperty("Authorization", "Basic " + Base64.encodeToString(StringUtil.toUtf8Bytes(userPassword)));
            }
            if (content == null) {
                properties = httpConn.getRequestProperties();
            } else {
                httpConn.setDoOutput(true);
                httpConn.setRequestProperty("Content-Length", Integer.toString(content.length));
                properties = httpConn.getRequestProperties();
                OutputStream outputstream = httpConn.getOutputStream();
                outputstream.write(content);
                outputstream.flush();
            }
            if (verbose) {
                DefaultCurl.println("=====request=====");
                DefaultCurl.println("  HTTP method: " + httpConn.getRequestMethod());
                for (String string : properties.keySet()) {
                    List<String> values = properties.get(string);
                    for (String value : values) {
                        DefaultCurl.println("  " + string + ": " + value);
                    }
                }
            }
            int respCode = httpConn.getResponseCode();
            if (verbose) {
                DefaultCurl.println("=====response=====");
                DefaultCurl.println("  response code: " + respCode + " " + httpConn.getResponseMessage());
                properties = httpConn.getHeaderFields();
                for (String key : properties.keySet()) {
                    if (key == null) continue;
                    List<String> values = properties.get(key);
                    for (String value : values) {
                        DefaultCurl.println("  " + key + ": " + value);
                    }
                }
                DefaultCurl.println("=====response content=====");
            } else if (respCode != 200) {
                DefaultCurl.println("ERROR: bad response: " + httpConn.getResponseCode() + "    " + httpConn.getResponseMessage());
            }
            Object var11_17 = null;
            InputStream errorStream = null;
            try {
                InputStream inputStream = httpConn.getInputStream();
            }
            catch (IOException ex) {
                errorStream = httpConn.getErrorStream();
            }
            Curl.CurlResult result = new Curl.CurlResult();
            result.setContentType(httpConn.getHeaderField("Content-Type"));
            if (var11_19 != null) {
                result.setContent(IoUtil.read((InputStream)var11_19));
            } else if (errorStream != null) {
                result.setErrorContent(IoUtil.read(errorStream));
            }
            Curl.CurlResult curlResult = result;
            return curlResult;
        }
        finally {
            httpConn.disconnect();
        }
    }

    private void checkUserPassword(String userPassword) {
        if (userPassword == null) {
            return;
        }
        int idx = userPassword.indexOf(58);
        if (idx == -1 || idx == userPassword.length() - 1) {
            throw new IllegalArgumentException("invalid userPassword");
        }
    }
}

