/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.util;

import java.util.Calendar;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.xipki.util.StringUtil;

public class ProcessLog {
    private static final long MS_900 = 900L;
    private static final long DAY_IN_SEC = 86400L;
    private static final int MIN_LEN = 12;
    private final long total;
    private final boolean hasTotal;
    private long startTimeMs;
    private long endTimeMs;
    private AtomicLong numProcessed;
    private AtomicLong lastPrintTimeMs;
    private final AtomicBoolean finished = new AtomicBoolean(false);
    private long totalElapsedTimeMs;
    private int totalAverageSpeed;
    private final ConcurrentLinkedDeque<MeasurePoint> measureDeque = new ConcurrentLinkedDeque();

    public ProcessLog(long total) {
        this.total = total;
        this.hasTotal = total > 0L;
        this.reset();
    }

    public void printHeader() {
        StringBuilder sb = new StringBuilder();
        int n = this.hasTotal ? 7 : 4;
        for (int i = 0; i < n * 12; ++i) {
            sb.append('-');
        }
        sb.append('\n');
        sb.append(ProcessLog.formatText("total"));
        if (this.hasTotal) {
            sb.append(ProcessLog.formatText("%"));
        }
        sb.append(ProcessLog.formatText("average")).append(ProcessLog.formatText("current")).append(ProcessLog.formatText("time"));
        if (this.hasTotal) {
            sb.append(ProcessLog.formatText("time")).append(ProcessLog.formatText("finish"));
        }
        sb.append('\n');
        sb.append(ProcessLog.formatText(""));
        if (this.hasTotal) {
            sb.append(ProcessLog.formatText(""));
        }
        sb.append(ProcessLog.formatText("speed")).append(ProcessLog.formatText("speed")).append(ProcessLog.formatText("spent"));
        if (this.hasTotal) {
            sb.append(ProcessLog.formatText("left")).append(ProcessLog.formatText("at"));
        }
        sb.append('\n');
        System.out.println(sb.toString());
        System.out.flush();
    }

    public void finish() {
        this.finished.set(true);
        this.endTimeMs = System.currentTimeMillis();
        this.totalElapsedTimeMs = this.endTimeMs - this.startTimeMs;
        this.totalAverageSpeed = 0;
        if (this.totalElapsedTimeMs > 0L) {
            this.totalAverageSpeed = (int)(this.numProcessed.get() * 1000L / this.totalElapsedTimeMs);
        }
    }

    public void printTrailer() {
        this.finish();
        this.printStatus(true);
        StringBuilder sb = new StringBuilder();
        sb.append('\n');
        int n = this.hasTotal ? 7 : 4;
        for (int i = 0; i < n * 12; ++i) {
            sb.append('-');
        }
        System.out.println(sb.toString());
        System.out.flush();
    }

    public long numProcessed() {
        return this.numProcessed.get();
    }

    public long total() {
        return this.total;
    }

    public final void reset() {
        this.startTimeMs = System.currentTimeMillis();
        this.numProcessed = new AtomicLong(0L);
        this.lastPrintTimeMs = new AtomicLong(0L);
        this.measureDeque.clear();
        this.measureDeque.add(new MeasurePoint(this.startTimeMs, 0L));
    }

    public long startTimeMs() {
        return this.startTimeMs;
    }

    public long endTimeMs() {
        return this.endTimeMs;
    }

    public long addNumProcessed(long numProcessed) {
        return this.numProcessed.addAndGet(numProcessed);
    }

    public void printStatus() {
        this.printStatus(false);
    }

    private void printStatus(boolean forcePrint) {
        long nowMs = System.currentTimeMillis();
        long tmpNumProcessed = this.numProcessed.get();
        if (!forcePrint && nowMs - this.lastPrintTimeMs.get() < 900L) {
            return;
        }
        this.measureDeque.addLast(new MeasurePoint(nowMs, this.numProcessed.get()));
        this.lastPrintTimeMs.set(nowMs);
        int numMeasurePoints = this.measureDeque.size();
        MeasurePoint referenceMeasurePoint = numMeasurePoints > 10 ? this.measureDeque.removeFirst() : this.measureDeque.getFirst();
        StringBuilder sb = new StringBuilder("\r");
        sb.append(StringUtil.formatAccount(tmpNumProcessed, true));
        if (this.hasTotal) {
            int percent = (int)(tmpNumProcessed * 100L / this.total);
            String percentS = Integer.toString(percent);
            sb.append(ProcessLog.formatText(percentS));
        }
        long averageSpeed = 0L;
        long elapsedTimeMs = nowMs - this.startTimeMs;
        if (elapsedTimeMs > 0L) {
            averageSpeed = tmpNumProcessed * 1000L / elapsedTimeMs;
        }
        sb.append(StringUtil.formatAccount(averageSpeed, true));
        long currentSpeed = 0L;
        long t2inms = nowMs - referenceMeasurePoint.measureTime;
        if (t2inms > 0L) {
            currentSpeed = (tmpNumProcessed - referenceMeasurePoint.measureAccount) * 1000L / t2inms;
        }
        sb.append(StringUtil.formatAccount(currentSpeed, true));
        sb.append(StringUtil.formatTime(elapsedTimeMs / 1000L, true));
        if (this.hasTotal) {
            long remaingTimeMs = -1L;
            if (currentSpeed > 0L) {
                remaingTimeMs = (this.total - tmpNumProcessed) * 1000L / currentSpeed;
            }
            long finishAtMs = -1L;
            if (remaingTimeMs != -1L) {
                finishAtMs = nowMs + remaingTimeMs;
            }
            if (remaingTimeMs == -1L) {
                sb.append(ProcessLog.formatText("--"));
            } else {
                sb.append(StringUtil.formatTime(remaingTimeMs / 1000L, true));
            }
            if (finishAtMs == -1L) {
                sb.append(ProcessLog.formatText("--"));
            } else {
                sb.append(ProcessLog.buildDateTime(finishAtMs));
            }
        }
        System.out.print(sb.toString());
        System.out.flush();
    }

    public long totalElapsedTime() {
        if (this.finished.get()) {
            return this.totalElapsedTimeMs;
        }
        return System.currentTimeMillis() - this.startTimeMs;
    }

    public int totalAverageSpeed() {
        if (this.finished.get()) {
            return this.totalAverageSpeed;
        }
        long elapsedTimeMs = System.currentTimeMillis() - this.startTimeMs;
        int averageSpeed = 0;
        if (elapsedTimeMs > 0L) {
            averageSpeed = (int)(this.numProcessed.get() * 1000L / elapsedTimeMs);
        }
        return averageSpeed;
    }

    private static String formatText(String text) {
        return StringUtil.formatText(text, 12);
    }

    private static String buildDateTime(long timeMs) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(timeMs);
        StringBuilder sb = new StringBuilder();
        int hour = cal.get(11);
        if (hour < 10) {
            sb.append('0');
        }
        sb.append(hour);
        int minute = cal.get(12);
        sb.append(":");
        if (minute < 10) {
            sb.append('0');
        }
        sb.append(minute);
        int second = cal.get(13);
        sb.append(":");
        if (second < 10) {
            sb.append('0');
        }
        sb.append(second);
        cal.setTimeInMillis(System.currentTimeMillis());
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        long midNightSec = cal.getTimeInMillis() / 1000L;
        long days = (timeMs / 1000L - midNightSec) / 86400L;
        if (days > 0L) {
            sb.append('+').append(days);
        }
        int size = sb.length();
        for (int i = 0; i < 12 - size; ++i) {
            sb.insert(0, ' ');
        }
        return sb.toString();
    }

    private static class MeasurePoint {
        private final long measureTime;
        private final long measureAccount;

        public MeasurePoint(long measureTime, long measureAccount) {
            this.measureTime = measureTime;
            this.measureAccount = measureAccount;
        }
    }
}

