/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.util;

import org.xipki.util.Base64;
import org.xipki.util.StringUtil;

public class PemEncoder {
    public static byte[] encode(byte[] data, PemLabel pemLabel) {
        byte[] base64 = Base64.encodeToPemByte(data);
        byte[] out = new byte[pemLabel.prefix.length + base64.length + pemLabel.postfix.length];
        System.arraycopy(pemLabel.prefix, 0, out, 0, pemLabel.prefix.length);
        System.arraycopy(base64, 0, out, pemLabel.prefix.length, base64.length);
        System.arraycopy(pemLabel.postfix, 0, out, pemLabel.prefix.length + base64.length, pemLabel.postfix.length);
        return out;
    }

    public static enum PemLabel {
        CERTIFICATE("CERTIFICATE"),
        X509_CRL("X509 CRL"),
        CERTIFICATE_REQUEST("CERTIFICATE REQUEST"),
        PKCS7("PKCS7"),
        CMS("CMS"),
        PRIVATE_KEY("PRIVATE KEY"),
        ENCRYPTED_PRIVATE_KEY("ENCRYPTED PRIVATE KEY"),
        ATTRIBUTE_CERTIFICATE("ATTRIBUTE CERTIFICATE"),
        PUBLIC_KEY("PUBLIC KEY");

        private final byte[] prefix;
        private final byte[] postfix;

        private PemLabel(String label) {
            this.prefix = StringUtil.toUtf8Bytes("-----BEGIN " + label + "-----\r\n");
            this.postfix = StringUtil.toUtf8Bytes("\r\n-----END " + label + "-----");
        }
    }
}

