/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.Console;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.util.Args;
import org.xipki.util.Base64;
import org.xipki.util.XipkiBaseDir;

public class IoUtil {
    static final String USER_HOME = System.getProperty("user.home");
    private static final Logger LOG = LoggerFactory.getLogger(IoUtil.class);

    private IoUtil() {
    }

    public static void closeQuietly(Closeable closable) {
        if (closable == null) {
            return;
        }
        try {
            closable.close();
        }
        catch (Throwable th) {
            LOG.error("could not close closable: {}", (Object)th.getMessage());
        }
    }

    public static byte[] read(String fileName) throws IOException {
        return Files.readAllBytes(Paths.get(IoUtil.expandFilepath(fileName), new String[0]));
    }

    public static byte[] read(File file) throws IOException {
        return Files.readAllBytes(Paths.get(IoUtil.expandFilepath(file.getPath()), new String[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] read(InputStream in) throws IOException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            int readed = 0;
            byte[] buffer = new byte[2048];
            while ((readed = in.read(buffer)) != -1) {
                bout.write(buffer, 0, readed);
            }
            byte[] byArray = bout.toByteArray();
            return byArray;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ex) {
                LOG.error("could not close stream: {}", (Object)ex.getMessage());
            }
        }
    }

    public static void save(String fileName, byte[] encoded) throws IOException {
        IoUtil.save(new File(IoUtil.expandFilepath(fileName)), encoded);
    }

    public static void save(File file, byte[] content) throws IOException {
        File tmpFile = IoUtil.expandFilepath(file);
        IoUtil.mkdirsParent(tmpFile.toPath());
        Files.copy(new ByteArrayInputStream(content), tmpFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    public static void mkdirsParent(Path path) throws IOException {
        Path parent = path.getParent();
        if (parent != null) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
    }

    public static String getHostAddress() throws SocketException {
        LinkedList<String> addresses = new LinkedList<String>();
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            Iterator ni = interfaces.nextElement();
            Enumeration<InetAddress> ee = ((NetworkInterface)((Object)ni)).getInetAddresses();
            while (ee.hasMoreElements()) {
                InetAddress ia = ee.nextElement();
                if (!(ia instanceof Inet4Address)) continue;
                addresses.add(ia.getHostAddress());
            }
        }
        for (String addr : addresses) {
            if (addr.startsWith("192.") || addr.startsWith("127.")) continue;
            return addr;
        }
        for (String addr : addresses) {
            if (addr.startsWith("127.")) continue;
            return addr;
        }
        if (addresses.size() > 0) {
            return (String)addresses.get(0);
        }
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException ex) {
            return "UNKNOWN";
        }
    }

    public static boolean deleteFile(String path) {
        return IoUtil.deleteFile(new File(IoUtil.expandFilepath(path)));
    }

    public static boolean deleteFile(File file) {
        if ((file = IoUtil.expandFilepath(file)).exists()) {
            return file.delete();
        }
        return true;
    }

    public static String expandFilepath(String path) {
        Args.notBlank(path, "path");
        if (path.startsWith("~")) {
            return USER_HOME + path.substring(1);
        }
        if (path.startsWith("/")) {
            return path;
        }
        String basedir = XipkiBaseDir.basedir();
        return basedir == null ? path : Paths.get(basedir, path).toString();
    }

    public static File expandFilepath(File file) {
        String expandedPath;
        String path = file.getPath();
        return path.equals(expandedPath = IoUtil.expandFilepath(path)) ? file : new File(expandedPath);
    }

    public static String convertSequenceName(String sequenceName) {
        StringBuilder sb = new StringBuilder();
        int len = sequenceName.length();
        for (int i = 0; i < len; ++i) {
            char ch = sequenceName.charAt(i);
            if (ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z') {
                sb.append(ch);
                continue;
            }
            sb.append("_");
        }
        return sb.toString();
    }

    public static void writeShort(short value, byte[] dest, int destOffset) {
        dest[destOffset++] = (byte)(value >> 8);
        dest[destOffset] = (byte)(0xFF & value);
    }

    public static short parseShort(byte[] bytes, int offset) {
        return (short)((0xFF & bytes[offset++]) << 8 | 0xFF & bytes[offset]);
    }

    public static void writeInt(int value, byte[] dest, int destOffset) {
        dest[destOffset++] = (byte)(value >> 24);
        dest[destOffset++] = (byte)(0xFF & value >> 16);
        dest[destOffset++] = (byte)(0xFF & value >> 8);
        dest[destOffset] = (byte)(0xFF & value);
    }

    public static int parseInt(byte[] bytes, int offset) {
        return (0xFF & bytes[offset++]) << 24 | (0xFF & bytes[offset++]) << 16 | (0xFF & bytes[offset++]) << 8 | 0xFF & bytes[offset];
    }

    public static int getIndex(byte[] arrayA, byte[] arrayB) {
        int endIndex = arrayA.length - arrayB.length;
        for (int i = 0; i < endIndex; ++i) {
            boolean found = true;
            for (int j = 0; j < arrayB.length; ++j) {
                if (arrayA[i + j] == arrayB[j]) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return i;
        }
        return -1;
    }

    public static String base64Encode(byte[] data, boolean withLineBreak) {
        return Base64.encodeToString(data, withLineBreak);
    }

    public static HttpURLConnection openHttpConn(URL url) throws IOException {
        Args.notNull(url, "url");
        URLConnection conn = url.openConnection();
        if (conn instanceof HttpURLConnection) {
            return (HttpURLConnection)conn;
        }
        throw new IOException(url.toString() + " is not of protocol HTTP: " + url.getProtocol());
    }

    public static char[] readPasswordFromConsole(String prompt) {
        Console console = System.console();
        if (console == null) {
            throw new IllegalStateException("No console is available for input");
        }
        System.out.println(prompt == null ? "Enter the password" : prompt);
        return console.readPassword();
    }

    public static String readLineFromConsole(String prompt) {
        Console console = System.console();
        if (console == null) {
            throw new IllegalStateException("No console is available for input");
        }
        if (prompt != null) {
            System.out.print(prompt);
        }
        return console.readLine();
    }

    public static Properties loadProperties(String path) throws IOException {
        Path realPath = Paths.get(IoUtil.expandFilepath(path), new String[0]);
        if (!Files.exists(realPath, new LinkOption[0])) {
            throw new IOException("File " + path + " does not exist");
        }
        if (!Files.isReadable(realPath)) {
            throw new IOException("File " + path + " is not readable");
        }
        Properties props = new Properties();
        try (InputStream is = Files.newInputStream(realPath, new OpenOption[0]);){
            props.load(is);
        }
        return props;
    }
}

