/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.util;

import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.util.IoUtil;
import org.xipki.util.StringUtil;

public class XipkiBaseDir {
    private static final Logger LOG = LoggerFactory.getLogger(XipkiBaseDir.class);
    private static final String PROP_XIPKI_BASE = "XIPKI_BASE";
    private static String basedir = null;

    public static synchronized void init() {
        if (basedir != null) {
            return;
        }
        String str = System.getProperty(PROP_XIPKI_BASE);
        if (StringUtil.isBlank(str)) {
            basedir = new File("xipki").getAbsolutePath();
            LOG.info("use default basedir '{}', can be specified via the property '{}'", (Object)basedir, (Object)PROP_XIPKI_BASE);
        } else {
            if (str.startsWith("~")) {
                str = IoUtil.USER_HOME + str.substring(1);
            }
            basedir = new File(IoUtil.expandFilepath(str)).getAbsolutePath();
            LOG.info("use basedir '{}', ", (Object)basedir);
        }
    }

    private XipkiBaseDir() {
    }

    public static final String basedir() {
        return basedir;
    }
}

