/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.util;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Calendar;
import java.util.Date;
import org.xipki.util.StringUtil;

public class DateUtil {
    private static final ZoneId ZONE_UTC = ZoneId.of("UTC");
    private static final DateTimeFormatter SDF1 = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
    private static final DateTimeFormatter SDF2 = DateTimeFormatter.ofPattern("yyyyMMdd");

    private DateUtil() {
    }

    public static Date parseUtcTimeyyyyMMddhhmmss(String utcTime) {
        char ch;
        String coreUtcTime = utcTime;
        if (StringUtil.isNotBlank(utcTime) && ((ch = utcTime.charAt(utcTime.length() - 1)) == 'z' || ch == 'Z')) {
            coreUtcTime = utcTime.substring(0, utcTime.length() - 1);
        }
        if (coreUtcTime == null || coreUtcTime.length() != 14) {
            throw new IllegalArgumentException("invalid utcTime '" + utcTime + "'");
        }
        try {
            LocalDateTime localDate = LocalDateTime.parse(coreUtcTime, SDF1);
            Instant instant = localDate.atZone(ZONE_UTC).toInstant();
            return Date.from(instant);
        }
        catch (DateTimeParseException ex) {
            throw new IllegalArgumentException("invalid utcTime '" + utcTime + "': " + ex.getMessage());
        }
    }

    public static Date parseUtcTimeyyyyMMdd(String utcTime) {
        char ch;
        String coreUtcTime = utcTime;
        if (StringUtil.isNotBlank(utcTime) && ((ch = utcTime.charAt(utcTime.length() - 1)) == 'z' || ch == 'Z')) {
            coreUtcTime = utcTime.substring(0, utcTime.length() - 1);
        }
        if (coreUtcTime == null || coreUtcTime.length() != 8) {
            throw new IllegalArgumentException("invalid utcTime '" + utcTime + "'");
        }
        try {
            LocalDateTime localDate = LocalDateTime.parse(coreUtcTime + "000000", SDF1);
            return Date.from(localDate.atZone(ZONE_UTC).toInstant());
        }
        catch (DateTimeParseException ex) {
            throw new IllegalArgumentException("invalid utcTime '" + utcTime + "': " + ex.getMessage());
        }
    }

    public static String toUtcTimeyyyyMMddhhmmss(Date utcTime) {
        return SDF1.format(utcTime.toInstant().atZone(ZONE_UTC));
    }

    public static String toUtcTimeyyyyMMdd(Date utcTime) {
        return SDF2.format(utcTime.toInstant().atZone(ZONE_UTC));
    }

    public static long getLastMsOfDay(Calendar cal) {
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        return cal.getTimeInMillis();
    }

    public static int getYyyyMMdd(Calendar cal) {
        return cal.get(1) * 10000 + (1 + cal.get(2)) * 100 + cal.get(5);
    }
}

