/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.xipki.util.Base64;
import org.xipki.util.Curl;
import org.xipki.util.IoUtil;
import org.xipki.util.StringUtil;
import org.xipki.util.exception.ObjectCreationException;
import org.xipki.util.http.SslContextConf;

public class DefaultCurl
implements Curl {
    private SSLSocketFactory sslSocketFactory;
    private HostnameVerifier hostnameVerifier;
    private final SslContextConf sslContextConf;
    private boolean initialized;
    private ObjectCreationException initException;

    public DefaultCurl(SslContextConf sslContextConf) {
        this.sslContextConf = sslContextConf;
    }

    private synchronized void initIfNotDone() throws ObjectCreationException {
        if (this.initException != null) {
            throw this.initException;
        }
        if (this.initialized) {
            return;
        }
        if (this.sslContextConf != null && this.sslContextConf.isUseSslConf()) {
            try {
                this.sslSocketFactory = this.sslContextConf.getSslSocketFactory();
                this.hostnameVerifier = this.sslContextConf.buildHostnameVerifier();
            }
            catch (ObjectCreationException ex) {
                this.initException = new ObjectCreationException("could not initialize DefaultCurl: " + ex.getMessage(), ex);
                throw this.initException;
            }
        }
        this.initialized = true;
    }

    private static void println(String text) {
        System.out.println(text);
    }

    @Override
    public Curl.CurlResult curlGet(String url, boolean verbose, Map<String, String> headers, String userPassword) throws Exception {
        this.checkUserPassword(userPassword);
        return this.curlGet(url, null, verbose, headers, userPassword);
    }

    @Override
    public Curl.CurlResult curlGet(String url, OutputStream respContentStream, boolean verbose, Map<String, String> headers, String userPassword) throws Exception {
        return this.curl(false, url, respContentStream, verbose, headers, userPassword, null);
    }

    @Override
    public Curl.CurlResult curlPost(String url, boolean verbose, Map<String, String> headers, String userPassword, byte[] content) throws Exception {
        return this.curlPost(url, null, verbose, headers, userPassword, content);
    }

    @Override
    public Curl.CurlResult curlPost(String url, OutputStream respContentStream, boolean verbose, Map<String, String> headers, String userPassword, byte[] content) throws Exception {
        return this.curl(true, url, respContentStream, verbose, headers, userPassword, content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private Curl.CurlResult curl(boolean post, String url, OutputStream respContentStream, boolean verbose, Map<String, String> headers, String userPassword, byte[] content) throws Exception {
        if (!post && content != null) {
            throw new IllegalArgumentException("method GET cannot be used to transfer non-empty content");
        }
        this.checkUserPassword(userPassword);
        this.initIfNotDone();
        URL newUrl = new URL(url);
        HttpURLConnection httpConn = IoUtil.openHttpConn(newUrl);
        if (httpConn instanceof HttpsURLConnection) {
            if (this.sslSocketFactory != null) {
                ((HttpsURLConnection)httpConn).setSSLSocketFactory(this.sslSocketFactory);
            }
            if (this.hostnameVerifier != null) {
                ((HttpsURLConnection)httpConn).setHostnameVerifier(this.hostnameVerifier);
            }
        }
        try {
            void var13_26;
            void var12_20;
            Map<String, List<String>> properties;
            httpConn.setRequestMethod(post ? "POST" : "GET");
            httpConn.setUseCaches(false);
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    String string = entry.getValue();
                    httpConn.setRequestProperty(entry.getKey(), string);
                }
            }
            if (userPassword != null) {
                httpConn.setRequestProperty("Authorization", "Basic " + Base64.encodeToString(StringUtil.toUtf8Bytes(userPassword)));
            }
            if (content == null) {
                properties = httpConn.getRequestProperties();
            } else {
                httpConn.setDoOutput(true);
                httpConn.setRequestProperty("Content-Length", Integer.toString(content.length));
                properties = httpConn.getRequestProperties();
                OutputStream outputstream = httpConn.getOutputStream();
                outputstream.write(content);
                outputstream.flush();
            }
            if (verbose) {
                DefaultCurl.println("=====request=====");
                DefaultCurl.println("  HTTP method: " + httpConn.getRequestMethod());
                for (Map.Entry entry : properties.entrySet()) {
                    for (String value : (List)entry.getValue()) {
                        DefaultCurl.println("  " + (String)entry.getKey() + ": " + value);
                    }
                }
            }
            int respCode = httpConn.getResponseCode();
            if (verbose) {
                DefaultCurl.println("=====response=====");
                DefaultCurl.println("  response code: " + respCode + " " + httpConn.getResponseMessage());
                properties = httpConn.getHeaderFields();
                for (Map.Entry<String, List<String>> entry : properties.entrySet()) {
                    String key = entry.getKey();
                    if (key == null) continue;
                    List<String> values = entry.getValue();
                    for (String value : values) {
                        DefaultCurl.println("  " + key + ": " + value);
                    }
                }
                DefaultCurl.println("=====response content=====");
            } else if (respCode != 200) {
                DefaultCurl.println("ERROR: bad response: " + httpConn.getResponseCode() + "    " + httpConn.getResponseMessage());
            }
            Object var12_18 = null;
            Object var13_24 = null;
            try {
                InputStream inputStream = httpConn.getInputStream();
            }
            catch (IOException ex) {
                InputStream inputStream = httpConn.getErrorStream();
            }
            Curl.CurlResult result = new Curl.CurlResult();
            result.setContentType(httpConn.getHeaderField("Content-Type"));
            if (var12_20 != null) {
                if (respContentStream == null) {
                    result.setContent(IoUtil.read((InputStream)var12_20));
                } else {
                    int read;
                    byte[] buffer = new byte[8192];
                    int contentLength = 0;
                    while ((read = var12_20.read(buffer)) != -1) {
                        contentLength += read;
                        respContentStream.write(buffer, 0, read);
                    }
                    result.setContentLength(contentLength);
                }
            } else if (var13_26 != null) {
                result.setErrorContent(IoUtil.read((InputStream)var13_26));
            }
            Curl.CurlResult curlResult = result;
            return curlResult;
        }
        finally {
            httpConn.disconnect();
        }
    }

    private void checkUserPassword(String userPassword) {
        if (userPassword == null) {
            return;
        }
        int idx = userPassword.indexOf(58);
        if (idx == -1 || idx == userPassword.length() - 1) {
            throw new IllegalArgumentException("invalid userPassword");
        }
    }
}

