/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.util;

public class Hex {
    private static final char[] DIGITS;
    private static final char[] UPPER_DIGITS;
    private static final int[] LINTS;
    private static final int[] HINTS;

    public static String encode(byte[] bytes) {
        return new String(Hex.encodeToChars(bytes));
    }

    public static char[] encodeToChars(byte[] data) {
        int len = data.length;
        char[] out = new char[len << 1];
        int j = 0;
        for (int i = 0; i < len; ++i) {
            out[j++] = DIGITS[(0xF0 & data[i]) >>> 4];
            out[j++] = DIGITS[0xF & data[i]];
        }
        return out;
    }

    public static String encodeUpper(byte[] bytes) {
        return new String(Hex.encodeToUpperChars(bytes));
    }

    public static char[] encodeToUpperChars(byte[] data) {
        int len = data.length;
        char[] out = new char[len << 1];
        int j = 0;
        for (int i = 0; i < len; ++i) {
            out[j++] = UPPER_DIGITS[(0xF0 & data[i]) >>> 4];
            out[j++] = UPPER_DIGITS[0xF & data[i]];
        }
        return out;
    }

    public static byte[] decode(byte[] array) {
        int len = array.length;
        if ((len & 1) != 0) {
            throw new IllegalArgumentException("Odd number of characters.");
        }
        byte[] out = new byte[len >> 1];
        int i = 0;
        int j = 0;
        while (j < len) {
            out[i] = (byte)(HINTS[0xFF & array[j++]] | LINTS[0xFF & array[j++]]);
            ++i;
        }
        return out;
    }

    public static byte[] decode(String hex) {
        return Hex.decode(hex.toCharArray());
    }

    public static byte[] decode(char[] data) {
        int len = data.length;
        if ((len & 1) != 0) {
            throw new IllegalArgumentException("Odd number of characters.");
        }
        byte[] out = new byte[len >> 1];
        int i = 0;
        int j = 0;
        while (j < len) {
            out[i] = (byte)(HINTS[data[j++]] | LINTS[data[j++]]);
            ++i;
        }
        return out;
    }

    public static byte decodeSingle(byte[] array, int offset) {
        return (byte)(HINTS[0xFF & array[offset]] | LINTS[0xFF & array[offset + 1]]);
    }

    static {
        int i;
        DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        UPPER_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        LINTS = new int[103];
        HINTS = new int[LINTS.length];
        for (i = 0; i < DIGITS.length; ++i) {
            Hex.LINTS[Hex.DIGITS[i]] = i;
        }
        for (i = 10; i < UPPER_DIGITS.length; ++i) {
            Hex.LINTS[Hex.UPPER_DIGITS[i]] = i;
        }
        for (i = 0; i < LINTS.length; ++i) {
            Hex.HINTS[i] = LINTS[i] << 4;
        }
    }
}

