/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.util;

import java.util.Calendar;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.xipki.util.StringUtil;

public class ProcessLog {
    private static final long MS_900 = 900L;
    private static final long DAY_IN_SEC = 86400L;
    private static final int DURATION_LEN = 10;
    private static final int PERCENT_LEN = 6;
    private static final int SPEED_LEN = 10;
    private static final int TIME_LEN = 10;
    private static final int TOTAL_LEN = 15;
    private long total;
    private boolean hasTotal;
    private long startTimeMs;
    private long endTimeMs;
    private AtomicLong numProcessed;
    private AtomicLong lastPrintTimeMs;
    private final AtomicBoolean finished = new AtomicBoolean(false);
    private long totalElapsedTimeMs;
    private int totalAverageSpeed;
    private final ConcurrentLinkedDeque<MeasurePoint> measureDeque = new ConcurrentLinkedDeque();

    public ProcessLog(long total) {
        this.total = total;
        this.reset();
    }

    public void printHeader() {
        StringBuilder sb = new StringBuilder();
        int lineLength = this.getLineLength();
        for (int i = 0; i < lineLength; ++i) {
            sb.append('-');
        }
        sb.append('\n');
        sb.append(ProcessLog.formatText("", 15));
        if (this.hasTotal) {
            sb.append(ProcessLog.formatText("", 6));
        }
        sb.append(ProcessLog.formatText("average", 10)).append(ProcessLog.formatText("current", 10)).append(ProcessLog.formatText("time", 10));
        if (this.hasTotal) {
            sb.append(ProcessLog.formatText("time", 10)).append(ProcessLog.formatText("finish", 10));
        }
        sb.append('\n');
        sb.append(StringUtil.formatText("total", 15));
        if (this.hasTotal) {
            sb.append(ProcessLog.formatText("%", 6));
        }
        sb.append(ProcessLog.formatText("speed", 10)).append(ProcessLog.formatText("speed", 10)).append(ProcessLog.formatText("spent", 10));
        if (this.hasTotal) {
            sb.append(ProcessLog.formatText("left", 10)).append(ProcessLog.formatText("at", 10));
        }
        sb.append('\n');
        System.out.println(sb.toString());
        System.out.flush();
    }

    public void finish() {
        this.finished.set(true);
        this.endTimeMs = System.currentTimeMillis();
        this.totalElapsedTimeMs = this.endTimeMs - this.startTimeMs;
        this.totalAverageSpeed = 0;
        if (this.totalElapsedTimeMs > 0L) {
            this.totalAverageSpeed = (int)(this.numProcessed.get() * 1000L / this.totalElapsedTimeMs);
        }
    }

    public void printTrailer() {
        this.finish();
        this.printStatus(true);
        StringBuilder sb = new StringBuilder().append('\n');
        int lineLength = this.getLineLength();
        for (int i = 0; i < lineLength; ++i) {
            sb.append('-');
        }
        System.out.println(sb.toString());
        System.out.flush();
    }

    public long numProcessed() {
        return this.numProcessed.get();
    }

    public long total() {
        return this.total;
    }

    public void total(long total) {
        this.total = total;
    }

    public final void reset() {
        this.startTimeMs = System.currentTimeMillis();
        this.numProcessed = new AtomicLong(0L);
        this.lastPrintTimeMs = new AtomicLong(0L);
        this.measureDeque.clear();
        this.measureDeque.add(new MeasurePoint(this.startTimeMs, 0L));
        this.hasTotal = this.total > 0L;
    }

    public long startTimeMs() {
        return this.startTimeMs;
    }

    public long endTimeMs() {
        return this.endTimeMs;
    }

    public long addNumProcessed(long numProcessed) {
        return this.numProcessed.addAndGet(numProcessed);
    }

    public void printStatus() {
        this.printStatus(false);
    }

    private void printStatus(boolean forcePrint) {
        long nowMs = System.currentTimeMillis();
        long tmpNumProcessed = this.numProcessed.get();
        if (!forcePrint && nowMs - this.lastPrintTimeMs.get() < 900L) {
            return;
        }
        this.measureDeque.addLast(new MeasurePoint(nowMs, this.numProcessed.get()));
        this.lastPrintTimeMs.set(nowMs);
        int numMeasurePoints = this.measureDeque.size();
        MeasurePoint referenceMeasurePoint = numMeasurePoints > 10 ? this.measureDeque.removeFirst() : this.measureDeque.getFirst();
        StringBuilder sb = new StringBuilder("\r");
        sb.append(StringUtil.formatAccount(tmpNumProcessed, 15));
        if (this.hasTotal) {
            int percent = (int)(tmpNumProcessed * 100L / this.total);
            sb.append(ProcessLog.formatText(percent + "%", 6));
        }
        long averageSpeed = 0L;
        long elapsedTimeMs = nowMs - this.startTimeMs;
        if (elapsedTimeMs > 0L) {
            averageSpeed = tmpNumProcessed * 1000L / elapsedTimeMs;
        }
        sb.append(StringUtil.formatAccount(averageSpeed, 10));
        long currentSpeed = 0L;
        long t2inms = nowMs - referenceMeasurePoint.measureTime;
        if (t2inms > 0L) {
            currentSpeed = (tmpNumProcessed - referenceMeasurePoint.measureAccount) * 1000L / t2inms;
        }
        sb.append(StringUtil.formatAccount(currentSpeed, 10));
        sb.append(StringUtil.formatTime(elapsedTimeMs / 1000L, 10));
        if (this.hasTotal) {
            long remaingTimeMs = -1L;
            if (currentSpeed > 0L) {
                remaingTimeMs = (this.total - tmpNumProcessed) * 1000L / currentSpeed;
            }
            long finishAtMs = -1L;
            if (remaingTimeMs != -1L) {
                finishAtMs = nowMs + remaingTimeMs;
            }
            if (remaingTimeMs < 1L) {
                sb.append(ProcessLog.formatText("--", 10));
            } else {
                sb.append(StringUtil.formatTime(remaingTimeMs / 1000L, 10));
            }
            if (remaingTimeMs < 1L) {
                sb.append(ProcessLog.formatText("--", 10));
            } else {
                sb.append(ProcessLog.buildDateTime(finishAtMs));
            }
        }
        System.out.print(sb.toString());
        System.out.flush();
    }

    public long totalElapsedTime() {
        if (this.finished.get()) {
            return this.totalElapsedTimeMs;
        }
        return System.currentTimeMillis() - this.startTimeMs;
    }

    public int totalAverageSpeed() {
        if (this.finished.get()) {
            return this.totalAverageSpeed;
        }
        long elapsedTimeMs = System.currentTimeMillis() - this.startTimeMs;
        int averageSpeed = 0;
        if (elapsedTimeMs > 0L) {
            averageSpeed = (int)(this.numProcessed.get() * 1000L / elapsedTimeMs);
        }
        return averageSpeed;
    }

    private static String formatText(String text, int minLen) {
        return StringUtil.formatText(text, minLen);
    }

    private static String buildDateTime(long timeMs) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(timeMs);
        StringBuilder sb = new StringBuilder();
        int hour = cal.get(11);
        if (hour < 10) {
            sb.append('0');
        }
        sb.append(hour);
        int minute = cal.get(12);
        sb.append(":");
        if (minute < 10) {
            sb.append('0');
        }
        sb.append(minute);
        int second = cal.get(13);
        sb.append(":");
        if (second < 10) {
            sb.append('0');
        }
        sb.append(second);
        Calendar midNight = Calendar.getInstance();
        midNight.set(11, 0);
        midNight.set(12, 0);
        midNight.set(13, 0);
        long midNightSec = midNight.getTimeInMillis() / 1000L;
        long days = (timeMs / 1000L - midNightSec) / 86400L;
        if (days > 0L) {
            sb.append('+').append(days > 9L ? "x" : Long.toString(days));
        }
        int size = sb.length();
        for (int i = 0; i < 10 - size; ++i) {
            sb.insert(0, ' ');
        }
        return sb.toString();
    }

    private int getLineLength() {
        int len = 15;
        if (this.hasTotal) {
            len += 6;
        }
        len += 30;
        if (this.hasTotal) {
            len += 20;
        }
        return len;
    }

    private static class MeasurePoint {
        private final long measureTime;
        private final long measureAccount;

        public MeasurePoint(long measureTime, long measureAccount) {
            this.measureTime = measureTime;
            this.measureAccount = measureAccount;
        }
    }
}

