/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.util.concurrent;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.util.concurrent.ClockSource;
import org.xipki.util.concurrent.ConcurrentBagEntry;
import org.xipki.util.concurrent.FastList;

public class ConcurrentBag<T extends ConcurrentBagEntry>
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(ConcurrentBag.class);
    private final CopyOnWriteArrayList<T> sharedList;
    private final boolean weakThreadLocals = this.useWeakThreadLocals();
    private final ThreadLocal<List<Object>> threadList;
    private final AtomicInteger waiters;
    private volatile boolean closed;
    private final SynchronousQueue<T> handoffQueue = new SynchronousQueue(true);
    private static int STATE_NOT_IN_USE = 0;
    private static int STATE_IN_USE = 1;
    private static int STATE_REMOVED = -1;
    private static int STATE_RESERVED = -2;

    public ConcurrentBag() {
        this.waiters = new AtomicInteger();
        this.sharedList = new CopyOnWriteArrayList();
        this.threadList = this.weakThreadLocals ? ThreadLocal.withInitial(() -> new ArrayList(16)) : ThreadLocal.withInitial(() -> new FastList(ConcurrentBagEntry.class, 16));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T borrow(long timeout, TimeUnit timeUnit) throws InterruptedException {
        List<Object> list = this.threadList.get();
        for (int i = list.size() - 1; i >= 0; --i) {
            ConcurrentBagEntry bagEntry;
            Iterator<T> entry = list.remove(i);
            ConcurrentBagEntry concurrentBagEntry = bagEntry = this.weakThreadLocals ? (ConcurrentBagEntry)((WeakReference)((Object)entry)).get() : (ConcurrentBagEntry)((Object)entry);
            if (bagEntry == null || !bagEntry.compareAndSet(STATE_NOT_IN_USE, STATE_IN_USE)) continue;
            return (T)bagEntry;
        }
        int waiting = this.waiters.incrementAndGet();
        try {
            long start;
            for (ConcurrentBagEntry bagEntry : this.sharedList) {
                if (!bagEntry.compareAndSet(STATE_NOT_IN_USE, STATE_IN_USE)) continue;
                ConcurrentBagEntry concurrentBagEntry = bagEntry;
                return (T)concurrentBagEntry;
            }
            timeout = timeUnit.toNanos(timeout);
            do {
                start = ClockSource.currentTime();
                ConcurrentBagEntry bagEntry = (ConcurrentBagEntry)this.handoffQueue.poll(timeout, TimeUnit.NANOSECONDS);
                if (bagEntry != null && !bagEntry.compareAndSet(STATE_NOT_IN_USE, STATE_IN_USE)) continue;
                ConcurrentBagEntry concurrentBagEntry = bagEntry;
                return (T)concurrentBagEntry;
            } while ((timeout -= ClockSource.elapsedNanos(start)) > 10000L);
            T t = null;
            return t;
        }
        finally {
            this.waiters.decrementAndGet();
        }
    }

    public void requite(T bagEntry) {
        ((ConcurrentBagEntry)bagEntry).setState(STATE_NOT_IN_USE);
        int i = 0;
        while (this.waiters.get() > 0) {
            if (((ConcurrentBagEntry)bagEntry).getState() != STATE_NOT_IN_USE || this.handoffQueue.offer(bagEntry)) {
                return;
            }
            if ((i & 0x100) == 256) {
                LockSupport.parkNanos(TimeUnit.MICROSECONDS.toNanos(10L));
            } else {
                Thread.yield();
            }
            ++i;
        }
        List<Object> threadLocalList = this.threadList.get();
        threadLocalList.add(this.weakThreadLocals ? new WeakReference<T>(bagEntry) : bagEntry);
    }

    public void add(T bagEntry) {
        if (this.closed) {
            LOG.info("ConcurrentBag has been closed, ignoring add()");
            throw new IllegalStateException("ConcurrentBag has been closed, ignoring add()");
        }
        this.sharedList.add(bagEntry);
        while (this.waiters.get() > 0 && !this.handoffQueue.offer(bagEntry)) {
            Thread.yield();
        }
    }

    public boolean remove(T bagEntry) {
        if (!(((ConcurrentBagEntry)bagEntry).compareAndSet(STATE_IN_USE, STATE_REMOVED) || ((ConcurrentBagEntry)bagEntry).compareAndSet(STATE_RESERVED, STATE_REMOVED) || this.closed)) {
            LOG.warn("Attempt to remove an object from the bag that was not borrowed or reserved: {}", bagEntry);
            return false;
        }
        boolean removed = this.sharedList.remove(bagEntry);
        if (!removed && !this.closed) {
            LOG.warn("Attempt to remove an object from the bag that does not exist: {}", bagEntry);
        }
        return removed;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    public List<T> values(int state) {
        List list = this.sharedList.stream().filter(e -> e.getState() == state).collect(Collectors.toList());
        Collections.reverse(list);
        return list;
    }

    public List<T> values() {
        return (List)this.sharedList.clone();
    }

    public boolean reserve(T bagEntry) {
        return ((ConcurrentBagEntry)bagEntry).compareAndSet(STATE_NOT_IN_USE, STATE_RESERVED);
    }

    public void unreserve(T bagEntry) {
        if (((ConcurrentBagEntry)bagEntry).compareAndSet(STATE_RESERVED, STATE_NOT_IN_USE)) {
            while (this.waiters.get() > 0 && !this.handoffQueue.offer(bagEntry)) {
                Thread.yield();
            }
        } else {
            LOG.warn("Attempt to relinquish an object to the bag that was not reserved: {}", bagEntry);
        }
    }

    public int getWaitingThreadCount() {
        return this.waiters.get();
    }

    public int getCount(int state) {
        int count = 0;
        for (ConcurrentBagEntry e : this.sharedList) {
            if (e.getState() != state) continue;
            ++count;
        }
        return count;
    }

    public int[] getStateCounts() {
        int[] states = new int[6];
        for (ConcurrentBagEntry e : this.sharedList) {
            int n = e.getState();
            states[n] = states[n] + 1;
        }
        states[4] = this.sharedList.size();
        states[5] = this.waiters.get();
        return states;
    }

    public int size() {
        return this.sharedList.size();
    }

    public void dumpState() {
        this.sharedList.forEach(entry -> LOG.info(entry.toString()));
    }

    private boolean useWeakThreadLocals() {
        try {
            if (System.getProperty("org.xipki.useWeakReferences") != null) {
                return Boolean.getBoolean("org.xipki.useWeakReferences");
            }
            return this.getClass().getClassLoader() != ClassLoader.getSystemClassLoader();
        }
        catch (SecurityException se) {
            return true;
        }
    }
}

