/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.util.http;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.StringTokenizer;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.xipki.util.Base64;
import org.xipki.util.CompareUtil;
import org.xipki.util.FileOrBinary;
import org.xipki.util.StringUtil;
import org.xipki.util.exception.ObjectCreationException;
import org.xipki.util.http.HostnameVerifiers;
import org.xipki.util.http.SSLContextBuilder;
import org.xipki.util.http.SslConf;

public class SslContextConf {
    private static final byte[] PEM_PREFIX = StringUtil.toUtf8Bytes("-----BEGIN");
    private boolean useSslConf = true;
    private String sslStoreType;
    private FileOrBinary sslKeystore;
    private String sslKeystorePassword;
    private FileOrBinary[] sslTrustanchors;
    private String sslHostnameVerifier;
    private SSLContext sslContext;
    private SSLSocketFactory sslSocketFactory;

    public static SslContextConf ofSslConf(SslConf ssl) {
        SslContextConf sslCc = new SslContextConf();
        sslCc.setSslStoreType(ssl.getStoreType());
        if (ssl.getKeystore() != null) {
            sslCc.setSslKeystore(ssl.getKeystore());
            sslCc.setSslKeystorePassword(ssl.getKeystorePassword());
        }
        if (ssl.getTrustanchors() != null) {
            sslCc.setSslTrustanchors(ssl.getTrustanchors());
        }
        sslCc.setSslHostnameVerifier(ssl.getHostnameVerifier());
        return sslCc;
    }

    public boolean isUseSslConf() {
        return this.useSslConf;
    }

    public void setUseSslConf(boolean useSslConf) {
        this.useSslConf = useSslConf;
    }

    public String getSslStoreType() {
        return this.sslStoreType;
    }

    public void setSslStoreType(String sslStoreType) {
        this.sslStoreType = SslContextConf.emptyAsNull(sslStoreType);
    }

    public FileOrBinary getSslKeystore() {
        return this.sslKeystore;
    }

    public void setSslKeystore(String sslKeystore) {
        String storeFile = SslContextConf.emptyAsNull(sslKeystore);
        if (storeFile == null) {
            this.sslKeystore = null;
        } else {
            this.setSslKeystore(FileOrBinary.ofFile(storeFile));
        }
    }

    public void setSslKeystore(FileOrBinary sslKeystore) {
        this.sslKeystore = sslKeystore;
    }

    public String getSslKeystorePassword() {
        return this.sslKeystorePassword;
    }

    public void setSslKeystorePassword(String sslKeystorePassword) {
        this.sslKeystorePassword = SslContextConf.emptyAsNull(sslKeystorePassword);
    }

    public FileOrBinary[] getSslTrustanchors() {
        return this.sslTrustanchors;
    }

    public void setSslTrustanchors(String sslTrustanchors) {
        if ((sslTrustanchors = SslContextConf.emptyAsNull(sslTrustanchors)) == null) {
            this.sslTrustanchors = null;
            return;
        }
        StringTokenizer tokens = new StringTokenizer(sslTrustanchors, ",;:");
        FileOrBinary[] fbs = new FileOrBinary[tokens.countTokens()];
        for (int i = 0; i < fbs.length; ++i) {
            fbs[i] = FileOrBinary.ofFile(tokens.nextToken());
        }
        this.setSslTrustanchors(fbs);
    }

    public void setSslTrustanchors(FileOrBinary[] sslTrustanchors) {
        this.sslTrustanchors = sslTrustanchors;
    }

    public String getSslHostnameVerifier() {
        return this.sslHostnameVerifier;
    }

    public void setSslHostnameVerifier(String sslHostnameVerifier) {
        this.sslHostnameVerifier = SslContextConf.emptyAsNull(sslHostnameVerifier);
    }

    public SSLContext getSslContext() throws ObjectCreationException {
        if (!this.useSslConf) {
            return null;
        }
        if (this.sslContext == null) {
            SSLContextBuilder builder = new SSLContextBuilder();
            if (this.sslStoreType != null) {
                builder.setKeyStoreType(this.sslStoreType);
            }
            try {
                if (this.sslKeystore != null) {
                    char[] password = this.sslKeystorePassword == null ? null : this.sslKeystorePassword.toCharArray();
                    try (ByteArrayInputStream is = new ByteArrayInputStream(this.sslKeystore.readContent());){
                        builder.loadKeyMaterial(is, password, password);
                    }
                }
                if (this.sslTrustanchors != null && this.sslTrustanchors.length != 0) {
                    KeyStore ks = KeyStore.getInstance("JKS");
                    ks.load(null, "any".toCharArray());
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    int idx = 1;
                    for (FileOrBinary fb : this.sslTrustanchors) {
                        byte[] bytes = fb.readContent();
                        if (CompareUtil.areEqual(bytes, 0, PEM_PREFIX, 0, PEM_PREFIX.length)) {
                            String line;
                            BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(bytes)));
                            StringBuilder sb = null;
                            while ((line = reader.readLine()) != null) {
                                if (line.equals("-----BEGIN CERTIFICATE-----")) {
                                    sb = new StringBuilder(1000);
                                    continue;
                                }
                                if (line.equals("-----END CERTIFICATE-----")) {
                                    if (sb == null) continue;
                                    byte[] certBytes = Base64.decode(sb.toString());
                                    sb = null;
                                    ks.setCertificateEntry("cert-" + idx++, SslContextConf.parseCert(cf, certBytes));
                                    continue;
                                }
                                if (sb == null) continue;
                                sb.append(line);
                            }
                            continue;
                        }
                        ks.setCertificateEntry("cert-" + idx++, SslContextConf.parseCert(cf, bytes));
                    }
                    builder.loadTrustMaterial(ks);
                }
                this.sslContext = builder.build();
            }
            catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException ex) {
                throw new ObjectCreationException("could not build SSLContext: " + ex.getMessage(), ex);
            }
        }
        return this.sslContext;
    }

    private static Certificate parseCert(CertificateFactory fact, byte[] certBytes) throws CertificateException, IOException {
        try (ByteArrayInputStream certIs = new ByteArrayInputStream(certBytes);){
            Certificate certificate = fact.generateCertificate(certIs);
            return certificate;
        }
    }

    public SSLSocketFactory getSslSocketFactory() throws ObjectCreationException {
        if (!this.useSslConf) {
            return null;
        }
        if (this.sslSocketFactory == null) {
            this.getSslContext();
            this.sslSocketFactory = this.sslContext.getSocketFactory();
        }
        return this.sslSocketFactory;
    }

    public HostnameVerifier buildHostnameVerifier() throws ObjectCreationException {
        if (!this.useSslConf) {
            return null;
        }
        return HostnameVerifiers.createHostnameVerifier(this.sslHostnameVerifier);
    }

    private static String emptyAsNull(String text) {
        if (text == null) {
            return null;
        }
        if (text.trim().isEmpty()) {
            return null;
        }
        return text;
    }
}

