/*
 * Decompiled with CFR 0.152.
 */
package org.xsnake.cloud.dao;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.ArgumentPreparedStatementSetter;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.CallableStatementCallback;
import org.springframework.jdbc.core.ColumnMapRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.RowMapperResultSetExtractor;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.xsnake.cloud.dao.Dialect;
import org.xsnake.cloud.dao.Page;

@Configuration
public class DaoTemplate {
    private static final Log logger = LogFactory.getLog(DaoTemplate.class);
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    Dialect dialect;

    public int execute(String sql) {
        return this.execute(sql, null);
    }

    public int execute(String sql, Object[] args) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\u6267\u884c\u7684SQL\u8bed\u53e5 \uff1a[ " + sql + "] \u53c2\u6570\u4e3a\uff1a [" + args == null ? "null" : String.valueOf(Arrays.toString(args)) + "] "));
        }
        return this.jdbcTemplate.update(sql, args);
    }

    public int[] batchExecute(String sql, List<Object[]> args) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\u6279\u91cf\u6267\u884c\u7684SQL\u8bed\u53e5 \uff1a[ " + sql + "] "));
        }
        return this.jdbcTemplate.batchUpdate(sql, args);
    }

    public List<Object> executeCall(String sql, final ProcedureParam[] args) {
        CallableStatementCallback<List<Object>> action = new CallableStatementCallback<List<Object>>(){

            public List<Object> doInCallableStatement(CallableStatement cs) throws SQLException, DataAccessException {
                ProcedureParam p;
                ArrayList<Object> result = new ArrayList<Object>();
                int i = 1;
                while (i < args.length + 1) {
                    p = args[i - 1];
                    if (p instanceof InProcedureParam) {
                        cs.setObject(i, p.value);
                    } else if (p instanceof OutProcedureParam) {
                        cs.registerOutParameter(i, p.type);
                    }
                    ++i;
                }
                cs.execute();
                i = 1;
                while (i < args.length + 1) {
                    p = args[i - 1];
                    if (p instanceof OutProcedureParam) {
                        result.add(cs.getString(i));
                    } else {
                        result.add(null);
                    }
                    ++i;
                }
                return result;
            }
        };
        return (List)this.jdbcTemplate.execute(sql, (CallableStatementCallback)action);
    }

    private String getPageSQL(String sql, int start, int end) {
        return this.dialect.getPageSql(sql, start, end);
    }

    public <T> List<T> queryList(String sql, Class<T> clazz) {
        return this.queryListForClass(sql, null, clazz);
    }

    public List<Map<String, Object>> queryList(String sql) {
        return this.queryListForMap(sql, null);
    }

    public <T> List<T> queryList(String sql, Object[] args, Class<T> clazz) {
        return this.queryListForClass(sql, args, clazz);
    }

    public List<Map<String, Object>> queryList(String sql, Object[] args) {
        return this.queryListForMap(sql, args);
    }

    public <T> List<T> queryList(String sql, int firstResult, int maxResults, Class<T> clazz) {
        return this.queryList(sql, null, firstResult, maxResults, clazz);
    }

    public List<Map<String, Object>> queryList(String sql, int firstResult, int maxResults) {
        return this.queryList(sql, null, firstResult, maxResults);
    }

    public <T> List<T> queryList(String sql, Object[] args, int firstResult, int maxResults, Class<T> clazz) {
        return this.queryListForClass(this.getPageSQL(sql, firstResult, firstResult + maxResults), args, clazz);
    }

    public List<Map<String, Object>> queryList(String sql, Object[] args, int firstResult, int maxResults) {
        return this.queryListForMap(this.getPageSQL(sql, firstResult, firstResult + maxResults), args);
    }

    public Map<String, Object> queryMap(String sql, Object[] args) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\u67e5\u8be2\u7684SQL\u8bed\u53e5 \uff1a[ " + sql + "] \u53c2\u6570\u4e3a\uff1a [" + Arrays.toString(args) + "]"));
        }
        return (Map)this.jdbcTemplate.queryForObject(sql, args, (RowMapper)new ColumnMapRowMapper());
    }

    public Map<String, Object> queryMapIgnoreError(String sql) {
        return this.queryMapIgnoreError(sql, null);
    }

    public Map<String, Object> queryMapIgnoreError(String sql, Object[] args) {
        try {
            return this.queryMap(sql, args);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    public <T> T queryObjectIgnoreError(String sql, Object[] args, Class<T> clazz) {
        try {
            return this.queryObject(sql, args, clazz);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    public <T> T queryObjectIgnoreError(String sql, Class<T> clazz) {
        return this.queryObjectIgnoreError(sql, null, clazz);
    }

    public <T> T queryObject(String sql, Object[] args, Class<T> clazz) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\u67e5\u8be2\u7684SQL\u8bed\u53e5 \uff1a[ " + sql + "] \u53c2\u6570\u4e3a\uff1a [" + Arrays.toString(args) + "] \u8f6c\u6362\u7684\u7c7b\uff1a [" + clazz.getName() + "]"));
        }
        Object rowMapper = null;
        rowMapper = String.class == clazz || Number.class.isAssignableFrom(clazz) ? new SingleColumnRowMapper(clazz) : new BeanPropertyRowMapper(clazz);
        return (T)this.jdbcTemplate.queryForObject(sql, args, (RowMapper)rowMapper);
    }

    public <T> T queryObject(String sql, Class<T> clazz) {
        return this.queryObject(sql, null, clazz);
    }

    public Map<String, Object> queryMap(String sql) {
        return this.queryMap(sql, null);
    }

    public Page<Map<String, Object>> queryPage(String sql, Object[] args, int currentPage, int pageSize) {
        try {
            String thql = "select count(1) from (" + sql + ") t ";
            BigDecimal _count = (BigDecimal)this.jdbcTemplate.queryForObject(thql, args, BigDecimal.class);
            int count = _count.intValue();
            List<Map<String, Object>> results = this.queryList(sql, args, (currentPage - 1) * pageSize, pageSize);
            return new Page<Map<String, Object>>(results, currentPage, pageSize, count);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <T> Page<T> queryPage(String sql, Object[] args, int currentPage, int pageSize, Class<T> clazz) {
        try {
            String thql = "select count(1) from (" + sql + ") t ";
            BigDecimal _count = (BigDecimal)this.jdbcTemplate.queryForObject(thql, args, BigDecimal.class);
            int count = _count.intValue();
            List<T> results = this.queryList(sql, args, (currentPage - 1) * pageSize, pageSize, clazz);
            return new Page<T>(results, currentPage, pageSize, count);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private List<Map<String, Object>> queryListForMap(String sql, Object[] args) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\u67e5\u8be2\u7684SQL\u8bed\u53e5 \uff1a[ " + sql + "] \u53c2\u6570\u4e3a\uff1a [" + Arrays.toString(args) + "]"));
        }
        return this.jdbcTemplate.queryForList(sql, args);
    }

    private <T> List<T> queryListForClass(String sql, Object[] args, Class<T> clazz) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\u67e5\u8be2\u7684SQL\u8bed\u53e5 \uff1a[ " + sql + "] \u53c2\u6570\u4e3a\uff1a [" + Arrays.toString(args) + "] \u8f6c\u6362\u7684\u7c7b\uff1a [" + clazz.getName() + "]"));
        }
        if (this.isSingleColumnClass(clazz)) {
            return this.jdbcTemplate.query(sql, (PreparedStatementSetter)new ArgumentPreparedStatementSetter(args), (RowMapper)new SingleColumnRowMapper(clazz));
        }
        return (List)this.jdbcTemplate.query(sql, (PreparedStatementSetter)new ArgumentPreparedStatementSetter(args), (ResultSetExtractor)new RowMapperResultSetExtractor((RowMapper)new BeanPropertyRowMapper(clazz)));
    }

    private boolean isSingleColumnClass(Class<?> requiredType) {
        return String.class == requiredType || Boolean.TYPE == requiredType || Boolean.class == requiredType || Byte.TYPE == requiredType || Byte.class == requiredType || Short.TYPE == requiredType || Short.class == requiredType || Integer.TYPE == requiredType || Integer.class == requiredType || Long.TYPE == requiredType || Long.class == requiredType || Float.TYPE == requiredType || Float.class == requiredType || Double.TYPE == requiredType || Double.class == requiredType || Number.class == requiredType || BigDecimal.class == requiredType || Date.class == requiredType || Time.class == requiredType || Timestamp.class == requiredType || java.util.Date.class == requiredType || byte[].class == requiredType || Blob.class == requiredType || Clob.class == requiredType;
    }

    public static class InProcedureParam
    extends ProcedureParam {
        public InProcedureParam(Object value) {
            super(-1, value);
        }
    }

    public static class OutProcedureParam
    extends ProcedureParam {
        public OutProcedureParam(int type) {
            super(type, null);
        }
    }

    public static abstract class ProcedureParam {
        int type;
        Object value;

        public ProcedureParam(int type, Object value) {
            this.type = type;
            this.value = value;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int type) {
            this.type = type;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }
    }
}

