/*
 * Decompiled with CFR 0.152.
 */
package org.xsnake.cloud.zookeeper;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.xsnake.cloud.zookeeper.ZookeeperConfiguration;

@Configuration
public class ZookeeperFactory {
    @Autowired
    ZookeeperConfiguration zookeeperConfiguration;
    private static final Logger LOG = LoggerFactory.getLogger(ZookeeperFactory.class);

    @Bean
    public ZooKeeper zooKeeper() throws IOException, TimeoutException {
        final long start = System.currentTimeMillis();
        final Long timeout = this.zookeeperConfiguration.getTimeout();
        final ZooKeeper zk = new ZooKeeper(this.zookeeperConfiguration.getUrl(), timeout.intValue(), new Watcher(){

            public void process(WatchedEvent event) {
            }
        });
        final CountDownLatch timeoutCountDownLatch = new CountDownLatch(1);
        new Thread(){

            @Override
            public void run() {
                while (true) {
                    if (System.currentTimeMillis() - start > timeout || zk.getState() == ZooKeeper.States.CONNECTED) break;
                    try {
                        TimeUnit.MILLISECONDS.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                timeoutCountDownLatch.countDown();
            }
        }.start();
        try {
            timeoutCountDownLatch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (zk.getState() != ZooKeeper.States.CONNECTED) {
            LOG.error("\u8fde\u63a5Zookeeper\u8d85\u65f6");
            throw new TimeoutException("\u8fde\u63a5\u8d85\u65f6");
        }
        LOG.info("\u8fde\u63a5Zookeeper\u6210\u529f");
        return zk;
    }
}

