/*
 * Decompiled with CFR 0.152.
 */
package org.xsnake.cloud.zookeeper;

import java.io.IOException;
import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ZookeeperTemplate {
    @Autowired
    protected ZooKeeper zooKeeper;

    public void tempDir(String node) throws KeeperException, InterruptedException, IOException {
        this.dir(node, null, CreateMode.EPHEMERAL);
    }

    public void tempDir(String node, String data) throws KeeperException, InterruptedException, IOException {
        this.dir(node, data, CreateMode.EPHEMERAL);
    }

    public void dir(String node) throws KeeperException, InterruptedException, IOException {
        this.dir(node, null, CreateMode.PERSISTENT);
    }

    public void dir(String node, String data) throws KeeperException, InterruptedException, IOException {
        this.dir(node, data, CreateMode.PERSISTENT);
    }

    public void dir(String path, String value, CreateMode createMode) throws KeeperException, InterruptedException, IOException {
        byte[] data;
        byte[] byArray = data = value != null ? value.getBytes() : null;
        if (this.zooKeeper.exists(path, null) == null) {
            this.zooKeeper.create(path, data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, createMode);
        } else {
            this.zooKeeper.setData(path, data, -1);
        }
    }

    public String dirData(String path) throws KeeperException, InterruptedException {
        byte[] data = this.zooKeeper.getData(path, null, null);
        if (data == null) {
            return null;
        }
        return new String(data);
    }

    public boolean exists(String path) throws KeeperException, InterruptedException {
        return this.zooKeeper.exists(path, null) != null;
    }

    public void delete(String path) throws InterruptedException, KeeperException {
        this.zooKeeper.delete(path, -1);
    }

    public void onChildrenChange(String path, Watcher watcher) throws KeeperException, InterruptedException {
        this.zooKeeper.getChildren(path, (Watcher)new PermanentWatcher(this.zooKeeper, path, watcher));
    }

    public List<String> getChildren(String path) throws KeeperException, InterruptedException {
        return this.zooKeeper.getChildren(path, null);
    }

    public static class PermanentWatcher
    implements Watcher {
        ZooKeeper zk;
        String path;
        Watcher watcher;

        public PermanentWatcher(ZooKeeper _zooKeeper, String path, Watcher watcher) {
            this.zk = _zooKeeper;
            this.path = path;
            this.watcher = watcher;
        }

        public void process(WatchedEvent event) {
            try {
                this.watcher.process(event);
                this.zk.getChildren(this.path, (Watcher)new PermanentWatcher(this.zk, this.path, this.watcher));
            }
            catch (KeeperException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

