/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket;

import java.io.IOException;
import java.net.InetAddress;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.ByteBufferQueue;
import org.xsocket.ByteBufferUtils;
import org.xsocket.ClosedConnectionException;
import org.xsocket.IConnection;
import org.xsocket.Index;
import org.xsocket.util.TextUtils;

public abstract class AbstractConnection
implements IConnection {
    private static final Logger LOG = Logger.getLogger(AbstractConnection.class.getName());
    private static final int DEBUG_MAX_OUTPUT_SIZE = 200;
    private String id = null;
    private String defaultEncoding = "UTF-8";
    private ByteBufferQueue receiveQueue = new ByteBufferQueue();
    private ByteBufferQueue sendQueue = new ByteBufferQueue();
    private boolean isReceiving = true;
    private long connectionOpenedTime = -1L;
    private long connectionEndTime = -1L;
    private long lastTimeReceived = this.connectionOpenedTime = System.currentTimeMillis();
    private long bytesReceived = 0L;
    private long bytesSend = 0L;

    public final void setId(String id) {
        this.id = id;
    }

    public final String getId() {
        return this.id;
    }

    public void setDefaultEncoding(String encoding) {
        this.defaultEncoding = encoding;
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public final int writeWord(String s) throws ClosedConnectionException, IOException {
        return this.writeWord(s, this.defaultEncoding);
    }

    public final int writeWord(String s, String encoding) throws ClosedConnectionException, IOException {
        ByteBuffer buffer = TextUtils.toByteBuffer(s, encoding);
        return this.write(buffer);
    }

    public int writeByte(byte b) throws ClosedConnectionException, IOException {
        return this.write(ByteBuffer.allocate(1).put(b));
    }

    public final int write(ByteBuffer buffer) throws ClosedConnectionException, IOException {
        return (int)this.write(new ByteBuffer[]{buffer});
    }

    public final int writeInt(int i) throws ClosedConnectionException, IOException {
        ByteBuffer buffer = ByteBuffer.allocate(4).putInt(i);
        buffer.flip();
        return this.write(buffer);
    }

    public final int writeLong(long l) throws ClosedConnectionException, IOException {
        ByteBuffer buffer = ByteBuffer.allocate(8).putLong(l);
        buffer.flip();
        return this.write(buffer);
    }

    public final int writeDouble(double d) throws ClosedConnectionException, IOException {
        ByteBuffer buffer = ByteBuffer.allocate(8).putDouble(d);
        buffer.flip();
        return this.write(buffer);
    }

    public abstract long write(ByteBuffer[] var1) throws ClosedConnectionException, IOException;

    protected final int addToSendQueue(ByteBuffer buffer) {
        this.sendQueue.offer(buffer);
        return buffer.limit() - buffer.position();
    }

    protected final synchronized ByteBuffer[] drainSendQueue() throws ClosedConnectionException, IOException {
        return this.sendQueue.drain();
    }

    protected final boolean isSendQueueEmpty() {
        return this.sendQueue.isEmpty();
    }

    protected final boolean isReceiveQueueEmpty() {
        return this.receiveQueue.isEmpty();
    }

    protected final synchronized long writePhysical(ByteBuffer[] buffersToWrite) throws ClosedConnectionException, IOException {
        if (this.isOpen()) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.getId() + "] sending: " + this.printByteBuffersForDebug(buffersToWrite));
            }
            long numberOfSendData = this.getAssignedSocketChannel().write(buffersToWrite);
            this.bytesSend += numberOfSendData;
            return numberOfSendData;
        }
        ClosedConnectionException cce = new ClosedConnectionException("[" + this.getId() + "] connection " + this.toCompactString() + " ist already closed. Couldn't write " + this.printData(buffersToWrite));
        LOG.throwing(this.getClass().getName(), "send(ByteBuffer[])", cce);
        throw cce;
    }

    protected final synchronized ByteBuffer[] drainReceiveQueue() throws IOException {
        return this.receiveQueue.drain();
    }

    protected final synchronized ByteBuffer[] readRecordFromReceiveReceiveQueue(String delimiter) throws IOException, BufferUnderflowException {
        Index index = ByteBufferUtils.find(this.receiveQueue, delimiter.getBytes());
        if (index != null) {
            ByteBuffer[] buffers = ByteBufferUtils.extract(this.receiveQueue, index);
            return buffers;
        }
        throw new BufferUnderflowException();
    }

    protected final String readWordFromReceiveQueue(String delimiter, String encoding) throws IOException, BufferUnderflowException {
        ByteBuffer[] buffer = this.readRecordFromReceiveReceiveQueue(delimiter);
        return TextUtils.toString(buffer, encoding);
    }

    protected final synchronized int readIntFromReceiveQueue() throws IOException, BufferUnderflowException {
        if (this.receiveQueue.getRemainingOfHeadElement() >= 4) {
            ByteBuffer buf = this.receiveQueue.poll();
            int i = buf.getInt();
            this.receiveQueue.offerHead(buf.slice());
            return i;
        }
        return ByteBuffer.wrap(this.read(4)).getInt();
    }

    protected final synchronized long readLongFromReceiveQueue() throws IOException, BufferUnderflowException {
        if (this.receiveQueue.getRemainingOfHeadElement() >= 8) {
            ByteBuffer buf = this.receiveQueue.poll();
            long l = buf.getLong();
            this.receiveQueue.offerHead(buf.slice());
            return l;
        }
        return ByteBuffer.wrap(this.read(8)).getLong();
    }

    protected final synchronized double readDoubleFromReceiveQueue() throws IOException, BufferUnderflowException {
        if (this.receiveQueue.getRemainingOfHeadElement() >= 8) {
            ByteBuffer buf = this.receiveQueue.poll();
            double d = buf.getDouble();
            this.receiveQueue.offerHead(buf.slice());
            return d;
        }
        return ByteBuffer.wrap(this.read(8)).getDouble();
    }

    protected final synchronized byte readByteFromReceiveQueue() throws IOException, BufferUnderflowException {
        if (this.receiveQueue.getRemainingOfHeadElement() >= 1) {
            ByteBuffer buf = this.receiveQueue.poll();
            byte b = buf.get();
            this.receiveQueue.offerHead(buf.slice());
            return b;
        }
        throw new BufferUnderflowException();
    }

    private synchronized byte[] read(int length) throws IOException {
        byte[] bytes = new byte[length];
        int pointer = 0;
        if (this.inputBytesAvailable(length)) {
            ByteBuffer buffer = this.receiveQueue.poll();
            while (true) {
                if (buffer.hasRemaining()) {
                    bytes[pointer] = buffer.get();
                    if (++pointer != length) continue;
                    if (buffer.position() < buffer.limit()) {
                        this.receiveQueue.offerHead(buffer.slice());
                    }
                    return bytes;
                }
                buffer = this.receiveQueue.poll();
                if (buffer == null) break;
            }
            throw new IOException("unexpected Buffer underflow occured");
        }
        throw new BufferUnderflowException();
    }

    private synchronized boolean inputBytesAvailable(int size) {
        int l = 0;
        for (ByteBuffer buffer : this.receiveQueue) {
            if ((l += buffer.limit() - buffer.position()) < size) continue;
            return true;
        }
        return false;
    }

    protected final synchronized int numberOfAvailableInputBytes() {
        int l = 0;
        for (ByteBuffer buffer : this.receiveQueue) {
            l += buffer.limit() - buffer.position();
        }
        return l;
    }

    protected final synchronized ByteBuffer readPhysical() throws ClosedConnectionException, IOException {
        ByteBuffer result = null;
        ByteBuffer allocatedBufferBlock = this.acquireMemory();
        int pos = allocatedBufferBlock.position();
        int limit = allocatedBufferBlock.limit();
        int read = 0;
        if (this.isOpen() && this.isReceiving) {
            try {
                read = this.getAssignedSocketChannel().read(allocatedBufferBlock);
            }
            catch (IOException ioe) {
                allocatedBufferBlock.position(pos);
                allocatedBufferBlock.limit(limit);
                this.recycleMemory(allocatedBufferBlock);
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.finer("[" + this.getId() + "] error occured while reading channel: " + ioe.toString());
                }
                throw ioe;
            }
            switch (read) {
                case -1: {
                    this.recycleMemory(allocatedBufferBlock);
                    ClosedConnectionException cce = new ClosedConnectionException("[" + this.getId() + "] End of stream reached");
                    LOG.throwing(this.getClass().getName(), "read()", cce);
                    throw cce;
                }
                case 0: {
                    this.recycleMemory(allocatedBufferBlock);
                    break;
                }
                default: {
                    this.lastTimeReceived = System.currentTimeMillis();
                    this.bytesReceived += (long)read;
                    allocatedBufferBlock.flip();
                    result = this.extractAndRecycleMemory(allocatedBufferBlock);
                    if (!LOG.isLoggable(Level.FINE)) break;
                    LOG.fine("[" + this.getId() + "] received (" + (result.limit() - result.position()) + " bytes): " + this.printByteBuffersForDebug(new ByteBuffer[]{result}));
                }
            }
        }
        if (LOG.isLoggable(Level.FINEST)) {
            if (result != null) {
                LOG.finest("read: " + TextUtils.toByteString(result.duplicate()));
            } else {
                LOG.finest("read: ''");
            }
        }
        return result;
    }

    protected final ByteBuffer extractAndRecycleMemory(ByteBuffer buffer) {
        if (buffer.limit() == buffer.capacity()) {
            return buffer;
        }
        int savedLimit = buffer.limit();
        ByteBuffer slicedPart = buffer.slice();
        buffer.position(savedLimit);
        buffer.limit(buffer.capacity());
        ByteBuffer unused = buffer.slice();
        this.recycleMemory(unused);
        return slicedPart;
    }

    protected synchronized int addToReceiveQueue(ByteBuffer buffer) {
        this.receiveQueue.offer(buffer);
        return buffer.limit() - buffer.position();
    }

    protected abstract ByteBuffer acquireMemory();

    protected abstract void recycleMemory(ByteBuffer var1);

    public synchronized void close() {
        if (this.getAssignedSocketChannel() != null) {
            block3: {
                try {
                    this.getAssignedSocketChannel().close();
                }
                catch (IOException ioe) {
                    if (!LOG.isLoggable(Level.FINE)) break block3;
                    LOG.fine("[" + this.getId() + "] error occured while closing underlying channel: " + ioe.toString());
                }
            }
            this.connectionEndTime = System.currentTimeMillis();
        }
    }

    protected abstract SocketChannel getAssignedSocketChannel();

    public final synchronized boolean isOpen() {
        if (this.getAssignedSocketChannel() == null) {
            return false;
        }
        return this.getAssignedSocketChannel().isOpen();
    }

    public final int getRemotePort() {
        return this.getAssignedSocketChannel().socket().getPort();
    }

    public InetAddress getRemoteAddress() {
        return this.getAssignedSocketChannel().socket().getInetAddress();
    }

    public long getConnectionOpenedTime() {
        return this.connectionOpenedTime;
    }

    public long getLastReceivingTime() {
        return this.lastTimeReceived;
    }

    public final int getLocalePort() {
        return this.getAssignedSocketChannel().socket().getLocalPort();
    }

    protected final synchronized void stopReading() {
        this.isReceiving = false;
    }

    private String printData(ByteBuffer[] buffers) {
        String postfix = "";
        StringBuilder sb = new StringBuilder();
        int read = 0;
        for (ByteBuffer buffer : buffers) {
            ByteBuffer duplicated = buffer.duplicate();
            if (duplicated.limit() - duplicated.position() + read > 400) {
                duplicated.limit(duplicated.position() + (400 - read));
                postfix = "[...remaining has been cut for log output]";
                break;
            }
            sb.append(TextUtils.toString(duplicated, "UTF-8"));
        }
        return sb.toString() + postfix;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.toCompactString());
        if (this.connectionEndTime != -1L) {
            sb.append(", lifetime=" + TextUtils.printFormatedDuration(this.connectionEndTime - this.connectionOpenedTime));
        }
        sb.append(", lastTimeReceived=" + TextUtils.printFormatedDate(this.lastTimeReceived) + ", received=" + TextUtils.printFormatedBytesSize(this.bytesReceived) + ", send=" + TextUtils.printFormatedBytesSize(this.bytesSend) + ", receiveQueueSize=" + this.receiveQueue.size() + ", sendQueueSize=" + this.sendQueue.size());
        return sb.toString();
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof AbstractConnection) {
            return ((AbstractConnection)other).id.equals(this.id);
        }
        return false;
    }

    public String toCompactString() {
        return "id=" + this.getId() + ", caller=" + this.getRemoteAddress().getCanonicalHostName() + "(" + this.getRemoteAddress() + ":" + this.getRemotePort() + ")" + ", opened=" + TextUtils.printFormatedDate(this.connectionOpenedTime);
    }

    private String printByteBuffersForDebug(ByteBuffer[] buffers) {
        String postfix = "";
        int size = 0;
        ArrayList<ByteBuffer> copies = new ArrayList<ByteBuffer>();
        for (ByteBuffer buffer : buffers) {
            ByteBuffer copy = buffer.duplicate();
            if (size + copy.limit() > 200) {
                copy.limit(200 - size);
                copies.add(copy);
                postfix = " [logout put has been cut]";
                break;
            }
            copies.add(copy);
        }
        StringBuilder result = new StringBuilder();
        try {
            for (ByteBuffer buffer : copies) {
                result.append(TextUtils.toString(buffer, "UTF-8"));
                buffer.flip();
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        result.append("  [hex:]");
        for (ByteBuffer buffer : copies) {
            result.append(TextUtils.toByteString(buffer));
        }
        result.append(postfix);
        return result.toString();
    }
}

