/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.AbstractConnection;
import org.xsocket.ClosedConnectionException;
import org.xsocket.IBlockingConnection;
import org.xsocket.util.TextUtils;

public final class BlockingConnection
extends AbstractConnection
implements IBlockingConnection {
    private static final Logger LOG = Logger.getLogger(BlockingConnection.class.getName());
    public static final int DEFAULT_PREALLOCATION_SIZE = 1024;
    private SocketChannel channel = null;
    private int preallocationSize = 1024;
    private ByteBuffer preallocatedBuffer = null;

    public BlockingConnection(SocketChannel channel) throws IOException {
        this(channel, 1024);
    }

    public BlockingConnection(SocketChannel channel, int receivebufferPreallocationSize) throws IOException {
        this.channel = channel;
        this.preallocationSize = receivebufferPreallocationSize;
        channel.configureBlocking(true);
    }

    protected synchronized SocketChannel getAssignedSocketChannel() {
        return this.channel;
    }

    public ByteBuffer[] receiveRecord(String delimiter) throws IOException {
        ByteBuffer[] buf = null;
        do {
            try {
                buf = this.readRecordFromReceiveReceiveQueue(delimiter);
            }
            catch (BufferUnderflowException bue) {
                this.addToReceiveQueue(this.readPhysical());
            }
        } while (buf == null);
        return buf;
    }

    public String receiveWord(String delimiter, String encoding) throws IOException {
        String word = null;
        do {
            try {
                word = this.readWordFromReceiveQueue(delimiter, encoding);
            }
            catch (BufferUnderflowException bue) {
                this.addToReceiveQueue(this.readPhysical());
            }
        } while (word == null);
        return word;
    }

    public String receiveWord(String delimiter) throws IOException {
        return this.receiveWord(delimiter, this.getDefaultEncoding());
    }

    public byte receiveByte() throws IOException, BufferUnderflowException {
        byte b = 0;
        boolean found = false;
        do {
            try {
                b = this.readByteFromReceiveQueue();
                found = true;
            }
            catch (BufferUnderflowException bue) {
                this.addToReceiveQueue(this.readPhysical());
            }
        } while (!found);
        return b;
    }

    public double receiveDouble() throws IOException, BufferUnderflowException {
        double d = 0.0;
        boolean found = false;
        do {
            try {
                d = this.readDoubleFromReceiveQueue();
                found = true;
            }
            catch (BufferUnderflowException bue) {
                this.addToReceiveQueue(this.readPhysical());
            }
        } while (!found);
        return d;
    }

    public int receiveInt() throws IOException, BufferUnderflowException {
        int i = 0;
        boolean found = false;
        do {
            try {
                i = this.readIntFromReceiveQueue();
                found = true;
            }
            catch (BufferUnderflowException bue) {
                this.addToReceiveQueue(this.readPhysical());
            }
        } while (!found);
        return i;
    }

    public long receiveLong() throws IOException, BufferUnderflowException {
        long l = 0L;
        boolean found = false;
        do {
            try {
                l = this.readLongFromReceiveQueue();
                found = true;
            }
            catch (BufferUnderflowException bue) {
                this.addToReceiveQueue(this.readPhysical());
            }
        } while (!found);
        return l;
    }

    public long write(ByteBuffer[] buffers) throws ClosedConnectionException, IOException {
        long written = 0L;
        for (ByteBuffer buffer : buffers) {
            written += (long)(buffer.limit() - buffer.position());
            this.writePhysical(buffers);
        }
        return written;
    }

    protected ByteBuffer acquireMemory() {
        if (this.preallocatedBuffer == null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("allocate new physical memory (new size: " + TextUtils.printFormatedBytesSize(this.preallocationSize) + ")");
            }
            this.preallocatedBuffer = ByteBuffer.allocate(this.preallocationSize);
        }
        ByteBuffer result = this.preallocatedBuffer;
        this.preallocatedBuffer = null;
        return result;
    }

    protected void recycleMemory(ByteBuffer buffer) {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("free buffer " + buffer + " has been put back");
        }
        this.preallocatedBuffer = buffer;
    }
}

