/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket;

import java.nio.ByteBuffer;
import java.util.Iterator;
import org.xsocket.util.TextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ByteBufferQueue
implements Iterable<ByteBuffer> {
    private Node<ByteBuffer> head = null;
    private Node<ByteBuffer> tail = null;
    private int numberOfNodes = 0;

    ByteBufferQueue() {
    }

    public synchronized void offerHead(ByteBuffer element) {
        if (this.head == null) {
            this.offer(element);
        } else {
            Node<ByteBuffer> node = new Node<ByteBuffer>(element);
            node.setSuccessor(this.head);
            this.head = node;
            ++this.numberOfNodes;
        }
    }

    public synchronized ByteBuffer poll() {
        if (this.head == null) {
            return null;
        }
        Node<ByteBuffer> node = this.head;
        this.head = node.getSuccessor();
        --this.numberOfNodes;
        if (this.numberOfNodes == 0) {
            this.clear();
        }
        return node.getElement();
    }

    synchronized boolean offer(ByteBuffer element) {
        Node<ByteBuffer> node = new Node<ByteBuffer>(element);
        if (this.tail == null) {
            this.tail = node;
            if (this.head == null) {
                this.head = this.tail;
            }
        } else {
            this.tail.setSuccessor(node);
            this.tail = node;
        }
        ++this.numberOfNodes;
        return true;
    }

    public boolean isEmpty() {
        return this.head == null;
    }

    public synchronized ByteBuffer[] drain() {
        ByteBuffer[] result = new ByteBuffer[this.numberOfNodes];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.poll();
        }
        return result;
    }

    public synchronized int getRemainingOfHeadElement() {
        if (this.head == null) {
            return 0;
        }
        return this.head.getElement().remaining();
    }

    public int size() {
        int size = 0;
        for (Node<ByteBuffer> node = this.head; node != null; node = node.getSuccessor()) {
            ByteBuffer buf = node.getElement();
            size += buf.limit() - buf.position();
        }
        return size;
    }

    private void clear() {
        this.head = null;
        this.tail = null;
        this.numberOfNodes = 0;
    }

    @Override
    public Iterator<ByteBuffer> iterator() {
        return new Iterator<ByteBuffer>(){
            private Node<ByteBuffer> next;
            {
                this.next = ByteBufferQueue.this.head;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public ByteBuffer next() {
                ByteBuffer element = this.next.getElement();
                this.next = this.next.getSuccessor();
                return element;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("operation remove is not supported");
            }
        };
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.head != null) {
            Node<ByteBuffer> node;
            try {
                node = this.head;
                do {
                    sb.append(TextUtils.toString(node.getElement().duplicate(), "UTF-8"));
                } while ((node = node.getSuccessor()) != null);
            }
            catch (Exception ignore) {
                // empty catch block
            }
            sb.append("\n[content as bytes:]\n");
            node = this.head;
            do {
                ByteBuffer buffer = node.getElement().duplicate();
                while (buffer.hasRemaining()) {
                    sb.append(Integer.toHexString(buffer.get()) + " ");
                }
            } while ((node = node.getSuccessor()) != null);
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Node<T> {
        private T element = null;
        private Node<T> successor = null;

        Node(T element) {
            this.element = element;
        }

        T getElement() {
            return this.element;
        }

        void setElement(T element) {
            this.element = element;
        }

        Node<T> getSuccessor() {
            return this.successor;
        }

        void setSuccessor(Node<T> successor) {
            this.successor = successor;
        }
    }
}

