/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket;

import java.nio.ByteBuffer;
import org.xsocket.ByteBufferQueue;
import org.xsocket.Index;

final class ByteBufferUtils {
    private ByteBufferUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Index find(ByteBufferQueue bufferQueue, byte[] delimiter) {
        Index index = new Index();
        int delimiterPos = 0;
        int recSize = 0;
        int bufferIndex = 0;
        block4: for (ByteBuffer buffer : bufferQueue) {
            int savedPos = buffer.position();
            int savedLimit = buffer.limit();
            try {
                int i = 0;
                while (buffer.hasRemaining()) {
                    ++recSize;
                    byte b = buffer.get();
                    if (delimiterPos > 0) {
                        if (b == delimiter[delimiterPos]) {
                            if (delimiterPos + 1 == delimiter.length) {
                                index.setDelimiterEndsBufferNum(bufferIndex);
                                index.setDelimiterEndsBufferPos(i);
                                break block4;
                            }
                            ++delimiterPos;
                        } else {
                            delimiterPos = 0;
                        }
                    }
                    if (delimiterPos == 0 && b == delimiter[delimiterPos]) {
                        index.setDelimiterStartsBufferNum(bufferIndex);
                        index.setDelimiterStartsBufferPos(i);
                        ++delimiterPos;
                    }
                    ++i;
                }
            }
            finally {
                buffer.position(savedPos);
                buffer.limit(savedLimit);
                ++bufferIndex;
            }
        }
        if (index.getDelimiterEndsBufferPos() != -1) {
            return index;
        }
        return null;
    }

    public static ByteBuffer[] extract(ByteBufferQueue bufferQueue, Index index) {
        ByteBuffer[] result = null;
        for (int bufferNumber = 0; bufferNumber <= index.getDelimiterEndsBufferNum(); ++bufferNumber) {
            ByteBuffer buffer = bufferQueue.poll();
            if (bufferNumber < index.getDelimiterStartsBufferNum()) {
                result = ByteBufferUtils.addToArray(result, buffer);
            }
            if (bufferNumber == index.getDelimiterStartsBufferNum()) {
                int savedLimit = buffer.limit();
                buffer.position(0).limit(index.getDelimiterStartsBufferPos());
                ByteBuffer leftPart = buffer.slice();
                if (leftPart.limit() > 0) {
                    result = ByteBufferUtils.addToArray(result, leftPart);
                }
                buffer.limit(savedLimit);
            }
            if (bufferNumber != index.getDelimiterEndsBufferNum() || index.getDelimiterEndsBufferPos() + 1 >= buffer.limit()) continue;
            buffer.position(index.getDelimiterEndsBufferPos() + 1);
            ByteBuffer rightPart = buffer.slice();
            if (rightPart.limit() <= 0) continue;
            bufferQueue.offerHead(rightPart);
        }
        return result;
    }

    private static ByteBuffer[] addToArray(ByteBuffer[] array, ByteBuffer newElement) {
        if (array == null) {
            return new ByteBuffer[]{newElement};
        }
        ByteBuffer[] newArray = new ByteBuffer[array.length + 1];
        System.arraycopy(array, 0, newArray, 0, array.length);
        newArray[array.length] = newElement;
        return newArray;
    }
}

