/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.server;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.server.IConnectHandler;
import org.xsocket.server.IConnectionScoped;
import org.xsocket.server.IDataHandler;
import org.xsocket.server.IHandler;
import org.xsocket.server.NonBlockingConnection;

final class InternalHandler
implements Cloneable {
    private static final Logger LOG = Logger.getLogger(InternalHandler.class.getName());
    private ExecutorService pool = null;
    private IHandler handler = null;
    private boolean isConnectHandler = false;
    private boolean isDataHandler = false;
    private boolean isConnetionScoped = false;

    InternalHandler(IHandler handler) {
        this.handler = handler;
        if (handler instanceof IConnectHandler) {
            this.isConnectHandler = true;
        }
        if (handler instanceof IDataHandler) {
            this.isDataHandler = true;
        }
        if (handler instanceof IConnectionScoped) {
            this.isConnetionScoped = true;
        }
    }

    public void setExecutorPool(ExecutorService pool) {
        this.pool = pool;
    }

    public void onConnectionOpened(final NonBlockingConnection connection) {
        if (this.isConnectHandler) {
            this.pool.execute(new Runnable(){

                public void run() {
                    block2: {
                        try {
                            ((IConnectHandler)InternalHandler.this.handler).onConnectionOpening(connection);
                        }
                        catch (Throwable e) {
                            if (!LOG.isLoggable(Level.FINER)) break block2;
                            LOG.finer("error occured by handling connection opening by handler " + InternalHandler.this.handler.getClass().getName() + "#" + InternalHandler.this.handler.hashCode() + ". Reason: " + e.toString());
                        }
                    }
                }
            });
        }
    }

    public void onDataReceived(final NonBlockingConnection connection) throws IOException {
        if (this.isDataHandler) {
            this.pool.execute(new Runnable(){

                public void run() {
                    block2: {
                        try {
                            ((IDataHandler)InternalHandler.this.handler).onData(connection);
                        }
                        catch (Throwable e) {
                            if (!LOG.isLoggable(Level.FINER)) break block2;
                            LOG.finer("error occured by handling connection data by handler " + InternalHandler.this.handler.getClass().getName() + "#" + InternalHandler.this.handler.hashCode() + ". Reason: " + e.toString());
                        }
                    }
                }
            });
        }
    }

    public void onConnectionClose(NonBlockingConnection connection) {
        if (this.isConnetionScoped) {
            this.close();
        }
    }

    public void close() {
    }

    public Object clone() throws CloneNotSupportedException {
        if (this.isConnetionScoped) {
            InternalHandler copy = (InternalHandler)super.clone();
            copy.handler = (IHandler)((IConnectionScoped)((Object)this.handler)).clone();
            return copy;
        }
        return this;
    }
}

