/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.server;

import java.io.IOException;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.util.logging.Logger;
import org.xsocket.server.ISSLContextFactory;
import org.xsocket.server.MultithreadedServer;
import org.xsocket.server.NonBlockingConnection;
import org.xsocket.server.NonBlockingSSLConnection;

public final class MultithreadedSSLServer
extends MultithreadedServer {
    private static final Logger LOG = Logger.getLogger(MultithreadedSSLServer.class.getName());
    private ISSLContextFactory sslContextFactory = null;

    public MultithreadedSSLServer(int port, String domain, ISSLContextFactory sslContextFactory) throws UnknownHostException {
        super(port, domain);
        this.sslContextFactory = sslContextFactory;
        LOG.fine("usage ssl connection");
    }

    protected NonBlockingConnection newNonBlockingConnection(SocketChannel sc, String id) throws IOException {
        return new NonBlockingSSLConnection(sc, id, this.sslContextFactory.getSSLContext());
    }
}

