/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.server;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.AbstractConnection;
import org.xsocket.ClosedConnectionException;
import org.xsocket.server.INonBlockingConnection;
import org.xsocket.server.InternalHandler;
import org.xsocket.server.ThreadBoundMemoryManager;

class NonBlockingConnection
extends AbstractConnection
implements INonBlockingConnection {
    private static final Logger LOG = Logger.getLogger(NonBlockingConnection.class.getName());
    private SocketChannel channel = null;
    private SelectionKey key = null;
    private InternalHandler handler = null;

    public NonBlockingConnection(SocketChannel channel, String id) throws IOException {
        this.channel = channel;
        this.setId(id);
    }

    protected final synchronized SocketChannel getAssignedSocketChannel() {
        return this.channel;
    }

    public void handleNonBlockingRead() throws ClosedConnectionException, IOException {
        int bytesAdded = this.addToReceiveQueue(this.readPhysical());
        if (bytesAdded > 0) {
            this.getAssignedHandler().onDataReceived(this);
        }
    }

    public void handleNonBlockingWrite() throws ClosedConnectionException, IOException {
        this.writePhysical(this.drainSendQueue());
    }

    public final long write(ByteBuffer[] buffers) throws ClosedConnectionException, IOException {
        long written = 0L;
        for (ByteBuffer buffer : buffers) {
            written += (long)this.addToSendQueue(buffer);
        }
        if (written > 0L) {
            try {
                this.key.interestOps(5);
                this.key.selector().wakeup();
            }
            catch (CancelledKeyException cke) {
                ClosedConnectionException cce = new ClosedConnectionException("connection " + this.getId() + " is already closed");
                LOG.throwing(this.getClass().getName(), "write(ByteBuffer[]", cce);
                throw cce;
            }
        }
        return written;
    }

    public final ByteBuffer[] readRecord(String delimiter) throws IOException {
        return this.readRecordFromReceiveReceiveQueue(delimiter);
    }

    public final String readWord(String delimiter) throws IOException {
        return this.readWord(delimiter, this.getDefaultEncoding());
    }

    public int readInt() throws IOException, BufferUnderflowException {
        return this.readIntFromReceiveQueue();
    }

    public long readLong() throws IOException, BufferUnderflowException {
        return this.readLongFromReceiveQueue();
    }

    public double readDouble() throws IOException, BufferUnderflowException {
        return this.readDoubleFromReceiveQueue();
    }

    public byte readByte() throws IOException, BufferUnderflowException {
        return this.readByteFromReceiveQueue();
    }

    public final String readWord(String delimiter, String encoding) throws IOException, BufferUnderflowException {
        return this.readWordFromReceiveQueue(delimiter, encoding);
    }

    public final ByteBuffer[] readAvailable() throws ClosedConnectionException, IOException {
        return this.drainReceiveQueue();
    }

    public int getNumberOfAvailableBytes() {
        return this.numberOfAvailableInputBytes();
    }

    public final void stopReceiving() {
        super.stopReading();
    }

    public boolean hasDataToSend() {
        return !this.isSendQueueEmpty();
    }

    public void init(InternalHandler handler) throws IOException {
        this.setHandler(handler);
        handler.onConnectionOpened(this);
    }

    protected final void setHandler(InternalHandler handler) throws IOException {
        this.handler = handler;
    }

    public final void registerSelector(Selector selector, int ops) throws IOException {
        if (this.isOpen()) {
            this.channel.configureBlocking(false);
            this.key = this.channel.register(selector, ops, this);
        }
    }

    protected final ByteBuffer acquireMemory() {
        return ThreadBoundMemoryManager.acquireMemory();
    }

    public synchronized void close() {
        block3: {
            if (this.handler != null) {
                this.handler.onConnectionClose(this);
            }
            try {
                this.key.cancel();
            }
            catch (Exception ioe) {
                if (!LOG.isLoggable(Level.FINE)) break block3;
                LOG.fine("[" + this.getId() + "] error occured while closing key: " + ioe.toString());
            }
        }
        super.close();
    }

    protected final void recycleMemory(ByteBuffer buf) {
        ThreadBoundMemoryManager.recycleMemory(buf);
    }

    void updateSelectionKeyOps(int ops) {
        this.key.interestOps(ops);
    }

    protected final InternalHandler getAssignedHandler() {
        return this.handler;
    }
}

