/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.server;

import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

final class ThreadBoundMemoryManager {
    private static final Logger LOG = Logger.getLogger(ThreadBoundMemoryManager.class.getName());
    private static ThreadLocal<Integer> preallocationSize = new ThreadLocal();
    private static ThreadLocal<ByteBuffer> buffer = new ThreadLocal();

    private ThreadBoundMemoryManager() {
    }

    static void setPreallocationSize(int size) {
        preallocationSize.set(size);
    }

    static ByteBuffer acquireMemory() {
        return ThreadBoundMemoryManager.acquireMemory(1);
    }

    static ByteBuffer acquireMemory(int minBufferSize) {
        ByteBuffer buf = buffer.get();
        if (buf == null) {
            buf = ThreadBoundMemoryManager.newBuffer(preallocationSize.get());
        } else if (buf.limit() < minBufferSize) {
            int allocationSize = preallocationSize.get();
            if (allocationSize < minBufferSize) {
                allocationSize = minBufferSize * 10;
            }
            buf = ThreadBoundMemoryManager.newBuffer(allocationSize);
        }
        buffer.set(null);
        return buf;
    }

    static ByteBuffer newBuffer(int size) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("allocate new physical memory (size: " + size + ")");
        }
        return ByteBuffer.allocateDirect(size);
    }

    static void recycleMemory(ByteBuffer buf) {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("free buffer " + buffer + " has been put back");
        }
        buffer.set(buf);
    }

    static ByteBuffer extractAndRecycleMemory(ByteBuffer buffer) {
        if (buffer.limit() == buffer.capacity()) {
            return buffer;
        }
        int savedLimit = buffer.limit();
        ByteBuffer slicedPart = buffer.slice();
        buffer.position(savedLimit);
        buffer.limit(buffer.capacity());
        ByteBuffer unused = buffer.slice();
        ThreadBoundMemoryManager.recycleMemory(unused);
        return slicedPart;
    }
}

