/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.server.chain;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.server.IConnectHandler;
import org.xsocket.server.IConnectionScoped;
import org.xsocket.server.IDataHandler;
import org.xsocket.server.IHandler;
import org.xsocket.server.INonBlockingConnection;
import org.xsocket.server.chain.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Chain
implements IDataHandler,
IConnectHandler,
IConnectionScoped {
    private static final Logger LOG = Logger.getLogger(Chain.class.getName());
    private int length = 0;
    private boolean isConnectionScoped = false;
    private boolean containsDataHandler = false;
    private boolean containsConnectHandler = false;
    private final NodeRegistry lifeCycleHandlerNodeRegistry = new NodeRegistry();
    private final NodeRegistry dataHandlerNodeRegistry = new NodeRegistry();
    private int[] connectionScopedIndex = new int[0];
    private IHandler[] handlers = new IHandler[0];
    private List<Chain> enclosingChains = null;

    public Chain() {
    }

    public Chain(List<IHandler> handlers) {
        for (IHandler handler : handlers) {
            this.addHandler(handler);
        }
    }

    public int addHandler(IHandler handler) {
        int position = this.registerHandler(handler);
        if (handler instanceof Chain) {
            ((Chain)handler).addEnclosingChain(this);
        }
        boolean isConnectHandler = false;
        if (handler instanceof IConnectHandler) {
            this.registerLifeCycleHandler(position);
            this.containsConnectHandler = true;
            isConnectHandler = true;
        }
        boolean isDataHandler = false;
        if (handler instanceof IDataHandler) {
            this.registerDataHandler(position);
            this.containsDataHandler = true;
            isDataHandler = true;
        }
        if (handler instanceof IConnectionScoped) {
            this.updateScope(handler, true);
        } else {
            this.updateScope(handler, false);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("handler " + handler.getClass().getSimpleName() + " (isConnectionScoped=" + this.isConnectionScoped + ", isConnectHandler=" + isConnectHandler + ", isDataHandler=" + isDataHandler + ") has been registered");
        }
        ++this.length;
        return position;
    }

    private void registerLifeCycleHandler(int position) {
        boolean isEmpty = this.lifeCycleHandlerNodeRegistry.isEmpty();
        Node node = this.lifeCycleHandlerNodeRegistry.retrieveNode(position);
        if (isEmpty) {
            this.lifeCycleHandlerNodeRegistry.setRoorNode(node);
        }
        node.setFalseSuccessorNode(this.lifeCycleHandlerNodeRegistry.retrieveNode(position + 1));
    }

    private void registerDataHandler(int position) {
        boolean isEmpty = this.dataHandlerNodeRegistry.isEmpty();
        Node node = this.dataHandlerNodeRegistry.retrieveNode(position);
        if (isEmpty) {
            this.dataHandlerNodeRegistry.setRoorNode(node);
        }
        node.setFalseSuccessorNode(this.dataHandlerNodeRegistry.retrieveNode(position + 1));
    }

    private synchronized int registerHandler(IHandler handler) {
        int position = this.handlers.length;
        IHandler[] newHandlers = new IHandler[this.handlers.length + 1];
        System.arraycopy(this.handlers, 0, newHandlers, 0, this.handlers.length);
        newHandlers[this.handlers.length] = handler;
        this.handlers = newHandlers;
        return position;
    }

    private synchronized void updateScope(IHandler handler, boolean isConnectionScoped) {
        int position = this.getPosition(handler);
        if (isConnectionScoped) {
            this.isConnectionScoped = true;
            int[] newConnectionScopedIndex = new int[this.connectionScopedIndex.length + 1];
            System.arraycopy(this.connectionScopedIndex, 0, newConnectionScopedIndex, 0, this.connectionScopedIndex.length);
            newConnectionScopedIndex[this.connectionScopedIndex.length] = position;
            this.connectionScopedIndex = newConnectionScopedIndex;
            if (this.enclosingChains != null) {
                for (Chain chain : this.enclosingChains) {
                    chain.updateScope(this, this.isConnectionScoped);
                }
            }
        }
    }

    private synchronized IHandler getHandler(int position) {
        if (position < this.handlers.length) {
            return this.handlers[position];
        }
        return null;
    }

    private int getPosition(IHandler handler) {
        for (int i = 0; i < this.handlers.length; ++i) {
            if (this.handlers[i] != handler) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean onConnectionOpening(INonBlockingConnection connection) throws IOException {
        boolean result = false;
        if (this.containsConnectHandler) {
            Node node = this.lifeCycleHandlerNodeRegistry.getRootNode();
            while (node != null) {
                IConnectHandler handler = (IConnectHandler)this.getHandler(node.getId());
                if (handler != null) {
                    if (LOG.isLoggable(Level.FINEST)) {
                        LOG.finest("calling onConnectionOpening on " + handler.getClass().getSimpleName() + "#" + handler.hashCode());
                    }
                    result = handler.onConnectionOpening(connection);
                    if (LOG.isLoggable(Level.FINEST)) {
                        LOG.finest("result of readIncommingData on " + handler.getClass().getSimpleName() + "#" + handler.hashCode() + " " + result);
                    }
                    if (connection.isOpen()) {
                        if (result) {
                            node = node.getTrueSuccessorNode();
                            continue;
                        }
                        node = node.getFalseSuccessorNode();
                        continue;
                    }
                    return true;
                }
                node = null;
            }
        }
        return result;
    }

    @Override
    public boolean onData(INonBlockingConnection connection) throws IOException {
        boolean result = false;
        if (this.containsDataHandler) {
            Node node = this.dataHandlerNodeRegistry.getRootNode();
            while (node != null) {
                IDataHandler handler = (IDataHandler)this.getHandler(node.getId());
                if (handler != null) {
                    if (LOG.isLoggable(Level.FINEST)) {
                        LOG.finest("calling  processIncommingData on " + handler.getClass().getSimpleName() + "#" + handler.hashCode());
                    }
                    result = handler.onData(connection);
                    if (LOG.isLoggable(Level.FINEST)) {
                        LOG.finest("result of readIncommingData on " + handler.getClass().getSimpleName() + "#" + handler.hashCode() + " " + result);
                    }
                    if (connection.isOpen()) {
                        if (result) {
                            node = node.getTrueSuccessorNode();
                            continue;
                        }
                        node = node.getFalseSuccessorNode();
                        continue;
                    }
                    return true;
                }
                node = null;
            }
        }
        return result;
    }

    private synchronized void addEnclosingChain(Chain enclosingChain) {
        if (this.enclosingChains == null) {
            this.enclosingChains = new ArrayList<Chain>();
        }
        this.enclosingChains.add(enclosingChain);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        if (this.isConnectionScoped) {
            Chain clone = (Chain)super.clone();
            clone.handlers = (IHandler[])this.handlers.clone();
            for (int i = 0; i < this.connectionScopedIndex.length; ++i) {
                int position = this.connectionScopedIndex[i];
                clone.handlers[position] = (IHandler)((IConnectionScoped)((Object)this.handlers[position])).clone();
            }
            return clone;
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest(this.getClass().getSimpleName() + " doesn't contain connection-specific handlers. return current instance as clone");
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName() + "#" + this.hashCode() + "\n\n");
        sb.append("registered prototypes:\n");
        for (int i = 0; i < this.handlers.length; ++i) {
            sb.append(this.handlers[i].getClass().getSimpleName() + "#" + this.handlers[i].hashCode());
            for (int j = 0; j < this.connectionScopedIndex.length; ++j) {
                if (this.connectionScopedIndex[j] != i) continue;
                sb.append(" (Scope=connection)");
            }
            sb.append("\n");
        }
        sb.append("\n");
        sb.append("LifeCycleHandler Nodes:\n" + this.printNodeRegistry(this.lifeCycleHandlerNodeRegistry) + "\n");
        sb.append("\n");
        sb.append("DataHandler Nodes:\n" + this.printNodeRegistry(this.dataHandlerNodeRegistry) + "\n");
        sb.append("\n");
        return sb.toString();
    }

    private String printNodeRegistry(NodeRegistry nodeRegistry) {
        StringBuilder sb = new StringBuilder("nodeId, node, trueSucId, falseSucId, isRoot\n");
        Node root = nodeRegistry.getRootNode();
        List<Node> nodes = nodeRegistry.getAllNodes();
        Collections.sort(nodes, new Comparator<Node>(){

            @Override
            public int compare(Node node1, Node node2) {
                return new Integer(node1.getId()).compareTo(new Integer(node2.getId()));
            }
        });
        for (Node node : nodes) {
            boolean isRoot = root == node;
            IHandler trueSuccessor = null;
            if (node.getTrueSuccessorNode() != null) {
                trueSuccessor = this.getHandler(node.getTrueSuccessorNode().getId());
            }
            IHandler falseSuccessor = null;
            if (node.getFalseSuccessorNode() != null) {
                falseSuccessor = this.getHandler(node.getFalseSuccessorNode().getId());
            }
            sb.append(node.getId() + ", " + this.printHandlerClass(this.getHandler(node.getId())) + ", " + this.printHandlerClass(trueSuccessor) + ", " + this.printHandlerClass(falseSuccessor) + ", " + isRoot + "\n");
        }
        return sb.toString();
    }

    private String printHandlerClass(IHandler handler) {
        if (handler != null) {
            return handler.getClass().getSimpleName() + "#" + handler.hashCode();
        }
        return "null";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NodeRegistry {
        private final Map<Integer, Node> nodes = new HashMap<Integer, Node>();
        private Node rootNode = null;

        private NodeRegistry() {
        }

        public void setRoorNode(Node rootNode) {
            this.rootNode = rootNode;
        }

        public Node getRootNode() {
            return this.rootNode;
        }

        public boolean isEmpty() {
            return this.nodes.isEmpty();
        }

        public Node retrieveNode(int id) {
            if (this.nodes.containsKey(id)) {
                return this.nodes.get(id);
            }
            Node node = new Node(id);
            this.registerNode(node);
            return node;
        }

        private void registerNode(Node node) {
            this.nodes.put(node.getId(), node);
        }

        public List<Node> getAllNodes() {
            ArrayList<Node> result = new ArrayList<Node>();
            for (int id : this.nodes.keySet()) {
                result.add(this.nodes.get(id));
            }
            return result;
        }
    }
}

