/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket;

import java.io.IOException;
import java.lang.reflect.Array;
import java.net.InetAddress;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.ByteBufferParser;
import org.xsocket.ClosedConnectionException;
import org.xsocket.IConnection;
import org.xsocket.util.TextUtils;

public abstract class AbstractConnection
implements IConnection {
    private static final Logger LOG = Logger.getLogger(AbstractConnection.class.getName());
    private static final ByteBufferParser PARSER = new ByteBufferParser();
    private static final int DEBUG_MAX_OUTPUT_SIZE = 200;
    private String id = null;
    private boolean isReceiving = true;
    private String defaultEncoding = "UTF-8";
    private final Queue receiveQueue = new Queue();
    private long connectionOpenedTime = -1L;
    private long connectionEndTime = -1L;
    private long lastTimeReceived = this.connectionOpenedTime = System.currentTimeMillis();
    private long bytesReceived = 0L;
    private long bytesSend = 0L;

    public final void setId(String id) {
        this.id = id;
    }

    public final String getId() {
        return this.id;
    }

    public abstract long write(ByteBuffer[] var1) throws ClosedConnectionException, IOException;

    protected final long writePhysical(ByteBuffer[] buffersToWrite) throws ClosedConnectionException, IOException {
        if (this.isOpen()) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.getId() + "] sending: " + this.printByteBuffersAsText(buffersToWrite));
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.finer("[" + this.getId() + "] " + this.printByteBuffersAsHex(buffersToWrite));
                }
            }
            try {
                long numberOfSendData = this.getAssignedSocketChannel().write(buffersToWrite);
                this.bytesSend += numberOfSendData;
                return numberOfSendData;
            }
            catch (IOException io) {
                io.printStackTrace();
                throw io;
            }
        }
        ClosedConnectionException cce = new ClosedConnectionException("[" + this.getId() + "] connection " + this.toCompactString() + " ist already closed. Couldn't write " + this.printData(buffersToWrite));
        LOG.throwing(this.getClass().getName(), "send(ByteBuffer[])", cce);
        throw cce;
    }

    protected final ByteBuffer readPhysical() throws ClosedConnectionException, IOException {
        ByteBuffer result = null;
        ByteBuffer allocatedBufferBlock = this.acquireMemory();
        int pos = allocatedBufferBlock.position();
        int limit = allocatedBufferBlock.limit();
        int read = 0;
        if (this.isOpen() && this.isReceiving) {
            try {
                read = this.getAssignedSocketChannel().read(allocatedBufferBlock);
            }
            catch (IOException ioe) {
                allocatedBufferBlock.position(pos);
                allocatedBufferBlock.limit(limit);
                this.recycleMemory(allocatedBufferBlock);
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.finer("[" + this.getId() + "] error occured while reading channel: " + ioe.toString());
                }
                throw ioe;
            }
            switch (read) {
                case -1: {
                    this.recycleMemory(allocatedBufferBlock);
                    ClosedConnectionException cce = new ClosedConnectionException("[" + this.getId() + "] End of stream reached");
                    LOG.throwing(this.getClass().getName(), "read()", cce);
                    throw cce;
                }
                case 0: {
                    this.recycleMemory(allocatedBufferBlock);
                    break;
                }
                default: {
                    this.lastTimeReceived = System.currentTimeMillis();
                    this.bytesReceived += (long)read;
                    allocatedBufferBlock.flip();
                    result = this.extractAndRecycleMemory(allocatedBufferBlock);
                    if (!LOG.isLoggable(Level.FINE)) break;
                    LOG.fine("[" + this.getId() + "] received (" + (result.limit() - result.position()) + " bytes): " + this.printByteBuffersAsText(new ByteBuffer[]{result}));
                    if (!LOG.isLoggable(Level.FINER)) break;
                    LOG.finer("[" + this.getId() + "] " + this.printByteBuffersAsHex(new ByteBuffer[]{result}));
                }
            }
        }
        if (LOG.isLoggable(Level.FINEST)) {
            if (result != null) {
                LOG.finest("read: " + TextUtils.toByteString(result.duplicate()));
            } else {
                LOG.finest("read: ''");
            }
        }
        return result;
    }

    protected final ByteBuffer extractAndRecycleMemory(ByteBuffer buffer) {
        if (buffer.limit() == buffer.capacity()) {
            return buffer;
        }
        int savedLimit = buffer.limit();
        ByteBuffer slicedPart = buffer.slice();
        buffer.position(savedLimit);
        buffer.limit(buffer.capacity());
        ByteBuffer unused = buffer.slice();
        this.recycleMemory(unused);
        return slicedPart;
    }

    protected abstract ByteBuffer acquireMemory();

    protected abstract void recycleMemory(ByteBuffer var1);

    public synchronized void close() {
        if (this.getAssignedSocketChannel() != null) {
            block3: {
                try {
                    this.getAssignedSocketChannel().close();
                }
                catch (IOException ioe) {
                    if (!LOG.isLoggable(Level.FINE)) break block3;
                    LOG.fine("[" + this.getId() + "] error occured while closing underlying channel: " + ioe.toString());
                }
            }
            this.connectionEndTime = System.currentTimeMillis();
        }
    }

    protected abstract SocketChannel getAssignedSocketChannel();

    public final boolean isOpen() {
        if (this.getAssignedSocketChannel() == null) {
            return false;
        }
        return this.getAssignedSocketChannel().isOpen();
    }

    public final int getRemotePort() {
        return this.getAssignedSocketChannel().socket().getPort();
    }

    public InetAddress getRemoteAddress() {
        return this.getAssignedSocketChannel().socket().getInetAddress();
    }

    public InetAddress getLocalAddress() {
        return this.getAssignedSocketChannel().socket().getLocalAddress();
    }

    public long getConnectionOpenedTime() {
        return this.connectionOpenedTime;
    }

    public long getLastReceivingTime() {
        return this.lastTimeReceived;
    }

    public final int getLocalePort() {
        return this.getAssignedSocketChannel().socket().getLocalPort();
    }

    protected final void stopReading() {
        this.isReceiving = false;
    }

    private String printData(ByteBuffer[] buffers) {
        String postfix = "";
        StringBuilder sb = new StringBuilder();
        int read = 0;
        for (ByteBuffer buffer : buffers) {
            ByteBuffer duplicated = buffer.duplicate();
            if (duplicated.limit() - duplicated.position() + read > 400) {
                duplicated.limit(duplicated.position() + (400 - read));
                postfix = "[...remaining has been cut for log output]";
                break;
            }
            sb.append(TextUtils.toString(duplicated, "UTF-8"));
        }
        return sb.toString() + postfix;
    }

    public final void setDefaultEncoding(String encoding) {
        this.defaultEncoding = encoding;
    }

    public final String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public final int writeWord(String s) throws ClosedConnectionException, IOException {
        return this.writeWord(s, this.defaultEncoding);
    }

    public final int writeWord(String s, String encoding) throws ClosedConnectionException, IOException {
        ByteBuffer buffer = TextUtils.toByteBuffer(s, encoding);
        return this.write(buffer);
    }

    public final int writeByte(byte b) throws ClosedConnectionException, IOException {
        return this.write(ByteBuffer.allocate(1).put(b));
    }

    public final int write(ByteBuffer buffer) throws ClosedConnectionException, IOException {
        return (int)this.write(new ByteBuffer[]{buffer});
    }

    public final int writeInt(int i) throws ClosedConnectionException, IOException {
        ByteBuffer buffer = ByteBuffer.allocate(4).putInt(i);
        buffer.flip();
        return this.write(buffer);
    }

    public final int writeLong(long l) throws ClosedConnectionException, IOException {
        ByteBuffer buffer = ByteBuffer.allocate(8).putLong(l);
        buffer.flip();
        return this.write(buffer);
    }

    public final int writeDouble(double d) throws ClosedConnectionException, IOException {
        ByteBuffer buffer = ByteBuffer.allocate(8).putDouble(d);
        buffer.flip();
        return this.write(buffer);
    }

    public final long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        ByteBuffer[] bufs = new ByteBuffer[length];
        System.arraycopy(srcs, offset, bufs, 0, length);
        return this.write(bufs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.toCompactString());
        if (this.connectionEndTime != -1L) {
            sb.append(", lifetime=" + TextUtils.printFormatedDuration(this.connectionEndTime - this.connectionOpenedTime));
        }
        sb.append(", lastTimeReceived=" + TextUtils.printFormatedDate(this.lastTimeReceived) + ", received=" + TextUtils.printFormatedBytesSize(this.bytesReceived) + ", send=" + TextUtils.printFormatedBytesSize(this.bytesSend) + ", receiveQueueSize=" + this.receiveQueue.getSize());
        return sb.toString();
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof AbstractConnection) {
            return ((AbstractConnection)other).id.equals(this.id);
        }
        return false;
    }

    protected final Queue getReceiveQueue() {
        return this.receiveQueue;
    }

    public String toCompactString() {
        return "id=" + this.getId() + ", caller=" + this.getRemoteAddress().getCanonicalHostName() + "(" + this.getRemoteAddress() + ":" + this.getRemotePort() + ")" + ", opened=" + TextUtils.printFormatedDate(this.connectionOpenedTime);
    }

    private String printByteBuffersAsText(ByteBuffer[] buffers) {
        String postfix = "";
        int size = 0;
        ArrayList<ByteBuffer> copies = new ArrayList<ByteBuffer>();
        for (ByteBuffer buffer : buffers) {
            ByteBuffer copy = buffer.duplicate();
            if (size + copy.limit() > 200) {
                copy.limit(200 - size);
                copies.add(copy);
                postfix = " [logout put has been cut]";
                break;
            }
            copies.add(copy);
        }
        StringBuilder result = new StringBuilder();
        try {
            for (ByteBuffer buffer : copies) {
                result.append(TextUtils.toString(buffer, "UTF-8"));
                buffer.flip();
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        result.append(postfix);
        return result.toString();
    }

    private String printByteBuffersAsHex(ByteBuffer[] buffers) {
        String postfix = "";
        int size = 0;
        ArrayList<ByteBuffer> copies = new ArrayList<ByteBuffer>();
        for (ByteBuffer buffer : buffers) {
            ByteBuffer copy = buffer.duplicate();
            if (size + copy.limit() > 200) {
                copy.limit(200 - size);
                copies.add(copy);
                postfix = " [logout put has been cut]";
                break;
            }
            copies.add(copy);
        }
        StringBuilder result = new StringBuilder();
        result.append("[hex:]");
        for (ByteBuffer buffer : copies) {
            result.append(TextUtils.toByteString(buffer));
        }
        result.append(postfix);
        return result.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class ByteBufferArrayChannel
    implements WritableByteChannel {
        private boolean isOpen = true;
        private ByteBuffer[] buffers = new ByteBuffer[0];

        @Override
        public boolean isOpen() {
            return this.isOpen;
        }

        @Override
        public void close() throws IOException {
            this.isOpen = false;
        }

        @Override
        public int write(ByteBuffer buffer) throws IOException {
            this.buffers = ByteBufferArrayChannel.incArray(this.buffers, buffer);
            return buffer.limit() - buffer.position();
        }

        public ByteBuffer[] getContent() {
            return this.buffers;
        }

        private static ByteBuffer[] incArray(ByteBuffer[] original, ByteBuffer newElement) {
            ByteBuffer[] newArray = (ByteBuffer[])ByteBufferArrayChannel.copyOf(original, original.length + 1, original.getClass());
            newArray[original.length] = newElement;
            return newArray;
        }

        private static <T, U> T[] copyOf(U[] original, int newLength, Class<? extends T[]> newType) {
            Object[] copy = newType == Object[].class ? new Object[newLength] : (Object[])Array.newInstance(newType.getComponentType(), newLength);
            System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
            return copy;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class Queue {
        private final Map<String, ByteBufferParser.Index> indexMap = new HashMap<String, ByteBufferParser.Index>();
        private LinkedList<ByteBuffer> bufferQueue = new LinkedList();

        public synchronized int append(ByteBuffer buffer) {
            this.bufferQueue.addLast(buffer);
            return buffer.limit() - buffer.position();
        }

        public synchronized int getSize() {
            int i = 0;
            for (ByteBuffer buffer : this.bufferQueue) {
                i += buffer.limit() - buffer.position();
            }
            return i;
        }

        public synchronized LinkedList<ByteBuffer> drain() {
            LinkedList<ByteBuffer> result = this.bufferQueue;
            this.bufferQueue = new LinkedList();
            return result;
        }

        public synchronized void readRecord(String delimiter, WritableByteChannel outChannel) throws IOException {
            ByteBufferParser.Index index = null;
            byte[] delimiterBytes = delimiter.getBytes();
            if (!this.indexMap.isEmpty() && this.indexMap.containsKey(delimiter)) {
                index = this.indexMap.get(delimiter);
            }
            if (!(index = index == null ? PARSER.find(this.bufferQueue, delimiterBytes) : PARSER.find(this.bufferQueue, index)).isDelimiterFound()) {
                this.indexMap.put(delimiter, index);
                throw new BufferUnderflowException();
            }
            this.indexMap.clear();
            PARSER.extract(this.bufferQueue, index, outChannel);
        }

        public synchronized boolean readAvailable(String delimiter, WritableByteChannel outChannel) throws IOException {
            ByteBufferParser.Index index = null;
            byte[] delimiterBytes = delimiter.getBytes();
            if (!this.indexMap.isEmpty() && this.indexMap.containsKey(delimiter)) {
                index = this.indexMap.get(delimiter);
            }
            index = index == null ? PARSER.find(this.bufferQueue, delimiterBytes) : PARSER.find(this.bufferQueue, index);
            PARSER.extractAvailable(this.bufferQueue, index, outChannel);
            this.indexMap.clear();
            return index.isDelimiterFound();
        }

        public synchronized int readInt() throws IOException {
            if (this.getAvailableBytesOfFirstBuffer() >= 4) {
                ByteBuffer buf = this.bufferQueue.removeFirst();
                int i = buf.getInt();
                this.bufferQueue.addFirst(buf.slice());
                return i;
            }
            return ByteBuffer.wrap(this.read(4)).getInt();
        }

        public synchronized byte readByte() {
            if (this.getAvailableBytesOfFirstBuffer() >= 1) {
                ByteBuffer buf = this.bufferQueue.removeFirst();
                byte b = buf.get();
                this.bufferQueue.addFirst(buf.slice());
                return b;
            }
            throw new BufferUnderflowException();
        }

        public synchronized double readDouble() throws IOException {
            if (this.getAvailableBytesOfFirstBuffer() >= 8) {
                ByteBuffer buf = this.bufferQueue.removeFirst();
                double d = buf.getDouble();
                this.bufferQueue.addFirst(buf.slice());
                return d;
            }
            return ByteBuffer.wrap(this.read(8)).getDouble();
        }

        public synchronized long readLong() throws IOException {
            if (this.getAvailableBytesOfFirstBuffer() >= 8) {
                ByteBuffer buf = this.bufferQueue.removeFirst();
                long l = buf.getLong();
                this.bufferQueue.addFirst(buf.slice());
                return l;
            }
            return ByteBuffer.wrap(this.read(8)).getLong();
        }

        private boolean inputBytesAvailable(int size) {
            int l = 0;
            for (ByteBuffer buffer : this.bufferQueue) {
                if ((l += buffer.limit() - buffer.position()) < size) continue;
                return true;
            }
            return false;
        }

        private byte[] read(int length) throws IOException {
            byte[] bytes = new byte[length];
            int pointer = 0;
            if (!this.inputBytesAvailable(length)) {
                throw new BufferUnderflowException();
            }
            ByteBuffer buffer = this.bufferQueue.removeFirst();
            while (true) {
                if (buffer.hasRemaining()) {
                    bytes[pointer] = buffer.get();
                    if (++pointer != length) continue;
                    if (buffer.position() < buffer.limit()) {
                        this.bufferQueue.addFirst(buffer.slice());
                    }
                    return bytes;
                }
                buffer = this.bufferQueue.poll();
                if (buffer == null) break;
            }
            throw new IOException("unexpected Buffer underflow occured");
        }

        private int getAvailableBytesOfFirstBuffer() {
            if (this.bufferQueue.size() < 1) {
                return 0;
            }
            ByteBuffer buffer = this.bufferQueue.getFirst();
            return buffer.limit() - buffer.position();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (ByteBuffer buffer : this.bufferQueue) {
                sb.append(TextUtils.toString(buffer.duplicate(), "UTF-8"));
            }
            return sb.toString();
        }
    }
}

