/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.server;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.server.IConnectHandler;
import org.xsocket.server.IConnectionScoped;
import org.xsocket.server.IDataHandler;
import org.xsocket.server.IHandler;
import org.xsocket.server.ITimeoutHandler;
import org.xsocket.server.NonBlockingConnection;
import org.xsocket.server.WorkerPool;
import org.xsocket.util.TextUtils;

final class InternalHandler
implements Cloneable {
    private static final Logger LOG = Logger.getLogger(InternalHandler.class.getName());
    private WorkerPool workerPool = null;
    private IHandler handler = null;
    private boolean isConnectHandler = false;
    private boolean isDataHandler = false;
    private boolean isTimeoutHandler = false;
    private boolean isConnetionScoped = false;

    InternalHandler(IHandler handler) {
        this.handler = handler;
        if (handler instanceof IConnectHandler) {
            this.isConnectHandler = true;
        }
        if (handler instanceof IDataHandler) {
            this.isDataHandler = true;
        }
        if (handler instanceof ITimeoutHandler) {
            this.isTimeoutHandler = true;
        }
        if (handler instanceof IConnectionScoped) {
            this.isConnetionScoped = true;
        }
    }

    public void setWorkerPool(WorkerPool workerPool) {
        this.workerPool = workerPool;
    }

    public void onConnect(final NonBlockingConnection connection) {
        if (this.isConnectHandler) {
            this.workerPool.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    block5: {
                        try {
                            NonBlockingConnection nonBlockingConnection = connection;
                            synchronized (nonBlockingConnection) {
                                ((IConnectHandler)InternalHandler.this.handler).onConnect(connection);
                            }
                        }
                        catch (Throwable e) {
                            if (!LOG.isLoggable(Level.FINER)) break block5;
                            LOG.finer("error occured by handling connection opening by handler " + InternalHandler.this.handler.getClass().getName() + "#" + InternalHandler.this.handler.hashCode() + ". Reason: " + e.toString());
                        }
                    }
                }
            });
        }
    }

    public void onData(final NonBlockingConnection connection) throws IOException {
        if (this.isDataHandler) {
            this.workerPool.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    block5: {
                        try {
                            NonBlockingConnection nonBlockingConnection = connection;
                            synchronized (nonBlockingConnection) {
                                ((IDataHandler)InternalHandler.this.handler).onData(connection);
                            }
                        }
                        catch (Throwable e) {
                            if (!LOG.isLoggable(Level.FINER)) break block5;
                            LOG.finer("error occured by handling connection data by handler " + InternalHandler.this.handler.getClass().getName() + "#" + InternalHandler.this.handler.hashCode() + ". Reason: " + e.toString());
                        }
                    }
                }
            });
        }
    }

    public void onIdleTimeout(NonBlockingConnection connection) throws IOException {
        boolean handled;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("idle timeout (" + TextUtils.printFormatedDuration(connection.getIdleTimeout()) + ") reached for connection " + connection.toString());
        }
        if (this.isTimeoutHandler && (handled = ((ITimeoutHandler)this.handler).onIdleTimeout(connection))) {
            return;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("connection will be closed");
        }
        connection.close();
    }

    public void onConnectionTimeout(NonBlockingConnection connection) throws IOException {
        boolean handled;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("connection timeout (" + TextUtils.printFormatedDuration(connection.getConnectionTimeout()) + ") reached for connection " + connection.toString());
        }
        if (this.isTimeoutHandler && (handled = ((ITimeoutHandler)this.handler).onConnectionTimeout(connection))) {
            return;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("connection will be closed");
        }
        connection.close();
    }

    public void onClose(NonBlockingConnection connection) {
        if (this.isConnetionScoped) {
            this.close();
        }
    }

    public void close() {
    }

    public Object clone() throws CloneNotSupportedException {
        if (this.isConnetionScoped) {
            InternalHandler copy = (InternalHandler)super.clone();
            copy.handler = (IHandler)((IConnectionScoped)((Object)this.handler)).clone();
            return copy;
        }
        return this;
    }
}

