/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.server;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.xsocket.server.Dispatcher;
import org.xsocket.server.IHandler;
import org.xsocket.server.IMultithreadedServer;
import org.xsocket.server.InternalHandler;
import org.xsocket.server.NonBlockingConnection;
import org.xsocket.server.WorkerPool;
import org.xsocket.util.TextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultithreadedServer
implements IMultithreadedServer {
    private static final Logger LOG = Logger.getLogger(MultithreadedServer.class.getName());
    public static final int DEFAULT_DISPATCHER_SIZE = 2;
    public static final int DEFAULT_PREALLOCATION_SIZE = 64768;
    public static final long DEFAULT_IDLE_TIMEOUT = Long.MAX_VALUE;
    public static final long DEFAULT_CONNECTION_TIMEOUT = Long.MAX_VALUE;
    public static final long DEFAULT_TIMEOUT_CHECK_PERIOD = 20000L;
    private boolean isRunning = true;
    private String idPrefix = null;
    private long nextId = 1L;
    private int port = 0;
    private ServerSocketChannel serverChannel = null;
    private long idleTimeout = Long.MAX_VALUE;
    private long connectionTimeout = Long.MAX_VALUE;
    private long timeoutCheckPeriod = 20000L;
    private InternalHandler handler = null;
    private WorkerPool workerPool = new WorkerPool();
    private final LinkedList<Dispatcher> dispatchers = new LinkedList();
    private int dispatcherSize = 2;
    private int preallocationSize = 64768;
    private int dispatcherPointer = 0;
    private String name = null;
    private String domain = null;
    private ObjectName mbeanName = null;
    private long handledConnections = 0L;

    public MultithreadedServer(int port) throws UnknownHostException, IOException {
        this(port, "xsocket." + port);
    }

    public MultithreadedServer(int port, String domain) throws UnknownHostException, IOException {
        this.port = port;
        this.domain = domain;
        this.name = InetAddress.getLocalHost().getCanonicalHostName() + "." + port;
        this.initBaseID(InetAddress.getLocalHost(), port);
        this.serverChannel = ServerSocketChannel.open();
        this.serverChannel.socket().bind(new InetSocketAddress(port));
        this.serverChannel.configureBlocking(true);
    }

    private void initBaseID(InetAddress address, int port) {
        int id = (new String(address.getAddress()) + ":" + port).hashCode();
        if (id < 0) {
            id = 0 - id;
        }
        int random = 0;
        while ((random = new Random().nextInt()) < 0) {
        }
        this.idPrefix = id + "." + System.currentTimeMillis() + "." + random;
    }

    private final String generatedId() {
        return this.idPrefix + "." + this.nextId++;
    }

    @Override
    public final void run() {
        this.init();
        while (this.isRunning) {
            this.processing();
        }
    }

    private void init() {
        if (this.handler == null) {
            LOG.warning("no handler has been set. Call setHandler-method to set an assigned handler");
        }
        this.setDispatcherPoolSize(this.dispatcherSize);
        LOG.info("server has been bound on port " + this.port + "  (" + this.getVersionIfo() + ")");
        LOG.fine("connectionTimeout=" + TextUtils.printFormatedDuration(this.connectionTimeout) + "; idleTimeout=" + TextUtils.printFormatedDuration(this.idleTimeout));
        try {
            StandardMBean mbean = new StandardMBean(this, IMultithreadedServer.class);
            this.mbeanName = new ObjectName(this.domain + ":type=MultithreadedServer,name=" + this.name);
            ManagementFactory.getPlatformMBeanServer().registerMBean(mbean, this.mbeanName);
        }
        catch (Exception mbe) {
            LOG.warning("error " + mbe.toString() + " occured while registering mbean");
        }
    }

    private String getVersionIfo() {
        Package p = Package.getPackage("org.xsocket");
        if (p != null) {
            return p.getSpecificationTitle() + " " + p.getImplementationVersion();
        }
        return "";
    }

    private void processing() {
        block2: {
            try {
                SocketChannel sc = this.serverChannel.accept();
                this.newConnection(sc);
            }
            catch (Throwable t) {
                if (!this.isRunning) break block2;
                LOG.warning("Exception occured while accepting new incomming connection. Reason: " + t.toString());
            }
        }
    }

    private void newConnection(SocketChannel sc) throws IOException {
        if (sc != null) {
            NonBlockingConnection connection = this.newNonBlockingConnection(sc, this.generatedId());
            connection.setConnectionTimeout(this.connectionTimeout);
            connection.setIdleTimeout(this.idleTimeout);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + connection.getId() + "] new incoming connection " + connection);
            }
            this.getNextDispatcher().acceptNewConnection(connection);
            ++this.handledConnections;
        }
    }

    protected NonBlockingConnection newNonBlockingConnection(SocketChannel sc, String id) throws IOException {
        return new NonBlockingConnection(sc, id);
    }

    private Dispatcher getNextDispatcher() {
        ++this.dispatcherPointer;
        if (this.dispatcherPointer >= this.dispatchers.size()) {
            this.dispatcherPointer = 0;
        }
        return this.dispatchers.get(this.dispatcherPointer);
    }

    @Override
    public final void shutdown() {
        if (this.isRunning) {
            this.isRunning = false;
            try {
                ManagementFactory.getPlatformMBeanServer().unregisterMBean(this.mbeanName);
            }
            catch (Exception mbe) {
                LOG.warning("error " + mbe.toString() + " occured while unregistering mbean");
            }
            try {
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.fine("close handler");
                }
                this.handler.close();
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.fine("close selector and socket");
                }
                this.serverChannel.close();
                LOG.fine("shuting down worker pool");
                this.workerPool.shutdownNow();
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.fine("terminate dispatchers");
                }
                for (Dispatcher dispatcher : this.getDispatchers()) {
                    dispatcher.shutdown();
                }
                LOG.info("unbind port " + this.port);
            }
            catch (IOException ioe) {
                LOG.warning("Exception occured while tear down TcpServer. Reason: " + ioe.toString());
                throw new RuntimeException(ioe);
            }
        }
    }

    @Override
    public final int getPort() {
        return this.port;
    }

    @Override
    public synchronized void setHandler(IHandler hdl) {
        this.handler = new InternalHandler(hdl);
        for (Dispatcher dispatcher : this.dispatchers) {
            dispatcher.setHandler(this.handler);
        }
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    @Override
    public void setWorkerPoolSize(int workerSize) {
        this.workerPool.setSize(workerSize);
    }

    @Override
    public int getWorkerPoolSize() {
        return this.workerPool.getSize();
    }

    @Override
    public final int getReceiveBufferPreallocationSize() {
        return this.preallocationSize;
    }

    @Override
    public final void setReceiveBufferPreallocationSize(int size) {
        this.preallocationSize = size;
        for (Dispatcher dispatcher : this.dispatchers) {
            dispatcher.setReceiveBufferPreallocationSize(this.preallocationSize);
        }
    }

    @Override
    public final List<Dispatcher> getDispatchers() {
        return this.dispatchers;
    }

    @Override
    public final synchronized void setDispatcherPoolSize(int size) {
        block3: {
            int poolsize;
            block2: {
                this.dispatcherSize = size;
                poolsize = this.dispatchers.size();
                if (poolsize <= this.dispatcherSize) break block2;
                for (int i = this.dispatcherSize; i < poolsize; ++i) {
                    Dispatcher dispatcher = this.dispatchers.getLast();
                    this.dispatchers.remove(dispatcher);
                    dispatcher.shutdown();
                }
                break block3;
            }
            if (poolsize >= this.dispatcherSize) break block3;
            for (int i = poolsize; i < this.dispatcherSize; ++i) {
                String dispatcherName = "Dispatcher_" + i;
                Dispatcher dispatcher = null;
                dispatcher = new Dispatcher(this.preallocationSize, this.workerPool, this.domain, dispatcherName);
                dispatcher.setHandler(this.handler);
                this.dispatchers.addLast(dispatcher);
                Thread t = new Thread(dispatcher);
                t.setName(dispatcherName);
                t.setDaemon(false);
                t.start();
            }
        }
    }

    @Override
    public final synchronized int getDispatcherPoolSize() {
        return this.dispatcherSize;
    }

    @Override
    public final long getNumberOfHandledConnections() {
        long result = 0L;
        for (Dispatcher dispatcher : this.dispatchers) {
            result += dispatcher.getNumberOfHandledConnections();
        }
        return result;
    }

    @Override
    public final int getNumberOfOpenConnections() {
        int result = 0;
        for (Dispatcher dispatcher : this.dispatchers) {
            result += dispatcher.getNumberOfOpenConnections();
        }
        return result;
    }

    @Override
    public final List<String> getOpenConnections() {
        ArrayList<String> result = new ArrayList<String>();
        for (Dispatcher dispatcher : this.dispatchers) {
            result.addAll(dispatcher.getOpenConnections());
        }
        return result;
    }

    @Override
    public final long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Override
    public final void setConnectionTimeout(long timeout) {
        this.connectionTimeout = timeout;
    }

    @Override
    public final long getIdleTimeout() {
        return this.idleTimeout;
    }

    @Override
    public final void setIdleTimeout(long timeout) {
        this.idleTimeout = timeout;
    }

    @Override
    public final int getNumberOfConnectionTimeout() {
        int result = 0;
        for (Dispatcher disptacher : this.dispatchers) {
            result += disptacher.getNumberOfConnectionTimeout();
        }
        return result;
    }

    @Override
    public final int getNumberOfReceivingTimeout() {
        int result = 0;
        for (Dispatcher disptacher : this.dispatchers) {
            result += disptacher.getNumberOfIdleTimeout();
        }
        return result;
    }

    @Override
    public final long getTimeoutCheckPeriod() {
        return this.timeoutCheckPeriod;
    }

    @Override
    public final void setTimeoutCheckPeriod(long period) {
        this.timeoutCheckPeriod = period;
        for (Dispatcher disptacher : this.dispatchers) {
            disptacher.setTimeoutCheckPeriod(period);
        }
    }
}

