/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.server;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.AbstractConnection;
import org.xsocket.ClosedConnectionException;
import org.xsocket.server.Dispatcher;
import org.xsocket.server.INonBlockingConnection;
import org.xsocket.server.InternalHandler;
import org.xsocket.util.TextUtils;

class NonBlockingConnection
extends AbstractConnection
implements INonBlockingConnection {
    private static final Logger LOG = Logger.getLogger(NonBlockingConnection.class.getName());
    private SocketChannel channel = null;
    private SelectionKey key = null;
    private InternalHandler handler = null;
    private long idleTimeout = 0L;
    private long connectionTimeout = 0L;
    private final AbstractConnection.Queue sendQueue = new AbstractConnection.Queue();

    public NonBlockingConnection(SocketChannel channel, String id) throws IOException {
        this.channel = channel;
        this.setId(id);
    }

    protected final SocketChannel getAssignedSocketChannel() {
        return this.channel;
    }

    public void handleNonBlockingRead() throws ClosedConnectionException, IOException {
        int bytesAdded = this.getReceiveQueue().append(this.readPhysical());
        if (bytesAdded > 0) {
            this.getAssignedHandler().onData(this);
        }
    }

    public void handleNonBlockingWrite() throws ClosedConnectionException, IOException {
        LinkedList<ByteBuffer> queue = this.sendQueue.drain();
        this.writePhysical(queue.toArray(new ByteBuffer[queue.size()]));
    }

    public void handleIdleTimeout() throws IOException {
        this.handler.onIdleTimeout(this);
    }

    public void handleConnectionTimeout() throws IOException {
        this.handler.onConnectionTimeout(this);
    }

    public long write(ByteBuffer[] buffers) throws ClosedConnectionException, IOException {
        long written = 0L;
        for (ByteBuffer buffer : buffers) {
            written += (long)this.sendQueue.append(buffer);
        }
        if (written > 0L) {
            try {
                this.key.interestOps(5);
                this.key.selector().wakeup();
            }
            catch (CancelledKeyException cke) {
                ClosedConnectionException cce = new ClosedConnectionException("connection " + this.getId() + " is already closed");
                LOG.throwing(this.getClass().getName(), "write(ByteBuffer[]", cce);
                throw cce;
            }
        }
        return written;
    }

    public final ByteBuffer[] readRecord(String delimiter) throws IOException {
        AbstractConnection.ByteBufferArrayChannel channel = new AbstractConnection.ByteBufferArrayChannel();
        this.getReceiveQueue().readRecord(delimiter, channel);
        return channel.getContent();
    }

    public final String readWord(String delimiter) throws IOException {
        return this.readWord(delimiter, this.getDefaultEncoding());
    }

    public int readInt() throws IOException, BufferUnderflowException {
        return this.getReceiveQueue().readInt();
    }

    public long readLong() throws IOException, BufferUnderflowException {
        return this.getReceiveQueue().readLong();
    }

    public double readDouble() throws IOException, BufferUnderflowException {
        return this.getReceiveQueue().readDouble();
    }

    public byte readByte() throws IOException, BufferUnderflowException {
        return this.getReceiveQueue().readByte();
    }

    public final String readWord(String delimiter, String encoding) throws IOException, BufferUnderflowException {
        AbstractConnection.ByteBufferArrayChannel channel = new AbstractConnection.ByteBufferArrayChannel();
        this.getReceiveQueue().readRecord(delimiter, channel);
        return TextUtils.toString(channel.getContent(), encoding);
    }

    public final ByteBuffer[] readAvailable() throws ClosedConnectionException, IOException {
        LinkedList<ByteBuffer> queue = this.getReceiveQueue().drain();
        return queue.toArray(new ByteBuffer[queue.size()]);
    }

    public boolean readAvailable(String delimiter, WritableByteChannel outputChannel) throws IOException {
        return this.getReceiveQueue().readAvailable(delimiter, outputChannel);
    }

    public int getNumberOfAvailableBytes() {
        return this.getReceiveQueue().getSize();
    }

    public final void stopReceiving() {
        super.stopReading();
    }

    public boolean hasDataToSend() {
        return this.sendQueue.getSize() > 0;
    }

    public void init(InternalHandler handler) throws IOException {
        this.setHandler(handler);
        handler.onConnect(this);
    }

    protected final void setHandler(InternalHandler handler) throws IOException {
        this.handler = handler;
    }

    public final void registerSelector(Selector selector, int ops) throws IOException {
        if (this.isOpen()) {
            this.channel.configureBlocking(false);
            this.key = this.channel.register(selector, ops, this);
        }
    }

    public long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    void setConnectionTimeout(long timeout) {
        this.connectionTimeout = timeout;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    void setIdleTimeout(long timeout) {
        this.idleTimeout = timeout;
    }

    protected final ByteBuffer acquireMemory() {
        return Dispatcher.getMemoryManager().acquireMemory();
    }

    public synchronized void close() {
        block3: {
            try {
                this.key.cancel();
            }
            catch (Exception ioe) {
                if (!LOG.isLoggable(Level.FINE)) break block3;
                LOG.fine("[" + this.getId() + "] error occured while closing key: " + ioe.toString());
            }
        }
        if (this.handler != null) {
            this.handler.onClose(this);
        }
        super.close();
    }

    protected final void recycleMemory(ByteBuffer buf) {
        Dispatcher.getMemoryManager().recycleMemory(buf);
    }

    void updateSelectionKeyOps(int ops) {
        this.key.interestOps(ops);
    }

    protected final InternalHandler getAssignedHandler() {
        return this.handler;
    }

    protected final AbstractConnection.Queue getSendQueue() {
        return this.sendQueue;
    }

    public String toString() {
        return super.toString() + ", sendQueueSize=" + this.sendQueue.getSize();
    }
}

