//$Id: ILifeCycle.java 446 2006-12-07 09:56:30Z grro $
/*
 *  Copyright (c) xsocket.org, 2006. All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Please refer to the LGPL license at: http://www.gnu.org/copyleft/lesser.txt
 * The latest copy of this software may be found on http://www.xsocket.org/
 */
package org.xsocket.server;


/**
 * The interfaces defines call back methods, that signals 
 * when a handler has been initialized or destroyed. <br><br>
 * 
 * For connection scoped handlers which implements the 
 * <code>IConnectionScope</code> interface, this methods will 
 * only be called on the prototype handler and not on the 
 * specific clones.
 * 
 * @see IConnectionScoped
 * 
 * @author grro@xsocket.org
 */
public interface ILifeCycle extends IHandler {

	/**
	 * signals that the handler has been loaded
	 * and initialized
	 * 
	 */
	public void onInit();
	
	
	/**
	 * signals that the handler 
	 * will be destroyed
	 *
	 */
	public void onDestroy();
}
