/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLContext;
import org.xsocket.ByteBufferOutputChannel;
import org.xsocket.ClosedConnectionException;
import org.xsocket.Connection;
import org.xsocket.IBlockingConnection;
import org.xsocket.util.TextUtils;

public final class BlockingConnection
extends Connection
implements IBlockingConnection {
    public BlockingConnection(String hostname, int port) throws IOException {
        this(hostname, port, null, false);
    }

    public BlockingConnection(String hostname, int port, SSLContext sslContext, boolean sslOn) throws IOException {
        this(SocketChannel.open(new InetSocketAddress(hostname, port)), sslContext, sslOn);
    }

    private BlockingConnection(SocketChannel channel, SSLContext sslContext, boolean sslOn) throws IOException {
        super(channel, null, true, sslContext, sslOn);
        channel.configureBlocking(false);
        this.init();
    }

    public ByteBuffer[] receiveByteBufferByDelimiter(String delimiter) throws IOException, ClosedConnectionException, SocketTimeoutException {
        ByteBufferOutputChannel channel = new ByteBufferOutputChannel();
        while (true) {
            try {
                this.extractRecordByDelimiterFromReadQueue(delimiter, channel);
                return channel.toByteBufferArray();
            }
            catch (BufferUnderflowException bue) {
                this.readIncoming();
                continue;
            }
            break;
        }
    }

    public byte[] receiveBytesByDelimiter(String delimiter) throws IOException, ClosedConnectionException, SocketTimeoutException {
        return this.toArray(this.receiveByteBufferByDelimiter(delimiter));
    }

    public ByteBuffer[] receiveByteBufferByLength(int length) throws IOException, ClosedConnectionException, SocketTimeoutException {
        ByteBufferOutputChannel channel = new ByteBufferOutputChannel();
        while (true) {
            try {
                this.extractRecordByLength(length, channel);
                return channel.toByteBufferArray();
            }
            catch (BufferUnderflowException bue) {
                this.readIncoming();
                continue;
            }
            break;
        }
    }

    public byte[] receiveBytesByLength(int length) throws IOException, ClosedConnectionException, SocketTimeoutException {
        return this.toArray(this.receiveByteBufferByLength(length));
    }

    public String receiveStringByLength(int length) throws IOException, ClosedConnectionException, SocketTimeoutException {
        return this.receiveStringByLength(length, this.getDefaultEncoding());
    }

    public String receiveStringByLength(int length, String encoding) throws IOException, ClosedConnectionException, SocketTimeoutException {
        while (true) {
            try {
                ByteBufferOutputChannel channel = new ByteBufferOutputChannel();
                this.extractRecordByLength(length, channel);
                return TextUtils.toString(channel.toByteBufferArray(), encoding);
            }
            catch (BufferUnderflowException bue) {
                this.readIncoming();
                continue;
            }
            break;
        }
    }

    public String receiveStringByDelimiter(String delimiter, String encoding) throws IOException, ClosedConnectionException, SocketTimeoutException {
        while (true) {
            try {
                ByteBufferOutputChannel channel = new ByteBufferOutputChannel();
                this.extractRecordByDelimiterFromReadQueue(delimiter, channel);
                return TextUtils.toString(channel.toByteBufferArray(), encoding);
            }
            catch (BufferUnderflowException bue) {
                this.readIncoming();
                continue;
            }
            break;
        }
    }

    public String receiveStringByDelimiter(String delimiter) throws IOException, ClosedConnectionException, SocketTimeoutException {
        return this.receiveStringByDelimiter(delimiter, this.getDefaultEncoding());
    }

    public byte receiveByte() throws IOException, ClosedConnectionException, SocketTimeoutException {
        byte b = 0;
        boolean found = false;
        do {
            try {
                b = this.extractByteFromReadQueue();
                found = true;
            }
            catch (BufferUnderflowException bue) {
                this.readIncoming();
            }
        } while (!found);
        return b;
    }

    public double receiveDouble() throws IOException, ClosedConnectionException, SocketTimeoutException {
        double d = 0.0;
        boolean found = false;
        do {
            try {
                d = this.extractDoubleFromReadQueue();
                found = true;
            }
            catch (BufferUnderflowException bue) {
                this.readIncoming();
            }
        } while (!found);
        return d;
    }

    public int receiveInt() throws IOException, ClosedConnectionException, SocketTimeoutException {
        int i = 0;
        boolean found = false;
        do {
            try {
                i = this.extractIntFromReadQueue();
                found = true;
            }
            catch (BufferUnderflowException bue) {
                this.readIncoming();
            }
        } while (!found);
        return i;
    }

    public long receiveLong() throws IOException, ClosedConnectionException, SocketTimeoutException {
        long l = 0L;
        boolean found = false;
        do {
            try {
                l = this.extractLongFromReadQueue();
                found = true;
            }
            catch (BufferUnderflowException bue) {
                this.readIncoming();
            }
        } while (!found);
        return l;
    }

    protected void flushOutgoing() {
    }
}

