/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket;

import java.io.IOException;
import java.net.InetAddress;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.xsocket.ByteBufferParser;
import org.xsocket.ClosedConnectionException;
import org.xsocket.IConnection;
import org.xsocket.SSLProcessor;
import org.xsocket.util.TextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class Connection
implements IConnection {
    private static final Logger LOG = Logger.getLogger(Connection.class.getName());
    private static final int DEBUG_MAX_OUTPUT_SIZE = 200;
    public static final int DEFAULT_PREALLOCATION_SIZE = 4096;
    private static final ByteBufferParser PARSER = new ByteBufferParser();
    private boolean isConnected = false;
    private SocketChannel channel = null;
    private String id = null;
    private final ReadQueue readQueue = new ReadQueue();
    private SSLContext sslContext = null;
    private boolean sslOn = false;
    private boolean isClientMode = true;
    private SSLProcessor sslProcessor = null;
    private String defaultEncoding = "UTF-8";
    private static long nextId = 0L;
    private static String idPrefix = null;
    private ByteBuffer readBuffer = null;
    private ByteBufferParser.Index cachedIndex = null;
    private long lastTimeRead = 0L;
    private long bytesRead = 0L;
    private long bytesWritten = 0L;
    private long connectionOpenedTime = -1L;
    private long connectionEndTime = -1L;

    Connection(SocketChannel channel, String localId, boolean clientMode, SSLContext sslContext, boolean sslOn) throws IOException {
        if (channel == null) {
            throw new NullPointerException("parameter channel is not set");
        }
        this.channel = channel;
        this.isClientMode = clientMode;
        this.sslContext = sslContext;
        this.sslOn = sslOn;
        this.id = localId == null ? idPrefix + "." + this.nextLocalId() : idPrefix + "." + localId;
        this.lastTimeRead = this.connectionOpenedTime = System.currentTimeMillis();
        if (sslOn) {
            this.sslProcessor = SSLProcessor.newProcessor(this, clientMode, sslContext);
            this.sslProcessor.start();
        }
    }

    protected void init() {
        if (!this.sslOn) {
            this.onConnect();
        }
    }

    protected void onConnect() {
        this.isConnected = true;
    }

    @Override
    public final void startSSL() throws IOException {
        if (this.sslContext == null) {
            throw new IOException("sslContext is missing (for client connections this has to be set within the connection constructor");
        }
        if (!this.sslOn) {
            this.flushOutgoing();
            this.sslProcessor = SSLProcessor.newProcessor(this, this.isClientMode, this.sslContext);
            this.sslProcessor.start();
            this.sslOn = true;
        }
    }

    private synchronized long nextLocalId() {
        if (++nextId < 0L) {
            nextId = 1L;
        }
        return nextId;
    }

    @Override
    public final String getId() {
        return this.id;
    }

    @Override
    public boolean isOpen() {
        if (this.channel == null) {
            return false;
        }
        return this.channel.isOpen();
    }

    @Override
    public void close() {
        block3: {
            this.flushOutgoing();
            this.connectionEndTime = System.currentTimeMillis();
            if (this.channel != null) {
                try {
                    this.channel.close();
                }
                catch (Exception ioe) {
                    if (!LOG.isLoggable(Level.FINE)) break block3;
                    LOG.fine("[" + this.id + "] error occured while closing underlying channel: " + ioe.toString());
                }
            }
        }
    }

    final boolean isConnected() {
        return this.isConnected;
    }

    @Override
    public final int getRemotePort() {
        return this.channel.socket().getPort();
    }

    @Override
    public final InetAddress getRemoteAddress() {
        return this.channel.socket().getInetAddress();
    }

    @Override
    public final InetAddress getLocalAddress() {
        return this.channel.socket().getLocalAddress();
    }

    @Override
    public final long getConnectionOpenedTime() {
        return this.connectionOpenedTime;
    }

    @Override
    public final long getLastReceivingTime() {
        return this.lastTimeRead;
    }

    @Override
    public final int getLocalePort() {
        return this.channel.socket().getLocalPort();
    }

    protected final byte[] toArray(ByteBuffer[] buffers) {
        byte[] result = null;
        if (buffers == null) {
            return null;
        }
        for (ByteBuffer buffer : buffers) {
            if (result == null) {
                byte[] bytes = this.toArray(buffer);
                if (bytes.length <= 0) continue;
                result = bytes;
                continue;
            }
            byte[] additionalBytes = this.toArray(buffer);
            byte[] newResult = new byte[result.length + additionalBytes.length];
            System.arraycopy(result, 0, newResult, 0, result.length);
            System.arraycopy(additionalBytes, 0, newResult, result.length, additionalBytes.length);
            result = newResult;
        }
        return result;
    }

    private byte[] toArray(ByteBuffer buffer) {
        byte[] array = new byte[buffer.limit() - buffer.position()];
        if (buffer.hasArray()) {
            int offset = buffer.arrayOffset();
            byte[] bufferArray = buffer.array();
            System.arraycopy(bufferArray, offset, array, 0, array.length);
            return array;
        }
        buffer.get(array);
        return array;
    }

    @Override
    public final void setDefaultEncoding(String encoding) {
        this.defaultEncoding = encoding;
    }

    @Override
    public final String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    protected final boolean isSSLOn() {
        return this.sslOn;
    }

    @Override
    public final int write(String s) throws ClosedConnectionException, IOException {
        return this.write(s, this.defaultEncoding);
    }

    @Override
    public final int write(String s, String encoding) throws ClosedConnectionException, IOException {
        ByteBuffer buffer = TextUtils.toByteBuffer(s, encoding);
        return this.write(buffer);
    }

    @Override
    public final int write(byte b) throws ClosedConnectionException, IOException {
        ByteBuffer buffer = ByteBuffer.allocate(1).put(b);
        buffer.flip();
        return this.write(buffer);
    }

    @Override
    public final int write(byte ... bytes) throws ClosedConnectionException, IOException {
        return this.write(ByteBuffer.wrap(bytes));
    }

    @Override
    public final int write(byte[] bytes, int offset, int length) throws ClosedConnectionException, IOException {
        return this.write(ByteBuffer.wrap(bytes, offset, length));
    }

    @Override
    public long write(ByteBuffer[] buffers) throws ClosedConnectionException, IOException {
        long written = 0L;
        for (ByteBuffer buffer : buffers) {
            written += (long)(buffer.limit() - buffer.position());
        }
        this.writeOutgoing(buffers);
        return written;
    }

    @Override
    public int write(ByteBuffer buffer) throws ClosedConnectionException, IOException {
        int written = buffer.limit() - buffer.position();
        this.writeOutgoing(new ByteBuffer[]{buffer});
        return written;
    }

    @Override
    public final int write(int i) throws ClosedConnectionException, IOException {
        ByteBuffer buffer = ByteBuffer.allocate(4).putInt(i);
        buffer.flip();
        return this.write(buffer);
    }

    @Override
    public final int write(long l) throws ClosedConnectionException, IOException {
        ByteBuffer buffer = ByteBuffer.allocate(8).putLong(l);
        buffer.flip();
        return this.write(buffer);
    }

    @Override
    public final int write(double d) throws ClosedConnectionException, IOException {
        ByteBuffer buffer = ByteBuffer.allocate(8).putDouble(d);
        buffer.flip();
        return this.write(buffer);
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        ByteBuffer[] bufs = new ByteBuffer[length];
        System.arraycopy(srcs, offset, bufs, 0, length);
        return this.write(bufs);
    }

    protected final void writeOutgoing(ByteBuffer[] buffers) throws IOException, ClosedConnectionException {
        if (this.sslOn) {
            this.sslProcessor.writeOutgoing(buffers);
        } else {
            while ((buffers = this.writePhysical(buffers)) != null) {
            }
        }
    }

    protected synchronized ByteBuffer[] writePhysical(ByteBuffer[] buffers) throws ClosedConnectionException, IOException {
        if (this.isOpen()) {
            if (buffers.length > 0) {
                int sizeToSend = 0;
                for (ByteBuffer buffer : buffers) {
                    sizeToSend += buffer.remaining();
                }
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.id + "] sending (" + sizeToSend + " bytes): " + TextUtils.toTextOrHexString(buffers, "UTF-8", 200));
                }
                long numberOfSendData = this.channel.write(buffers);
                this.bytesWritten += numberOfSendData;
                if (numberOfSendData < (long)sizeToSend) {
                    ArrayList<ByteBuffer> unwritten = new ArrayList<ByteBuffer>();
                    for (ByteBuffer buffer : buffers) {
                        if (buffer.remaining() <= 0) continue;
                        unwritten.add(buffer);
                    }
                    return unwritten.toArray(new ByteBuffer[unwritten.size()]);
                }
            }
            return null;
        }
        ClosedConnectionException cce = new ClosedConnectionException("[" + this.id + "] connection " + this.id + " ist already closed. Couldn't write");
        LOG.throwing(this.getClass().getName(), "send(ByteBuffer[])", cce);
        throw cce;
    }

    protected final LinkedList<ByteBuffer> extractAvailableFromReadQueue() {
        this.resetCachedIndex();
        return this.readQueue.drain();
    }

    protected final void extractRecordByLength(int length, WritableByteChannel outChannel) throws IOException {
        LinkedList<ByteBuffer> buffers;
        if (this.readQueue.getSize() >= length) {
            buffers = this.readQueue.drain();
            assert (buffers != null);
        } else {
            throw new BufferUnderflowException();
        }
        PARSER.extract(buffers, length, outChannel);
        this.readQueue.addFirst(buffers);
        this.resetCachedIndex();
    }

    int appenToReadQueue(ByteBuffer buffer) {
        return this.readQueue.append(buffer);
    }

    protected int getReadQueueSize() {
        return this.readQueue.getSize();
    }

    protected final void extractRecordByDelimiterFromReadQueue(String delimiter, WritableByteChannel outChannel) throws IOException {
        if (!this.readQueue.isEmtpy()) {
            LinkedList<ByteBuffer> buffers = this.readQueue.drain();
            assert (buffers != null);
            ByteBufferParser.Index index = this.scanByDelimiter(buffers, delimiter);
            if (index.hasDelimiterFound()) {
                PARSER.extract(buffers, index, outChannel);
                this.readQueue.addFirst(buffers);
                this.resetCachedIndex();
                return;
            }
            this.readQueue.addFirst(buffers);
            this.cachedIndex = index;
        }
        throw new BufferUnderflowException();
    }

    protected final boolean extractAvailableFromReadQueue(String delimiter, WritableByteChannel outChannel) throws IOException {
        if (!this.readQueue.isEmtpy()) {
            int availableBytes;
            LinkedList<ByteBuffer> buffers = this.readQueue.drain();
            assert (buffers != null);
            ByteBufferParser.Index index = this.scanByDelimiter(buffers, delimiter);
            if (index.hasDelimiterFound()) {
                PARSER.extract(buffers, index, outChannel);
                this.readQueue.addFirst(buffers);
                this.resetCachedIndex();
                return true;
            }
            int readBytes = index.getReadBytes();
            if (readBytes > 0 && (availableBytes = readBytes - index.getDelimiterPos()) > 0) {
                PARSER.extract(buffers, availableBytes, outChannel);
                this.readQueue.addFirst(buffers);
                this.resetCachedIndex();
            }
            return false;
        }
        return false;
    }

    private ByteBufferParser.Index scanByDelimiter(LinkedList<ByteBuffer> buffers, String delimiter) {
        if (this.cachedIndex != null) {
            if (this.cachedIndex.getDelimiter().equals(delimiter)) {
                return PARSER.find(buffers, this.cachedIndex);
            }
            this.cachedIndex = null;
        }
        return PARSER.find(buffers, delimiter);
    }

    protected final int extractIntFromReadQueue() throws BufferUnderflowException {
        this.resetCachedIndex();
        if (this.readQueue.getFirstBufferSize() >= 4) {
            ByteBuffer buf = this.readQueue.removeFirst();
            assert (buf != null);
            int i = buf.getInt();
            this.readQueue.addFirst(buf.slice());
            return i;
        }
        return ByteBuffer.wrap(this.readQueue.read(4)).getInt();
    }

    protected final byte extractByteFromReadQueue() throws BufferUnderflowException {
        this.resetCachedIndex();
        if (this.readQueue.getFirstBufferSize() >= 1) {
            ByteBuffer buf = this.readQueue.removeFirst();
            assert (buf != null);
            byte b = buf.get();
            this.readQueue.addFirst(buf.slice());
            return b;
        }
        throw new BufferUnderflowException();
    }

    protected final double extractDoubleFromReadQueue() throws BufferUnderflowException {
        this.resetCachedIndex();
        if (this.readQueue.getFirstBufferSize() >= 8) {
            ByteBuffer buf = this.readQueue.removeFirst();
            assert (buf != null);
            double d = buf.getDouble();
            this.readQueue.addFirst(buf.slice());
            return d;
        }
        return ByteBuffer.wrap(this.readQueue.read(8)).getDouble();
    }

    protected final long extractLongFromReadQueue() throws BufferUnderflowException {
        this.resetCachedIndex();
        if (this.readQueue.getFirstBufferSize() >= 8) {
            ByteBuffer buf = this.readQueue.removeFirst();
            assert (buf != null);
            long l = buf.getLong();
            this.readQueue.addFirst(buf.slice());
            return l;
        }
        return ByteBuffer.wrap(this.readQueue.read(8)).getLong();
    }

    private void resetCachedIndex() {
        this.cachedIndex = null;
    }

    protected int readIncoming() throws IOException, ClosedConnectionException {
        int readSize = 0;
        if (this.sslOn) {
            readSize = this.sslProcessor.readIncoming();
        } else {
            ByteBuffer buffer = this.readPhysical();
            readSize = this.readQueue.append(buffer);
        }
        return readSize;
    }

    protected ByteBuffer acquireIOReadMemory() {
        if (this.readBuffer == null) {
            this.readBuffer = ByteBuffer.allocate(8192);
        }
        ByteBuffer result = this.readBuffer;
        this.readBuffer = null;
        return result;
    }

    protected void recycleIOReadMemory(ByteBuffer buffer) {
        if (buffer.hasRemaining()) {
            this.readBuffer = buffer;
        }
    }

    final ByteBuffer readPhysical() throws ClosedConnectionException, IOException {
        ByteBuffer result = null;
        if (this.isOpen()) {
            int read = 0;
            ByteBuffer readBuffer = this.acquireIOReadMemory();
            int pos = readBuffer.position();
            int limit = readBuffer.limit();
            try {
                read = this.channel.read(readBuffer);
            }
            catch (IOException ioe) {
                readBuffer.position(pos);
                readBuffer.limit(limit);
                this.recycleIOReadMemory(readBuffer);
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.finer("[" + this.id + "] error occured while reading channel: " + ioe.toString());
                }
                throw ioe;
            }
            switch (read) {
                case -1: {
                    this.recycleIOReadMemory(readBuffer);
                    ClosedConnectionException cce = new ClosedConnectionException("[" + this.id + "] End of stream reached");
                    LOG.throwing(this.getClass().getName(), "read()", cce);
                    throw cce;
                }
                case 0: {
                    this.recycleIOReadMemory(readBuffer);
                    break;
                }
                default: {
                    this.lastTimeRead = System.currentTimeMillis();
                    this.bytesRead += (long)read;
                    int savePos = readBuffer.position();
                    int saveLimit = readBuffer.limit();
                    readBuffer.position(savePos - read);
                    readBuffer.limit(savePos);
                    result = readBuffer.slice();
                    readBuffer.position(savePos);
                    readBuffer.limit(saveLimit);
                    this.recycleIOReadMemory(readBuffer);
                    if (!LOG.isLoggable(Level.FINE)) break;
                    LOG.fine("[" + this.id + "] received (" + (result.limit() - result.position()) + " bytes): " + TextUtils.toTextOrHexString(new ByteBuffer[]{result.duplicate()}, "UTF-8", 200));
                }
            }
        }
        return result;
    }

    protected abstract void flushOutgoing();

    protected SocketChannel getChannel() {
        return this.channel;
    }

    protected final void logFine(String msg) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("[" + this.getId() + "] " + msg);
        }
    }

    protected final void logFiner(String msg) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("[" + this.getId() + "] " + msg);
        }
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof Connection) {
            return ((Connection)other).id.equals(this.id);
        }
        return false;
    }

    @Override
    public String toCompactString() {
        return "id=" + this.getId() + ", caller=" + this.getRemoteAddress().getCanonicalHostName() + "(" + this.getRemoteAddress() + ":" + this.getRemotePort() + ")" + ", opened=" + TextUtils.printFormatedDate(this.connectionOpenedTime);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.toCompactString());
        if (this.connectionEndTime != -1L) {
            sb.append(", lifetime=" + TextUtils.printFormatedDuration(this.connectionEndTime - this.connectionOpenedTime));
        }
        sb.append(", lastTimeReceived=" + TextUtils.printFormatedDate(this.lastTimeRead) + ", received=" + TextUtils.printFormatedBytesSize(this.bytesRead) + ", send=" + TextUtils.printFormatedBytesSize(this.bytesWritten) + ", receiveQueueSize=" + this.readQueue.getSize());
        return sb.toString();
    }

    static {
        String base = null;
        try {
            base = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (Exception e) {
            base = "locale";
        }
        int random = 0;
        while ((random = new Random().nextInt()) < 0) {
        }
        idPrefix = Integer.toHexString(base.hashCode()) + "." + Long.toHexString(System.currentTimeMillis()) + "." + Integer.toHexString(random);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ReadQueue {
        private LinkedList<ByteBuffer> bufferQueue = null;

        private ReadQueue() {
        }

        public synchronized boolean isEmtpy() {
            if (this.bufferQueue == null) {
                return true;
            }
            return this.bufferQueue.isEmpty();
        }

        public synchronized int append(ByteBuffer buffer) {
            if (this.bufferQueue == null) {
                this.bufferQueue = new LinkedList();
            }
            if (buffer != null) {
                int length = buffer.remaining();
                if (length > 0) {
                    this.bufferQueue.addLast(buffer);
                }
                return length;
            }
            return 0;
        }

        public synchronized LinkedList<ByteBuffer> drain() {
            if (this.bufferQueue == null) {
                return null;
            }
            LinkedList<ByteBuffer> result = this.bufferQueue;
            this.bufferQueue = null;
            return result;
        }

        public synchronized int getFirstBufferSize() {
            if (this.bufferQueue == null) {
                return 0;
            }
            if (this.bufferQueue.size() < 1) {
                return 0;
            }
            ByteBuffer buffer = this.bufferQueue.getFirst();
            return buffer.limit() - buffer.position();
        }

        public synchronized ByteBuffer removeFirst() {
            if (this.bufferQueue == null) {
                return null;
            }
            return this.bufferQueue.removeFirst();
        }

        public synchronized void addFirst(ByteBuffer buffer) {
            if (this.bufferQueue == null) {
                this.bufferQueue = new LinkedList();
            }
            if (buffer.hasRemaining()) {
                this.bufferQueue.addFirst(buffer);
            }
        }

        public synchronized void addFirst(LinkedList<ByteBuffer> buffers) {
            if (this.bufferQueue == null) {
                this.bufferQueue = buffers;
                return;
            }
            if (this.bufferQueue.isEmpty()) {
                this.bufferQueue = buffers;
                return;
            }
            for (int i = buffers.size() - 1; i >= 0; --i) {
                ByteBuffer buffer = buffers.get(i);
                if (!buffer.hasRemaining()) continue;
                this.bufferQueue.addFirst(buffer);
            }
        }

        public synchronized byte[] read(int length) throws BufferUnderflowException {
            if (this.bufferQueue == null) {
                throw new BufferUnderflowException();
            }
            byte[] bytes = new byte[length];
            int pointer = 0;
            if (!this.isSizeEqualsOrLargerThan(length)) {
                throw new BufferUnderflowException();
            }
            ByteBuffer buffer = this.bufferQueue.removeFirst();
            while (true) {
                if (buffer.hasRemaining()) {
                    bytes[pointer] = buffer.get();
                    if (++pointer != length) continue;
                    if (buffer.position() < buffer.limit()) {
                        this.bufferQueue.addFirst(buffer.slice());
                    }
                    return bytes;
                }
                buffer = this.bufferQueue.poll();
                if (buffer == null) break;
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Warning unexpected Buffer underflow occured");
            }
            throw new BufferUnderflowException();
        }

        private boolean isSizeEqualsOrLargerThan(int size) {
            if (this.bufferQueue == null) {
                return false;
            }
            int l = 0;
            for (ByteBuffer buffer : this.bufferQueue) {
                if ((l += buffer.limit() - buffer.position()) < size) continue;
                return true;
            }
            return false;
        }

        public synchronized int getSize() {
            if (this.bufferQueue == null) {
                return 0;
            }
            int size = 0;
            int bufferSize = this.bufferQueue.size();
            for (int i = 0; i < bufferSize; ++i) {
                size += this.bufferQueue.get(i).remaining();
            }
            return size;
        }

        public String toString() {
            if (this.bufferQueue == null) {
                return "";
            }
            return TextUtils.toTextOrHexString(this.bufferQueue.toArray(new ByteBuffer[this.bufferQueue.size()]), "US-ASCII", 500);
        }
    }
}

