/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.xsocket.ByteBufferOutputChannel;
import org.xsocket.ClosedConnectionException;
import org.xsocket.Connection;
import org.xsocket.INonBlockingConnection;
import org.xsocket.util.TextUtils;

public class NonBlockingConnection
extends Connection
implements INonBlockingConnection {
    private static final Logger LOG = Logger.getLogger(NonBlockingConnection.class.getName());
    private static final String DELIVER_THREAD_PREXIX = "DeliveryThread";
    private boolean isSendDelayIsActivated = false;
    private int sendBytesPerSec = Integer.MAX_VALUE;
    private final Queue<QueueEntry> sendDelayQueue = new LinkedList<QueueEntry>();
    private static Timer timer = null;
    private TimerTask delayedDelivererTask = null;

    public NonBlockingConnection(String hostname, int port) throws IOException {
        this(hostname, port, null, false);
    }

    public NonBlockingConnection(String hostname, int port, SSLContext sslContext, boolean sslOn) throws IOException {
        this(SocketChannel.open(new InetSocketAddress(hostname, port)), null, true, sslContext, sslOn);
        this.init();
    }

    protected NonBlockingConnection(SocketChannel channel, String id, boolean clientMode, SSLContext sslContext, boolean sslOn) throws IOException {
        super(channel, id, clientMode, sslContext, sslOn);
        channel.configureBlocking(false);
    }

    public final ByteBuffer[] readByteBufferByDelimiter(String delimiter) throws IOException, ClosedConnectionException, BufferUnderflowException {
        this.readIncoming();
        ByteBufferOutputChannel channel = new ByteBufferOutputChannel();
        this.extractRecordByDelimiterFromReadQueue(delimiter, channel);
        return channel.toByteBufferArray();
    }

    public final ByteBuffer[] readByteBufferByLength(int length) throws IOException, ClosedConnectionException, BufferUnderflowException {
        this.readIncoming();
        ByteBufferOutputChannel channel = new ByteBufferOutputChannel();
        this.extractRecordByLength(length, channel);
        return channel.toByteBufferArray();
    }

    public byte[] readBytesByDelimiter(String delimiter) throws IOException, ClosedConnectionException, BufferUnderflowException {
        return this.toArray(this.readByteBufferByDelimiter(delimiter));
    }

    public byte[] readBytesByLength(int length) throws IOException, ClosedConnectionException, BufferUnderflowException {
        return this.toArray(this.readByteBufferByLength(length));
    }

    public final String readStringByDelimiter(String delimiter) throws IOException, ClosedConnectionException, BufferUnderflowException {
        return this.readStringByDelimiter(delimiter, this.getDefaultEncoding());
    }

    public final String readStringByLength(int length) throws IOException, ClosedConnectionException, BufferUnderflowException {
        return this.readStringByLength(length, this.getDefaultEncoding());
    }

    public final int readInt() throws IOException, ClosedConnectionException, BufferUnderflowException {
        this.readIncoming();
        return this.extractIntFromReadQueue();
    }

    public final long readLong() throws IOException, ClosedConnectionException, BufferUnderflowException {
        this.readIncoming();
        return this.extractLongFromReadQueue();
    }

    public final double readDouble() throws IOException, ClosedConnectionException, BufferUnderflowException {
        this.readIncoming();
        return this.extractDoubleFromReadQueue();
    }

    public final byte readByte() throws IOException, BufferUnderflowException {
        this.readIncoming();
        return this.extractByteFromReadQueue();
    }

    public final String readStringByDelimiter(String delimiter, String encoding) throws IOException, ClosedConnectionException, BufferUnderflowException {
        this.readIncoming();
        ByteBufferOutputChannel channel = new ByteBufferOutputChannel();
        this.extractRecordByDelimiterFromReadQueue(delimiter, channel);
        return TextUtils.toString(channel.toByteBufferArray(), encoding);
    }

    public final String readStringByLength(int length, String encoding) throws IOException, ClosedConnectionException, BufferUnderflowException {
        this.readIncoming();
        ByteBufferOutputChannel channel = new ByteBufferOutputChannel();
        this.extractRecordByLength(length, channel);
        return TextUtils.toString(channel.toByteBufferArray(), encoding);
    }

    public int getNumberOfAvailableBytes() {
        return this.getReadQueueSize();
    }

    public final ByteBuffer[] readAvailable() throws ClosedConnectionException, ClosedConnectionException, IOException {
        this.readIncoming();
        LinkedList<ByteBuffer> queue = this.extractAvailableFromReadQueue();
        if (queue != null) {
            return queue.toArray(new ByteBuffer[queue.size()]);
        }
        return new ByteBuffer[0];
    }

    public final boolean readAvailableByDelimiter(String delimiter, WritableByteChannel outputChannel) throws IOException, ClosedConnectionException {
        this.readIncoming();
        return this.extractAvailableFromReadQueue(delimiter, outputChannel);
    }

    public final void setWriteTransferRate(int delaySec) throws ClosedConnectionException, IOException {
        if (delaySec == Integer.MAX_VALUE) {
            if (this.isSendDelayIsActivated) {
                this.isSendDelayIsActivated = false;
                this.delayedDelivererTask.cancel();
                this.flushDelayQueue();
            }
            return;
        }
        this.isSendDelayIsActivated = true;
        this.sendBytesPerSec = delaySec > 1 ? delaySec : 1;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("send delay set with " + this.sendBytesPerSec + " bytes/sec");
        }
    }

    protected void flushOutgoing() {
        block3: {
            if (this.sendDelayQueue != null) {
                try {
                    this.flushDelayQueue();
                }
                catch (IOException ioe) {
                    if (!LOG.isLoggable(Level.FINE)) break block3;
                    LOG.fine("eroor occured by flushing. Reason: " + ioe);
                }
            }
        }
    }

    public final long write(ByteBuffer[] buffers) throws ClosedConnectionException, IOException {
        if (this.isSendDelayIsActivated) {
            return this.delayedWrite(buffers);
        }
        return super.write(buffers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushDelayQueue() throws IOException {
        Queue<QueueEntry> queue = this.sendDelayQueue;
        synchronized (queue) {
            if (!this.sendDelayQueue.isEmpty()) {
                QueueEntry[] entries = this.sendDelayQueue.toArray(new QueueEntry[this.sendDelayQueue.size()]);
                this.sendDelayQueue.clear();
                ByteBuffer[] buffers = new ByteBuffer[entries.length];
                for (int i = 0; i < buffers.length; ++i) {
                    buffers[i] = entries[i].getBuffer();
                }
                super.write(buffers);
            }
        }
    }

    public final int write(ByteBuffer buffer) throws ClosedConnectionException, IOException {
        if (this.isSendDelayIsActivated) {
            return this.delayedWrite(new ByteBuffer[]{buffer});
        }
        return super.write(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int delayedWrite(ByteBuffer[] buffers) {
        int written = 0;
        for (ByteBuffer buffer : buffers) {
            int size = buffer.remaining();
            if (size <= 0) continue;
            written += size;
            int delayTime = size * 1000 / this.sendBytesPerSec;
            Queue<QueueEntry> queue = this.sendDelayQueue;
            synchronized (queue) {
                this.sendDelayQueue.offer(new QueueEntry(System.currentTimeMillis() + (long)delayTime, buffer));
            }
        }
        if (this.delayedDelivererTask == null) {
            this.delayedDelivererTask = new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    Thread.currentThread().setName(NonBlockingConnection.DELIVER_THREAD_PREXIX);
                    long current = System.currentTimeMillis();
                    Queue queue = NonBlockingConnection.this.sendDelayQueue;
                    synchronized (queue) {
                        while (!NonBlockingConnection.this.sendDelayQueue.isEmpty()) {
                            QueueEntry qe = (QueueEntry)NonBlockingConnection.this.sendDelayQueue.peek();
                            if (current < qe.getDeliveryTime()) return;
                            try {
                                NonBlockingConnection.this.sendDelayQueue.remove(qe);
                                NonBlockingConnection.this.writeOutgoing(new ByteBuffer[]{qe.getBuffer()});
                                NonBlockingConnection.this.flushOutgoing();
                            }
                            catch (Throwable e) {
                                if (!LOG.isLoggable(Level.FINE)) continue;
                                LOG.fine("Error occured while write delayed. Reason: " + e.toString());
                            }
                        }
                        return;
                    }
                }
            };
            NonBlockingConnection.getTimer().schedule(this.delayedDelivererTask, 0L, 500L);
        }
        return written;
    }

    private static synchronized Timer getTimer() {
        if (timer == null) {
            timer = new Timer(true);
        }
        return timer;
    }

    private static final class QueueEntry {
        private long deliveryTime = 0L;
        private ByteBuffer buffer = null;

        QueueEntry(long deliveryTime, ByteBuffer buffer) {
            this.deliveryTime = deliveryTime;
            this.buffer = buffer;
        }

        ByteBuffer getBuffer() {
            return this.buffer;
        }

        long getDeliveryTime() {
            return this.deliveryTime;
        }
    }
}

