/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket;

import java.io.IOException;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLContext;
import org.xsocket.ClosedConnectionException;
import org.xsocket.Connection;
import org.xsocket.SSLProcessor;

final class SSLClientProcessor
extends SSLProcessor {
    SSLClientProcessor(Connection connection, SSLContext sslContext) {
        super(connection, true, sslContext);
    }

    final void start() throws IOException {
        super.start();
        this.writeOutgoing(null);
    }

    int readIncoming() throws IOException, ClosedConnectionException {
        int readSize = this.read();
        if (this.needWrap()) {
            this.writeOutgoing(null);
            this.getConnection().flushOutgoing();
        }
        return readSize;
    }

    void writeOutgoing(ByteBuffer[] buffers) throws ClosedConnectionException, IOException {
        if (buffers == null) {
            buffers = new ByteBuffer[]{ByteBuffer.allocateDirect(0)};
        }
        this.write(buffers);
        while (this.isHandshaking()) {
            if (this.needUnwrap()) {
                this.readIncoming();
                continue;
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

