/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.server;

import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.xsocket.server.DispatcherPool;
import org.xsocket.server.IConnectionScoped;
import org.xsocket.server.IHandler;
import org.xsocket.server.IHandlerTypeInfo;
import org.xsocket.server.ManagedConnection;

final class Acceptor {
    private static final Logger LOG = Logger.getLogger(Acceptor.class.getName());
    private boolean isRunning = true;
    private Selector selector = null;
    private ServerSocketChannel serverChannel = null;
    private DispatcherPool dispatcherPool = null;
    private IHandler appHandlerPrototype = null;
    private IHandlerTypeInfo appHandlerTypeInfo = null;
    private boolean sslOn = false;
    private SSLContext sslContext = null;
    private String localIdPrefix = null;
    private long nextId = 0L;
    private long handledConnections = 0L;

    public Acceptor(int serverPort, DispatcherPool dispatcherPool, SSLContext sslContext, boolean sslOn, String localIdPrefix) throws IOException {
        this.dispatcherPool = dispatcherPool;
        this.sslContext = sslContext;
        this.sslOn = sslOn;
        this.localIdPrefix = localIdPrefix;
        try {
            LOG.fine("try to bind server on port " + serverPort);
            this.serverChannel = ServerSocketChannel.open();
            this.serverChannel.configureBlocking(false);
            this.serverChannel.socket().bind(new InetSocketAddress(serverPort));
            this.selector = Selector.open();
            this.serverChannel.register(this.selector, 16);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("acceptor has been bound on port " + serverPort);
            }
        }
        catch (BindException be) {
            if (this.serverChannel != null) {
                this.serverChannel.close();
            }
            LOG.info("error occured while binding server on port " + serverPort + ". Reason: " + be.toString());
            throw be;
        }
    }

    void setHandler(IHandler appHandler, IHandlerTypeInfo appHandlerTypeInfo) {
        this.appHandlerPrototype = appHandler;
        this.appHandlerTypeInfo = appHandlerTypeInfo;
    }

    public final void shutdown() {
        if (this.isRunning) {
            this.isRunning = false;
            this.selector.wakeup();
        }
    }

    public final void run() {
        while (this.isRunning) {
            try {
                int count = this.selector.select();
                if (count <= 0) continue;
                Set<SelectionKey> selectedKeys = this.selector.selectedKeys();
                Iterator<SelectionKey> it = selectedKeys.iterator();
                while (it.hasNext()) {
                    SelectionKey sk = it.next();
                    it.remove();
                    if (!sk.isValid() || !sk.isAcceptable()) continue;
                    this.handleAcceptEvent((ServerSocketChannel)sk.channel());
                }
            }
            catch (Throwable t) {
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("error occured while accepting connection: " + t.toString());
            }
        }
        try {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("closing acceptor");
            }
            this.selector.close();
            this.serverChannel.close();
        }
        catch (IOException ioe) {
            LOG.warning("Exception occured during unbind acceptor (selector). Reason: " + ioe.toString());
            throw new RuntimeException(ioe);
        }
    }

    private void handleAcceptEvent(ServerSocketChannel ssc) {
        block2: {
            try {
                SocketChannel sc = ssc.accept();
                IHandler appHandler = null;
                appHandler = this.appHandlerTypeInfo.isConnectionScoped() ? (IHandler)((IConnectionScoped)((Object)this.appHandlerPrototype)).clone() : this.appHandlerPrototype;
                ManagedConnection connection = new ManagedConnection(sc, this.localIdPrefix + "." + ++this.nextId, this.sslContext, this.sslOn);
                connection.setAttachedAppHandler(appHandler);
                connection.setAttachedAppHandlerTypeInfo(this.appHandlerTypeInfo);
                this.dispatcherPool.nextDispatcher().registerConnection(connection);
                ++this.handledConnections;
            }
            catch (Throwable t) {
                if (!this.isRunning || !LOG.isLoggable(Level.FINE)) break block2;
                LOG.fine("Exception occured while accepting new incomming connection. Reason: " + t.toString());
            }
        }
    }
}

