/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.server;

import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.server.Dispatcher;

final class DirectMemoryManager {
    private static final Logger LOG = Logger.getLogger(DirectMemoryManager.class.getName());
    private int preallocationSize = 524288;
    private ByteBuffer freeBuffer = null;

    DirectMemoryManager(int preallocationSize) {
        this.preallocationSize = preallocationSize;
    }

    public final void setPreallocationSize(int preallocationSize) {
        this.preallocationSize = preallocationSize;
    }

    public final int getPreallocationSize() {
        return this.preallocationSize;
    }

    public int getCurrentPreallocationBufferSize() {
        ByteBuffer b = this.freeBuffer;
        if (b == null) {
            return 0;
        }
        return b.remaining();
    }

    public void recycleMemory(ByteBuffer buffer) {
        assert (Dispatcher.isDispatcherThread()) : "io memory methods has to be called within dispatcher thread";
        this.freeBuffer = buffer;
    }

    public final ByteBuffer acquireMemory() {
        assert (Dispatcher.isDispatcherThread()) : "io memory methods has to be called within dispatcher thread";
        ByteBuffer buffer = null;
        if (this.freeBuffer != null && this.freeBuffer.hasRemaining()) {
            buffer = this.freeBuffer;
            this.freeBuffer = null;
        }
        if (buffer == null) {
            buffer = this.newBuffer();
        }
        return buffer;
    }

    final ByteBuffer newBuffer() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("allocate new physical memory (size: " + this.preallocationSize + ") by thread " + Thread.currentThread().getName());
        }
        return ByteBuffer.allocateDirect(this.preallocationSize);
    }
}

