/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.server;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.xsocket.server.DirectMemoryManager;
import org.xsocket.server.EventHandler;
import org.xsocket.server.IDispatcher;
import org.xsocket.server.ManagedConnection;
import org.xsocket.server.WorkerPool;
import org.xsocket.server.management.DispatcherMBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Dispatcher
implements IDispatcher,
Runnable,
DispatcherMBean {
    private static final Logger LOG = Logger.getLogger(Dispatcher.class.getName());
    private static final boolean TIME_TRACE_ON = false;
    static final String THREAD_PREXIX = "Dispatcher";
    private boolean isRunning = true;
    private Object dispatcherThreadGuard = new Object();
    private String name = null;
    private String appDomain = null;
    private Selector demultiplexer = null;
    private final EventHandler eventHandler = new EventHandler(this);
    private final DirectMemoryManager ioMemoryManager = new DirectMemoryManager(65536);
    private ObjectName mbeanName = null;
    private long handledConnections = 0L;
    private int numberOfConnectionTimeouts = 0;
    private int numberOfIdleTimeouts = 0;

    Dispatcher(String appDomain, String name, WorkerPool workerPool) {
        this.appDomain = appDomain;
        this.name = name;
        this.eventHandler.setWorkerPool(workerPool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerConnection(ManagedConnection connection) throws IOException {
        connection.setIOMemoryManager(this.ioMemoryManager);
        connection.setConnectionListener(this.eventHandler);
        Object object = this.dispatcherThreadGuard;
        synchronized (object) {
            this.demultiplexer.wakeup();
            connection.getChannel().register(this.demultiplexer, 1, connection);
        }
        this.eventHandler.onDispatcherRegisteredEvent(connection);
        ++this.handledConnections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deregisterConnection(ManagedConnection connection) throws IOException {
        Object object = this.dispatcherThreadGuard;
        synchronized (object) {
            this.demultiplexer.wakeup();
            SelectionKey key = connection.getChannel().keyFor(this.demultiplexer);
            key.interestOps(0);
            key.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void announceWriteDemand(ManagedConnection connection) {
        SelectionKey key = connection.getChannel().keyFor(this.demultiplexer);
        if (key != null) {
            Object object = this.dispatcherThreadGuard;
            synchronized (object) {
                Dispatcher.timeTrace("set readwrite op start");
                if (key.isValid()) {
                    key.selector().wakeup();
                    key.interestOps(5);
                }
                Dispatcher.timeTrace("set readwrite op end");
            }
        }
    }

    private void init() {
        LOG.fine("opening selector to accept data");
        try {
            this.demultiplexer = Selector.open();
        }
        catch (IOException ioe) {
            String text = "exception occured while opening selector. Reason: " + ioe.toString();
            LOG.severe(text);
            throw new RuntimeException(text, ioe);
        }
        try {
            StandardMBean mbean = new StandardMBean(this, DispatcherMBean.class);
            this.mbeanName = new ObjectName(this.appDomain + ":type=Dispatcher,name=" + this.name);
            ManagementFactory.getPlatformMBeanServer().registerMBean(mbean, this.mbeanName);
        }
        catch (Exception mbe) {
            LOG.warning("error " + mbe.toString() + " occured while registering mbean");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        this.init();
        while (this.isRunning) {
            try {
                Object object = this.dispatcherThreadGuard;
                synchronized (object) {
                }
                int eventCount = this.demultiplexer.select();
                if (eventCount <= 0) continue;
                Set<SelectionKey> selectedEventKeys = this.demultiplexer.selectedKeys();
                Iterator<SelectionKey> it = selectedEventKeys.iterator();
                while (it.hasNext()) {
                    SelectionKey eventKey = it.next();
                    it.remove();
                    ManagedConnection connection = (ManagedConnection)eventKey.attachment();
                    if (eventKey.isValid() && eventKey.isReadable()) {
                        Dispatcher.timeTrace(null);
                        Dispatcher.timeTrace("read start ");
                        this.eventHandler.onDispatcherReadableEvent(connection);
                        Dispatcher.timeTrace("read end ");
                    }
                    if (!eventKey.isValid() || !eventKey.isWritable()) continue;
                    Dispatcher.timeTrace("write start ");
                    eventKey.interestOps(1);
                    this.eventHandler.handleWriteableEvent(connection);
                    Dispatcher.timeTrace("write end ");
                }
            }
            catch (Throwable e) {
                LOG.warning("exception occured while processing. Reason " + e.toString());
            }
        }
        this.closeDispatcher();
    }

    private void closeDispatcher() {
        block9: {
            try {
                ManagementFactory.getPlatformMBeanServer().unregisterMBean(this.mbeanName);
            }
            catch (Exception mbe) {
                LOG.warning("error " + mbe.toString() + " occured while unregistering mbean");
            }
            LOG.fine("closing connections");
            if (this.demultiplexer != null) {
                for (SelectionKey sk : this.demultiplexer.keys()) {
                    try {
                        ManagedConnection connection = (ManagedConnection)sk.attachment();
                        connection.close();
                    }
                    catch (Exception exception) {}
                }
            }
            if (this.demultiplexer != null) {
                try {
                    this.demultiplexer.close();
                }
                catch (IOException ioe) {
                    if (!LOG.isLoggable(Level.FINE)) break block9;
                    LOG.fine("error occured by close selector within tearDown " + ioe.toString());
                }
            }
        }
    }

    public void shutdown() {
        if (this.isRunning) {
            this.isRunning = false;
            if (this.demultiplexer != null) {
                this.demultiplexer.wakeup();
            }
        }
    }

    @Override
    public boolean isClosed() {
        return !this.isRunning;
    }

    @Override
    public int getReceiveBufferPreallocationSize() {
        return this.ioMemoryManager.getPreallocationSize();
    }

    void setReceiveBufferPreallocationSize(int size) {
        this.ioMemoryManager.setPreallocationSize(size);
    }

    @Override
    public int getCurrentPreallocatedBufferSize() {
        return this.ioMemoryManager.getCurrentPreallocationBufferSize();
    }

    List<String> getOpenConnectionInfo() {
        ArrayList<String> result = new ArrayList<String>();
        for (SelectionKey sk : this.demultiplexer.keys()) {
            ManagedConnection connection = (ManagedConnection)sk.attachment();
            result.add(connection.toString());
        }
        return result;
    }

    @Override
    public int getNumberOfIdleTimeout() {
        return this.numberOfIdleTimeouts;
    }

    @Override
    public int getNumberOfOpenConnections() {
        return this.demultiplexer.keys().size();
    }

    @Override
    public int getNumberOfConnectionTimeout() {
        return this.numberOfConnectionTimeouts;
    }

    @Override
    public long getNumberOfHandledConnections() {
        return this.handledConnections;
    }

    static boolean isDispatcherThread() {
        return Thread.currentThread().getName().startsWith(THREAD_PREXIX);
    }

    void checkTimeouts(long current, long idleTimeout, long connectionTimeout) {
        block7: {
            assert (!Dispatcher.isDispatcherThread());
            try {
                if (this.demultiplexer == null) break block7;
                try {
                    SelectionKey[] selKeys;
                    Set<SelectionKey> keySet = this.demultiplexer.keys();
                    for (SelectionKey key : selKeys = keySet.toArray(new SelectionKey[keySet.size()])) {
                        ManagedConnection connection = (ManagedConnection)key.attachment();
                        if (connection.checkIdleTimeoutOccured(current, idleTimeout)) {
                            ++this.numberOfIdleTimeouts;
                        }
                        if (!connection.checkConnectionTimeoutOccured(current, connectionTimeout)) continue;
                        ++this.numberOfConnectionTimeouts;
                    }
                }
                catch (Exception ignore) {
                }
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
    }

    private static void timeTrace(String msg) {
    }
}

