/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.server;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.server.Dispatcher;
import org.xsocket.server.IDispatcher;
import org.xsocket.server.WorkerPool;
import org.xsocket.util.TextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DispatcherPool {
    private static final Logger LOG = Logger.getLogger(DispatcherPool.class.getName());
    private boolean isRunning = false;
    private String appDomain = null;
    private final LinkedList<Dispatcher> dispatchers = new LinkedList();
    private int size = 0;
    private int pointer = 0;
    private WorkerPool workerPool = null;
    private long idleTimeout = Long.MAX_VALUE;
    private long connectionTimeout = Long.MAX_VALUE;
    private Timer watchdogTimer = new Timer(true);
    private WatchdogTask watchdogTask = null;
    private int preallocationSize = 65536;

    public DispatcherPool(int size, String appDomain, WorkerPool workerPool, long idleTimeout, long connectionTimeout) {
        this.appDomain = appDomain;
        this.workerPool = workerPool;
        this.setSize(size);
        this.setIdleTimeout(idleTimeout);
        this.setConnectionTimeout(connectionTimeout);
    }

    int getReceiveBufferPreallocationSize() {
        return this.preallocationSize;
    }

    void setReceiveBufferPreallocationSize(int size) {
        this.preallocationSize = size;
        for (Dispatcher dispatcher : this.dispatchers) {
            dispatcher.setReceiveBufferPreallocationSize(size);
        }
    }

    void setIdleTimeout(long idleTimeout) {
        if (idleTimeout <= 0L) {
            throw new RuntimeException("idle timeout must be larger than 0");
        }
        this.idleTimeout = idleTimeout;
        this.updateTimeoutCheckPeriod();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("idle time out has ben update to " + TextUtils.printFormatedDuration(this.idleTimeout));
        }
    }

    long getIdleTimeout() {
        return this.idleTimeout;
    }

    void setConnectionTimeout(long connectionTimeout) {
        if (connectionTimeout <= 0L) {
            throw new RuntimeException("connection timeout must be larger than 0");
        }
        this.connectionTimeout = connectionTimeout;
        this.updateTimeoutCheckPeriod();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("connection time out has ben update to " + TextUtils.printFormatedDuration(this.connectionTimeout));
        }
    }

    long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    private void updateTimeoutCheckPeriod() {
        long period = this.getIdleTimeout();
        if (this.getConnectionTimeout() < this.getIdleTimeout()) {
            period = this.getConnectionTimeout();
        }
        this.setTimeoutCheckPeriod((int)((double)period / 5.0));
    }

    int getSize() {
        return this.size;
    }

    void setSize(int size) {
        this.size = size;
        this.updateDisptacher();
    }

    void run() {
        this.isRunning = true;
        this.updateDisptacher();
    }

    private void updateDisptacher() {
        block2: {
            int currentRunning;
            block3: {
                if (!this.isRunning || (currentRunning = this.dispatchers.size()) == this.size) break block2;
                if (currentRunning <= this.size) break block3;
                for (int i = this.size; i < currentRunning; ++i) {
                    Dispatcher dispatcher = this.dispatchers.getLast();
                    this.dispatchers.remove(dispatcher);
                    dispatcher.shutdown();
                }
                break block2;
            }
            if (currentRunning >= this.size) break block2;
            for (int i = currentRunning; i < this.size; ++i) {
                String dispatcherName = "Dispatcher_" + i;
                Dispatcher dispatcher = null;
                dispatcher = new Dispatcher(this.appDomain, dispatcherName, this.workerPool);
                this.dispatchers.addLast(dispatcher);
                Thread t = new Thread(dispatcher);
                t.setName(dispatcherName);
                t.setDaemon(false);
                t.start();
            }
        }
    }

    void shutdown() {
        this.isRunning = false;
        if (LOG.isLoggable(Level.FINER)) {
            LOG.fine("terminate dispatchers");
        }
        for (Dispatcher dispatcher : this.dispatchers) {
            dispatcher.shutdown();
        }
        this.dispatchers.clear();
    }

    public IDispatcher nextDispatcher() {
        ++this.pointer;
        if (this.pointer >= this.size) {
            this.pointer = 0;
        }
        return this.dispatchers.get(this.pointer);
    }

    int getNumberOfConnectionTimeout() {
        int result = 0;
        for (Dispatcher disptacher : this.dispatchers) {
            result += disptacher.getNumberOfConnectionTimeout();
        }
        return result;
    }

    int getNumberOfIdleTimeout() {
        int result = 0;
        for (Dispatcher disptacher : this.dispatchers) {
            result += disptacher.getNumberOfIdleTimeout();
        }
        return result;
    }

    List<String> getOpenConnections() {
        ArrayList<String> result = new ArrayList<String>();
        for (Dispatcher dispatcher : this.dispatchers) {
            result.addAll(dispatcher.getOpenConnectionInfo());
        }
        return result;
    }

    int getNumberOfOpenConnections() {
        int result = 0;
        for (Dispatcher dispatcher : this.dispatchers) {
            result += dispatcher.getNumberOfOpenConnections();
        }
        return result;
    }

    long getNumberOfHandledConnections() {
        long result = 0L;
        for (Dispatcher dispatcher : this.dispatchers) {
            result += dispatcher.getNumberOfHandledConnections();
        }
        return result;
    }

    private void setTimeoutCheckPeriod(long period) {
        if (this.watchdogTask != null) {
            this.watchdogTask.cancel();
        }
        this.watchdogTask = new WatchdogTask();
        this.watchdogTimer.schedule((TimerTask)this.watchdogTask, period, period);
    }

    private void checkDispatcherTimeout() {
        block3: {
            try {
                long current = System.currentTimeMillis();
                LinkedList disps = (LinkedList)this.dispatchers.clone();
                for (Dispatcher dispatcher : disps) {
                    dispatcher.checkTimeouts(current, this.idleTimeout, this.connectionTimeout);
                }
            }
            catch (Exception e) {
                if (!LOG.isLoggable(Level.FINE)) break block3;
                LOG.fine("error occured: " + e.toString());
            }
        }
    }

    private final class WatchdogTask
    extends TimerTask {
        private WatchdogTask() {
        }

        public void run() {
            if (DispatcherPool.this.isRunning) {
                DispatcherPool.this.checkDispatcherTimeout();
            }
        }
    }
}

