/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.server;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.server.Dispatcher;
import org.xsocket.server.IConnectHandler;
import org.xsocket.server.IDataHandler;
import org.xsocket.server.IDisconnectHandler;
import org.xsocket.server.IDispatcher;
import org.xsocket.server.IManagedConnectionListener;
import org.xsocket.server.ITimeoutHandler;
import org.xsocket.server.ManagedConnection;
import org.xsocket.server.WorkerPool;

final class EventHandler
implements IManagedConnectionListener {
    private static final Logger LOG = Logger.getLogger(EventHandler.class.getName());
    private static final boolean TIME_TRACE_ON = false;
    private IDispatcher dispatcher = null;
    private WorkerPool workerPool = null;

    EventHandler(IDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    void setWorkerPool(WorkerPool workerPool) {
        this.workerPool = workerPool;
    }

    void onDispatcherRegisteredEvent(ManagedConnection connection) throws IOException {
        assert (!Dispatcher.isDispatcherThread());
        connection.init();
    }

    void onDispatcherReadableEvent(final ManagedConnection connection) {
        int readSize;
        assert (Dispatcher.isDispatcherThread());
        if (connection.isOpen() && (readSize = connection.receive()) > 0 && connection.getAttachedAppHandlerTypeInfo().isDataHandler()) {
            this.workerPool.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    EventHandler.timeTrace("TASK start task (CTX switch)");
                    try {
                        ManagedConnection managedConnection = connection;
                        synchronized (managedConnection) {
                            ((IDataHandler)connection.getAttachedAppHandler()).onData(connection);
                        }
                    }
                    catch (BufferUnderflowException bue) {
                    }
                    catch (Throwable e) {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("error occured by performing onData task. Reason: " + e.toString());
                        }
                        connection.close();
                    }
                    connection.flushOutgoing();
                    EventHandler.timeTrace("TASK  end ");
                }
            });
        }
    }

    void onDispatcherWriteableEvent(ManagedConnection connection) throws IOException {
        assert (Dispatcher.isDispatcherThread());
        this.handleWriteableEvent(connection);
    }

    void handleWriteableEvent(ManagedConnection connection) throws IOException {
        ByteBuffer[] unwritten;
        List<ByteBuffer> buffers;
        if (connection.isOpen() && (buffers = connection.drainWriteQueue()) != null && (unwritten = connection.realWritePhysical(buffers.toArray(new ByteBuffer[buffers.size()]))) != null) {
            connection.addAsFirstToWriteQueue(unwritten);
            connection.flushOutgoing();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConnectionConnectEvent(ManagedConnection connection) {
        assert (!Dispatcher.isDispatcherThread() || connection.isSSLActivated());
        if (connection.getAttachedAppHandlerTypeInfo().isConnectHandler()) {
            try {
                ManagedConnection managedConnection = connection;
                synchronized (managedConnection) {
                    ((IConnectHandler)connection.getAttachedAppHandler()).onConnect(connection);
                }
            }
            catch (BufferUnderflowException bue) {
            }
            catch (Throwable e) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("error occured by performing onConnect task. Reason: " + e.toString());
                }
                connection.close();
            }
            connection.flushOutgoing();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConnectionCloseEvent(ManagedConnection connection) {
        block9: {
            try {
                if (connection.getAttachedAppHandlerTypeInfo().isDisconnectHandler()) {
                    try {
                        ManagedConnection managedConnection = connection;
                        synchronized (managedConnection) {
                            ((IDisconnectHandler)((Object)connection.getAttachedAppHandler())).onDisconnect(connection.getId());
                        }
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                }
                this.dispatcher.deregisterConnection(connection);
                connection.setWriteTransferRate(Integer.MAX_VALUE);
                this.handleWriteableEvent(connection);
                connection.destroy();
            }
            catch (Exception e) {
                if (!LOG.isLoggable(Level.FINE)) break block9;
                LOG.fine("error occured by closing connection. Reason: " + e.toString());
            }
        }
    }

    public void onConnectionDataToSendEvent(ManagedConnection connection) {
        this.dispatcher.announceWriteDemand(connection);
    }

    public void onConnectionIdleTimeoutEvent(ManagedConnection connection) {
        block6: {
            assert (!Dispatcher.isDispatcherThread());
            try {
                if (connection.getAttachedAppHandlerTypeInfo().isTimeoutHandler()) {
                    boolean handled = ((ITimeoutHandler)connection.getAttachedAppHandler()).onIdleTimeout(connection);
                    connection.flushOutgoing();
                    if (!handled) {
                        connection.close();
                    }
                } else {
                    connection.close();
                }
            }
            catch (Exception e) {
                if (!LOG.isLoggable(Level.FINE)) break block6;
                LOG.fine("error occured by handling idle timeout event. Reason: " + e.toString());
            }
        }
    }

    public void onConnectionTimeoutEvent(ManagedConnection connection) {
        block6: {
            assert (!Dispatcher.isDispatcherThread());
            try {
                if (connection.getAttachedAppHandlerTypeInfo().isTimeoutHandler()) {
                    boolean handled = ((ITimeoutHandler)connection.getAttachedAppHandler()).onConnectionTimeout(connection);
                    connection.flushOutgoing();
                    if (!handled) {
                        connection.close();
                    }
                } else {
                    connection.close();
                }
            }
            catch (Exception e) {
                if (!LOG.isLoggable(Level.FINE)) break block6;
                LOG.fine("error occured by handling coonection timeout event. Reason: " + e.toString());
            }
        }
    }

    private static void timeTrace(String msg) {
    }
}

