/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.server;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.xsocket.ClosedConnectionException;
import org.xsocket.NonBlockingConnection;
import org.xsocket.server.DirectMemoryManager;
import org.xsocket.server.Dispatcher;
import org.xsocket.server.IHandler;
import org.xsocket.server.IHandlerTypeInfo;
import org.xsocket.server.IManagedConnectionListener;
import org.xsocket.util.TextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ManagedConnection
extends NonBlockingConnection {
    private static final Logger LOG = Logger.getLogger(ManagedConnection.class.getName());
    private final WriteQueue writeQueue = new WriteQueue();
    private IManagedConnectionListener connectionListener = null;
    private DirectMemoryManager ioMemoryManager = null;
    private IHandler attachedAppHandler = null;
    private IHandlerTypeInfo attachedAppHandlerTypeInfo = null;
    private boolean isCloseOccured = false;
    private boolean isIdleTimeouOccured = false;
    private boolean isConnectionTimeoutOccured = false;

    public ManagedConnection(SocketChannel channel, String id, SSLContext sslContext, boolean sslOn) throws IOException {
        super(channel, id, false, sslContext, sslOn);
        channel.configureBlocking(false);
        if (LOG.isLoggable(Level.FINE)) {
            this.logFine("new connection " + this.toString());
        }
    }

    @Override
    public void init() {
        super.init();
    }

    void setIOMemoryManager(DirectMemoryManager ioMemoryManager) {
        this.ioMemoryManager = ioMemoryManager;
    }

    void setConnectionListener(IManagedConnectionListener connectionListener) {
        this.connectionListener = connectionListener;
    }

    List<ByteBuffer> drainWriteQueue() throws IOException {
        if (this.writeQueue.isEmtpy()) {
            return null;
        }
        return this.writeQueue.readAvailable();
    }

    void addAsFirstToWriteQueue(ByteBuffer[] buffers) {
        this.writeQueue.addFirst(buffers);
    }

    @Override
    protected final void flushOutgoing() {
        if (!this.writeQueue.isEmtpy()) {
            this.connectionListener.onConnectionDataToSendEvent(this);
        }
    }

    @Override
    protected SocketChannel getChannel() {
        return super.getChannel();
    }

    @Override
    public void close() {
        if (!this.isCloseOccured) {
            this.isCloseOccured = true;
            this.connectionListener.onConnectionCloseEvent(this);
        }
    }

    void destroy() {
        super.close();
    }

    @Override
    protected synchronized ByteBuffer[] writePhysical(ByteBuffer[] buffers) throws ClosedConnectionException, IOException {
        this.writeQueue.append(buffers);
        return null;
    }

    ByteBuffer[] realWritePhysical(ByteBuffer[] buffers) throws ClosedConnectionException, IOException {
        return super.writePhysical(buffers);
    }

    @Override
    protected int readIncoming() throws IOException, ClosedConnectionException {
        return 0;
    }

    public int receive() {
        assert (Dispatcher.isDispatcherThread()) : "must be performed in single threaded dispatcher to avoid read mess";
        try {
            return super.readIncoming();
        }
        catch (IOException ioe) {
            this.close();
            return 0;
        }
    }

    @Override
    protected void onConnect() {
        super.onConnect();
        this.connectionListener.onConnectionConnectEvent(this);
    }

    IHandler getAttachedAppHandler() {
        return this.attachedAppHandler;
    }

    void setAttachedAppHandler(IHandler attachedAppHandler) {
        this.attachedAppHandler = attachedAppHandler;
    }

    IHandlerTypeInfo getAttachedAppHandlerTypeInfo() {
        return this.attachedAppHandlerTypeInfo;
    }

    void setAttachedAppHandlerTypeInfo(IHandlerTypeInfo attachedAppHandlerTypeInfo) {
        this.attachedAppHandlerTypeInfo = attachedAppHandlerTypeInfo;
    }

    boolean isSSLActivated() {
        return super.isSSLOn();
    }

    boolean checkIdleTimeoutOccured(long currentTime, long idleTimeout) {
        block5: {
            try {
                if (idleTimeout != Long.MAX_VALUE && currentTime > this.getLastReceivingTime() + idleTimeout) {
                    if (this.isIdleTimeouOccured) {
                        return false;
                    }
                    this.isIdleTimeouOccured = true;
                    if (LOG.isLoggable(Level.FINE)) {
                        this.logFine("idle timeout (" + TextUtils.printFormatedDuration(idleTimeout) + ") reached for connection " + this.toString());
                    }
                    this.connectionListener.onConnectionIdleTimeoutEvent(this);
                    return true;
                }
            }
            catch (Throwable t) {
                if (!LOG.isLoggable(Level.FINE)) break block5;
                LOG.fine("error occured by performing timeout check: " + t.toString());
            }
        }
        return false;
    }

    boolean checkConnectionTimeoutOccured(long currentTime, long connectionTimeout) {
        block5: {
            try {
                if (connectionTimeout != Long.MAX_VALUE && currentTime > this.getConnectionOpenedTime() + connectionTimeout) {
                    if (this.isConnectionTimeoutOccured) {
                        return false;
                    }
                    this.isConnectionTimeoutOccured = true;
                    if (LOG.isLoggable(Level.FINE)) {
                        this.logFine("connection timeout (" + TextUtils.printFormatedDuration(connectionTimeout) + ") reached for connection " + this.toString());
                    }
                    this.connectionListener.onConnectionTimeoutEvent(this);
                    return true;
                }
            }
            catch (Throwable t) {
                if (!LOG.isLoggable(Level.FINE)) break block5;
                LOG.fine("error occured by performing timeout check: " + t.toString());
            }
        }
        return false;
    }

    @Override
    protected ByteBuffer acquireIOReadMemory() {
        return this.ioMemoryManager.acquireMemory();
    }

    @Override
    protected void recycleIOReadMemory(ByteBuffer buffer) {
        this.ioMemoryManager.recycleMemory(buffer);
    }

    @Override
    public String toString() {
        String s = super.toString();
        return s + ", sendQueueSize=" + this.writeQueue.getSize();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class WriteQueue {
        private LinkedList<ByteBuffer> bufferQueue = new LinkedList();

        private WriteQueue() {
        }

        public synchronized boolean isEmtpy() {
            return this.bufferQueue.isEmpty();
        }

        public synchronized int append(ByteBuffer[] buffers) {
            int written = 0;
            for (ByteBuffer buffer : buffers) {
                written += buffer.limit() - buffer.position();
                this.bufferQueue.addLast(buffer);
            }
            return written;
        }

        public synchronized void addFirst(ByteBuffer ... buffer) {
            for (int i = buffer.length - 1; i >= 0; --i) {
                this.bufferQueue.addFirst(buffer[i]);
            }
        }

        public synchronized LinkedList<ByteBuffer> readAvailable() throws IOException {
            LinkedList<ByteBuffer> result = this.bufferQueue;
            this.bufferQueue = new LinkedList();
            return result;
        }

        public synchronized int getSize() {
            int i = 0;
            for (ByteBuffer buffer : this.bufferQueue) {
                i += buffer.remaining();
            }
            return i;
        }

        public String toString() {
            return TextUtils.toTextOrHexString(this.bufferQueue.toArray(new ByteBuffer[this.bufferQueue.size()]), "US-ASCII", 500);
        }
    }
}

