/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.server;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.net.ssl.SSLContext;
import org.xsocket.server.Acceptor;
import org.xsocket.server.DispatcherPool;
import org.xsocket.server.IConnectHandler;
import org.xsocket.server.IConnectionScoped;
import org.xsocket.server.IDataHandler;
import org.xsocket.server.IDisconnectHandler;
import org.xsocket.server.IHandler;
import org.xsocket.server.IHandlerContext;
import org.xsocket.server.IHandlerTypeInfo;
import org.xsocket.server.ILifeCycle;
import org.xsocket.server.IMultithreadedServer;
import org.xsocket.server.ITimeoutHandler;
import org.xsocket.server.Resource;
import org.xsocket.server.WorkerPool;
import org.xsocket.server.management.MultithreadedServerMBean;
import org.xsocket.util.TextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MultithreadedServer
implements IMultithreadedServer,
MultithreadedServerMBean {
    private static final Logger LOG = Logger.getLogger(MultithreadedServer.class.getName());
    private boolean isRunning = true;
    private int port = 0;
    private InetAddress localAddress = null;
    private IHandler appHandler = null;
    private IHandlerTypeInfo appHandlerTypeInfo = null;
    private WorkerPool workerPool = new WorkerPool();
    private Acceptor acceptor = null;
    private DispatcherPool dispatcherPool = null;
    private String hostname = null;
    private String appDomain = null;
    private ObjectName mbeanName = null;

    public MultithreadedServer(int port) throws UnknownHostException, IOException {
        this(port, "xsocket", false, null);
    }

    public MultithreadedServer(int port, String appDomain, boolean sslOn, SSLContext sslContext) throws UnknownHostException, IOException {
        this.port = port;
        this.appDomain = appDomain + "." + port;
        this.localAddress = InetAddress.getLocalHost();
        this.hostname = this.localAddress.getCanonicalHostName() + "." + port;
        this.setWorkerPoolSize(Runtime.getRuntime().availableProcessors() * 10);
        this.dispatcherPool = new DispatcherPool(Runtime.getRuntime().availableProcessors() + 1, this.appDomain, this.workerPool, Long.MAX_VALUE, Long.MAX_VALUE);
        this.acceptor = new Acceptor(port, this.dispatcherPool, sslContext, sslOn, Integer.toString(port));
        this.setConnectionTimeoutSec(Integer.MAX_VALUE);
        this.setIdleTimeoutSec(3600);
    }

    WorkerPool getWorkerPool() {
        return this.workerPool;
    }

    @Override
    public final void shutdown() {
        if (this.isRunning) {
            this.isRunning = false;
            try {
                ManagementFactory.getPlatformMBeanServer().unregisterMBean(this.mbeanName);
            }
            catch (Exception mbe) {
                LOG.warning("error " + mbe.toString() + " occured while unregistering mbean");
            }
            if (LOG.isLoggable(Level.FINER)) {
                LOG.fine("close acceptor");
            }
            this.acceptor.shutdown();
            this.dispatcherPool.shutdown();
            this.workerPool.shutdownNow();
            this.destroyCurrentHandler();
        }
    }

    @Override
    public final void run() {
        if (this.appHandler == null) {
            LOG.warning("no handler has been set. Call setHandler-method to set an assigned handler");
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                MultithreadedServer.this.shutdown();
            }
        });
        try {
            StandardMBean mbean = new StandardMBean(this, MultithreadedServerMBean.class);
            this.mbeanName = new ObjectName(this.appDomain + ":type=MultithreadedServer,name=" + this.hostname);
            ManagementFactory.getPlatformMBeanServer().registerMBean(mbean, this.mbeanName);
        }
        catch (Exception mbe) {
            LOG.warning("error " + mbe.toString() + " occured while registering mbean");
        }
        this.dispatcherPool.run();
        LOG.info("server " + this.appDomain + " listening on port " + this.port + " (" + this.getVersionInfo() + ")");
        LOG.fine("dispatcherPoolSize=" + this.getDispatcherPoolSize() + " workerPoolsize=" + this.getWorkerPoolSize());
        LOG.fine("preallocationSize=" + this.getReceiveBufferPreallocationSize());
        LOG.fine("connectionTimeout=" + TextUtils.printFormatedDuration(this.dispatcherPool.getConnectionTimeout()) + "; idleTimeout=" + TextUtils.printFormatedDuration(this.dispatcherPool.getIdleTimeout()));
        this.acceptor.run();
    }

    @Override
    public final void setDispatcherPoolSize(int size) {
        this.dispatcherPool.setSize(size);
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    @Override
    public void setHandler(IHandler appHandler) {
        if (appHandler == null) {
            throw new NullPointerException("handler have to be not null");
        }
        this.destroyCurrentHandler();
        this.appHandler = appHandler;
        this.appHandlerTypeInfo = new HandlerMetaData(appHandler);
        this.initCurrentHandler();
    }

    private void initCurrentHandler() {
        this.injectContext(this.appHandler);
        this.acceptor.setHandler(this.appHandler, this.appHandlerTypeInfo);
        if (this.appHandlerTypeInfo.isLifeCycleHandler()) {
            ((ILifeCycle)this.appHandler).onInit();
        }
    }

    private void injectContext(IHandler hdl) {
        Field[] fields;
        HandlerContext ctx = null;
        for (Field field : fields = hdl.getClass().getDeclaredFields()) {
            if (field.getType() != IHandlerContext.class || field.getAnnotation(Resource.class) == null) continue;
            field.setAccessible(true);
            try {
                if (ctx == null) {
                    ctx = new HandlerContext();
                }
                field.set(hdl, ctx);
            }
            catch (IllegalAccessException iae) {
                LOG.warning("couldn't set HandlerContext for attribute " + field.getName() + ". Reason " + iae.toString());
            }
        }
    }

    private void destroyCurrentHandler() {
        if (this.appHandler != null) {
            if (this.appHandlerTypeInfo.isLifeCycleHandler()) {
                ((ILifeCycle)this.appHandler).onDestroy();
            }
            this.appHandler = null;
        }
    }

    @Override
    public final int getPort() {
        return this.port;
    }

    @Override
    public void setWorkerPoolSize(int workerSize) {
        this.workerPool.setSize(workerSize);
    }

    @Override
    public int getWorkerPoolSize() {
        return this.workerPool.getSize();
    }

    @Override
    public final int getReceiveBufferPreallocationSize() {
        return this.dispatcherPool.getReceiveBufferPreallocationSize();
    }

    @Override
    public void setReceiveBufferPreallocationSize(int size) {
        this.dispatcherPool.setReceiveBufferPreallocationSize(size);
    }

    @Override
    public void setConnectionTimeoutSec(int timeoutSec) {
        this.dispatcherPool.setConnectionTimeout((long)timeoutSec * 1000L);
    }

    @Override
    public void setIdleTimeoutSec(int timeoutInSec) {
        this.dispatcherPool.setIdleTimeout((long)timeoutInSec * 1000L);
    }

    @Override
    public final int getDispatcherPoolSize() {
        return this.dispatcherPool.getSize();
    }

    @Override
    public final int getConnectionTimeoutSec() {
        return (int)(this.getConnectionTimeout() / 1000L);
    }

    private long getConnectionTimeout() {
        return this.dispatcherPool.getConnectionTimeout();
    }

    @Override
    public final int getIdleTimeoutSec() {
        return (int)(this.getIdleTimeout() / 1000L);
    }

    private long getIdleTimeout() {
        return this.dispatcherPool.getIdleTimeout();
    }

    @Override
    public int getNumberOfConnectionTimeout() {
        return this.dispatcherPool.getNumberOfConnectionTimeout();
    }

    @Override
    public final int getNumberOfIdleTimeout() {
        return this.dispatcherPool.getNumberOfIdleTimeout();
    }

    @Override
    public final List<String> getOpenConnections() {
        return this.dispatcherPool.getOpenConnections();
    }

    @Override
    public int getNumberOfOpenConnections() {
        return this.dispatcherPool.getNumberOfOpenConnections();
    }

    @Override
    public final long getNumberOfHandledConnections() {
        return this.dispatcherPool.getNumberOfHandledConnections();
    }

    private String getVersionInfo() {
        Package p = Package.getPackage("org.xsocket");
        if (p != null) {
            return p.getSpecificationTitle() + " " + p.getImplementationVersion();
        }
        return "";
    }

    private final class HandlerContext
    implements IHandlerContext {
        private HandlerContext() {
        }

        public int getLocalePort() {
            return MultithreadedServer.this.getPort();
        }

        public InetAddress getLocaleAddress() {
            return MultithreadedServer.this.localAddress;
        }

        public String getDomainname() {
            return MultithreadedServer.this.appDomain;
        }
    }

    private static final class HandlerMetaData
    implements IHandlerTypeInfo {
        private boolean isLifeCycleHandler = false;
        private boolean isConnectionScoped = false;
        private boolean isConnectHandler = false;
        private boolean isDisconnectHandler = false;
        private boolean isDataHandler = false;
        private boolean isTimeoutHandler = false;

        public HandlerMetaData(IHandler handler) {
            this.isConnectHandler = handler instanceof IConnectHandler;
            this.isDisconnectHandler = handler instanceof IDisconnectHandler;
            this.isDataHandler = handler instanceof IDataHandler;
            this.isTimeoutHandler = handler instanceof ITimeoutHandler;
            this.isConnectionScoped = handler instanceof IConnectionScoped;
            this.isLifeCycleHandler = handler instanceof ILifeCycle;
        }

        public boolean isLifeCycleHandler() {
            return this.isLifeCycleHandler;
        }

        public boolean isConnectHandler() {
            return this.isConnectHandler;
        }

        public boolean isConnectionScoped() {
            return this.isConnectionScoped;
        }

        public boolean isDataHandler() {
            return this.isDataHandler;
        }

        public boolean isDisconnectHandler() {
            return this.isDisconnectHandler;
        }

        public boolean isTimeoutHandler() {
            return this.isTimeoutHandler;
        }
    }
}

