/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.server;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;

final class WorkerPool {
    private static final Logger LOG = Logger.getLogger(WorkerPool.class.getName());
    private int workerPoolSize = 0;
    private ExecutorService workers = null;

    WorkerPool() {
    }

    public void setSize(int workerSize) {
        if (this.workers != null) {
            this.workers.shutdown();
        }
        this.workerPoolSize = workerSize;
        this.workers = Executors.newFixedThreadPool(workerSize);
    }

    public int getSize() {
        return this.workerPoolSize;
    }

    public void shutdownNow() {
        LOG.fine("shuting down worker pool");
        this.workers.shutdownNow();
    }

    public void execute(Runnable command) {
        block2: {
            try {
                this.workers.execute(command);
            }
            catch (RuntimeException re) {
                if (!this.workers.isShutdown()) break block2;
                Thread t = new Thread(command);
                t.start();
            }
        }
    }
}

