/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.util;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TextUtils {
    private static final SimpleDateFormat DATE = new SimpleDateFormat("MMM.dd HH:mm");
    private static final Map<String, CharsetEncoder> encoders = new HashMap<String, CharsetEncoder>();
    private static final Map<String, CharsetDecoder> decoders = new HashMap<String, CharsetDecoder>();

    public static String printFormatedBytesSize(long bytes) {
        if (bytes > 5000000L) {
            return bytes / 1000000L + " mb";
        }
        if (bytes > 10000L) {
            return bytes / 1000L + " kb";
        }
        return bytes + " bytes";
    }

    public static String printFormatedDate(long time) {
        return DATE.format(new Date(time));
    }

    public static String printFormatedDuration(long duration) {
        if (duration < 5000L) {
            return duration + " millis";
        }
        if (duration < 60000L) {
            return (int)(duration / 1000L) + " sec";
        }
        if (duration < 3600000L) {
            return (int)(duration / 60000L) + " min";
        }
        return (int)(duration / 3600000L) + " h";
    }

    public static ByteBuffer toByteBuffer(String s, String encoding) {
        CharsetEncoder encoder = encoders.get(encoding);
        if (encoder == null) {
            Charset charset = Charset.forName(encoding);
            if (charset != null) {
                encoder = charset.newEncoder();
                encoders.put(encoding, encoder);
                decoders.put(encoding, charset.newDecoder());
            } else {
                return null;
            }
        }
        try {
            return encoder.encode(CharBuffer.wrap(s));
        }
        catch (CharacterCodingException cce) {
            throw new RuntimeException(cce);
        }
    }

    public static String toString(ByteBuffer buffer) {
        return TextUtils.toString(buffer, "UTF-8");
    }

    public static String toString(ByteBuffer buffer, String encoding) {
        try {
            CharsetDecoder decoder = decoders.get(encoding);
            if (decoder == null) {
                Charset charset = Charset.forName(encoding);
                if (charset != null) {
                    decoder = charset.newDecoder();
                    decoders.put(encoding, decoder);
                    encoders.put(encoding, charset.newEncoder());
                } else {
                    throw new RuntimeException("charset '" + encoding + "' has not been found");
                }
            }
            return decoder.decode(buffer).toString();
        }
        catch (CharacterCodingException cce) {
            RuntimeException re = new RuntimeException("coding exception for '" + encoding + "' occured: " + cce.toString(), cce);
            throw re;
        }
    }

    public static String toByteString(byte[] bytes) {
        return TextUtils.toByteString(ByteBuffer.wrap(bytes));
    }

    public static String toByteString(ByteBuffer buffer) {
        StringBuilder sb = new StringBuilder();
        while (buffer.hasRemaining()) {
            String hex = Integer.toHexString(256 + (buffer.get() & 0xFF)).substring(1);
            sb.append((hex.length() < 2 ? "0" : "") + hex + " ");
        }
        return sb.toString();
    }

    public static String toString(List<ByteBuffer> buffers, String encoding) {
        return TextUtils.toString(buffers.toArray(new ByteBuffer[buffers.size()]), encoding);
    }

    public static String toString(ByteBuffer[] buffers, String encoding) {
        StringBuilder sb = new StringBuilder();
        for (ByteBuffer buffer : buffers) {
            if (buffer == null) continue;
            sb.append(TextUtils.toString(buffer, encoding));
        }
        return sb.toString();
    }

    public static String toString(ByteBuffer[] buffers, String encoding, int maxOutSize) {
        String postfix = "";
        int size = 0;
        ArrayList<ByteBuffer> copies = new ArrayList<ByteBuffer>();
        for (ByteBuffer buffer : buffers) {
            ByteBuffer copy = buffer.duplicate();
            if (size + copy.limit() > maxOutSize) {
                copy.limit(maxOutSize - size);
                copies.add(copy);
                postfix = " [output has been cut]";
                break;
            }
            copies.add(copy);
        }
        StringBuilder result = new StringBuilder();
        try {
            for (ByteBuffer buffer : copies) {
                result.append(TextUtils.toString(buffer, encoding));
                buffer.flip();
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        result.append(postfix);
        return result.toString();
    }

    private static String toHexString(ByteBuffer[] buffers, int maxOutSize) {
        String postfix = "";
        int size = 0;
        ArrayList<ByteBuffer> copies = new ArrayList<ByteBuffer>();
        for (ByteBuffer buffer : buffers) {
            ByteBuffer copy = buffer.duplicate();
            if (size + copy.limit() > maxOutSize) {
                copy.limit(maxOutSize - size);
                copies.add(copy);
                postfix = " [output has been cut]";
                break;
            }
            copies.add(copy);
        }
        StringBuilder result = new StringBuilder();
        result.append("[hex:]");
        for (ByteBuffer buffer : copies) {
            result.append(TextUtils.toByteString(buffer));
        }
        result.append(postfix);
        return result.toString();
    }

    public static String toTextOrHexString(ByteBuffer[] buffers, String encoding, int maxOutSize) {
        String result = TextUtils.toString(buffers, encoding, maxOutSize);
        if (result.length() > 0) {
            return result;
        }
        return TextUtils.toHexString(buffers, maxOutSize);
    }
}

