/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.IDispatcher;
import org.xsocket.IEventHandler;
import org.xsocket.IHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Dispatcher<T extends IHandle>
implements IDispatcher<T>,
Runnable {
    private static final Logger LOG = Logger.getLogger(Dispatcher.class.getName());
    private boolean isRunning = true;
    private Object dispatcherThreadGuard = new Object();
    private Selector selector = null;
    private IEventHandler<T> eventHandler = null;
    private long handledRegistractions = 0L;
    private long handledReads = 0L;
    private long handledWrites = 0L;

    public Dispatcher(String dispatcherName, IEventHandler<T> eventHandler) {
        assert (eventHandler != null) : "null is not allowed for event handler ";
        this.eventHandler = eventHandler;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("dispatcher " + this.hashCode() + " has been created (eventHandler=" + eventHandler + ")");
        }
        try {
            this.selector = Selector.open();
        }
        catch (IOException ioe) {
            String text = "exception occured while opening selector. Reason: " + ioe.toString();
            LOG.severe(text);
            throw new RuntimeException(text, ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(T handle) throws IOException {
        assert (!handle.getChannel().isBlocking());
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("register handle " + handle);
        }
        Object object = this.dispatcherThreadGuard;
        synchronized (object) {
            this.selector.wakeup();
            handle.getChannel().register(this.selector, 1, handle);
        }
        this.eventHandler.onHandleRegisterEvent(handle);
        ++this.handledRegistractions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deregister(T handle) throws IOException {
        Object object = this.dispatcherThreadGuard;
        synchronized (object) {
            this.selector.wakeup();
            SelectionKey key = handle.getChannel().keyFor(this.selector);
            if (key.isValid()) {
                key.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<T> getRegistered() {
        HashSet<IHandle> registered = new HashSet<IHandle>();
        if (this.selector != null) {
            SelectionKey[] selKeys = null;
            Object object = this.dispatcherThreadGuard;
            synchronized (object) {
                this.selector.wakeup();
                Set<SelectionKey> keySet = this.selector.keys();
                selKeys = keySet.toArray(new SelectionKey[keySet.size()]);
            }
            try {
                for (SelectionKey key : selKeys) {
                    IHandle handle = (IHandle)key.attachment();
                    registered.add(handle);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return registered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void announceWriteNeed(T handle) {
        SelectionKey key = handle.getChannel().keyFor(this.selector);
        if (key != null) {
            Object object = this.dispatcherThreadGuard;
            synchronized (object) {
                if (key.isValid()) {
                    key.selector().wakeup();
                    key.interestOps(5);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetInterestOps(SelectionKey eventKey) {
        Object object = this.dispatcherThreadGuard;
        synchronized (object) {
            eventKey.interestOps(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("selector  listening ...");
        }
        while (this.isRunning) {
            try {
                Object object = this.dispatcherThreadGuard;
                synchronized (object) {
                }
                int eventCount = this.selector.select();
                if (eventCount <= 0) continue;
                Set<SelectionKey> selectedEventKeys = this.selector.selectedKeys();
                Iterator<SelectionKey> it = selectedEventKeys.iterator();
                while (it.hasNext()) {
                    SelectionKey eventKey = it.next();
                    it.remove();
                    IHandle handle = (IHandle)eventKey.attachment();
                    if (eventKey.isValid() && eventKey.isReadable()) {
                        this.eventHandler.onHandleReadableEvent(handle);
                        ++this.handledReads;
                    }
                    if (!eventKey.isValid() || !eventKey.isWritable()) continue;
                    this.resetInterestOps(eventKey);
                    ++this.handledWrites;
                    this.eventHandler.onHandleWriteableEvent(handle);
                }
            }
            catch (Throwable e) {
                LOG.warning("exception occured while processing. Reason " + e.toString());
            }
        }
        this.closeDispatcher();
    }

    private void closeDispatcher() {
        block8: {
            LOG.fine("closing connections");
            if (this.selector != null) {
                for (SelectionKey sk : this.selector.keys()) {
                    try {
                        IHandle handle = (IHandle)sk.attachment();
                        this.eventHandler.onDispatcherCloseEvent(handle);
                    }
                    catch (Exception exception) {}
                }
            }
            if (this.selector != null) {
                try {
                    this.selector.close();
                }
                catch (IOException ioe) {
                    if (!LOG.isLoggable(Level.FINE)) break block8;
                    LOG.fine("error occured by close selector within tearDown " + ioe.toString());
                }
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("dispatcher " + this.hashCode() + " has been closed");
        }
    }

    public void shutdown() {
        if (this.isRunning) {
            this.isRunning = false;
            if (this.selector != null) {
                this.selector.wakeup();
            }
        }
    }

    public boolean isRuning() {
        return this.isRunning;
    }

    @Override
    public long getNumberOfHandledRegistrations() {
        return this.handledRegistractions;
    }

    @Override
    public long getNumberOfHandledReads() {
        return this.handledReads;
    }

    @Override
    public long getNumberOfHandledWrites() {
        return this.handledWrites;
    }
}

