/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import javax.management.MBeanServer;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;

public final class JmxServer {
    private JMXConnectorServer server = null;

    public void start(String name) {
        this.start(name, 1199);
    }

    public void start(String name, int rmiPort) {
        try {
            Registry registry = LocateRegistry.createRegistry(rmiPort);
            registry.unbind(name);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + InetAddress.getLocalHost().getHostName() + ":" + rmiPort + "/" + name);
            MBeanServer mbeanSrv = ManagementFactory.getPlatformMBeanServer();
            this.server = JMXConnectorServerFactory.newJMXConnectorServer(url, null, mbeanSrv);
            this.server.start();
            System.out.println("JMX RMI Agent has been bound on address");
            System.out.println(url);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stop() {
        try {
            this.server.stop();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

