/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.datagram;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.WorkerPool;
import org.xsocket.datagram.IEndpoint;

abstract class AbstractEndpoint
implements IEndpoint {
    private static final Logger LOG = Logger.getLogger(AbstractEndpoint.class.getName());
    private static long nextId = 0L;
    private long id = 0L;
    private int receivePacketSize = 0;
    private String defaultEncoding = "UTF-8";
    private WorkerPool workerPool = null;
    private long handleIncomingDatagrams = 0L;
    private long handleOutgoingDatagrams = 0L;

    AbstractEndpoint(int receivePacketSize, int instanceWorkerPoolSize) {
        this.receivePacketSize = receivePacketSize;
        this.id = ++nextId;
        if (instanceWorkerPoolSize > 0) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("create instance specific workerpool with size " + instanceWorkerPoolSize);
            }
            this.workerPool = new WorkerPool();
            this.workerPool.setSize(instanceWorkerPoolSize);
        } else {
            this.workerPool = new WorkerPool(1);
        }
    }

    public final void setReceivePacketSize(int size) {
        this.receivePacketSize = size;
    }

    public final int getReceivePacketSize() {
        return this.receivePacketSize;
    }

    protected final WorkerPool getWorkerPool() {
        return this.workerPool;
    }

    protected final void stopWorkerPool() {
        this.getWorkerPool().stopPooling();
    }

    public final int getWorkerPoolSize() {
        return this.workerPool.getSize();
    }

    public final void setWorkerPoolSize(int size) {
        this.workerPool.setSize(size);
    }

    public final String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public final void setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    public final long getNumberOfHandledIncomingDatagram() {
        return this.handleIncomingDatagrams;
    }

    protected final void incNumberOfHandledIncomingDatagram() {
        ++this.handleIncomingDatagrams;
    }

    public final long getNumberOfHandledOutgoingDatagram() {
        return this.handleOutgoingDatagrams;
    }

    protected final void incNumberOfHandledOutgoingDatagram() {
        ++this.handleOutgoingDatagrams;
    }

    protected final long getId() {
        return this.id;
    }

    public String toString() {
        return Long.toString(this.id);
    }
}

