/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.datagram;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.Dispatcher;
import org.xsocket.IEventHandler;
import org.xsocket.IHandle;
import org.xsocket.datagram.AbstractEndpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractNioBasedEndpoint
extends AbstractEndpoint {
    private static final Logger LOG = Logger.getLogger(AbstractNioBasedEndpoint.class.getName());
    private static int nextId = 0;
    private DatagramSocket socket = null;
    private DatagramChannel channel = null;
    private ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
    private boolean isClientMode = true;
    private Dispatcher<EndpointHandle> dispatcher = null;
    private boolean useDefaultDispatcher = true;
    private final EndpointHandle handle = new EndpointHandle();
    private final WriteQueue writeQueue = new WriteQueue();
    private int preallocationSize = 65536;

    AbstractNioBasedEndpoint(int receiveDatasize, int instanceWorkerPoolSize, int localePort, boolean isClientMode) throws IOException {
        super(receiveDatasize, instanceWorkerPoolSize);
        this.isClientMode = isClientMode;
        this.channel = DatagramChannel.open();
        this.channel.configureBlocking(false);
        this.socket = this.channel.socket();
        this.socket.setReuseAddress(true);
        this.socket.bind(new InetSocketAddress(localePort));
        if (!isClientMode) {
            if (instanceWorkerPoolSize == 0) {
                this.logFine("using global dispatcher");
                this.useDefaultDispatcher = true;
                this.dispatcher = this.getDefaultDispatcher();
            } else {
                this.logFine("create instance specific dispatcher");
                this.useDefaultDispatcher = false;
                this.dispatcher = this.createDispatcher();
            }
            this.dispatcher.register(this.handle);
            this.logFine("enpoint has been bound to locale port " + this.getLocalPort() + " (server mode: receiveDataSize=" + receiveDatasize + ")");
        } else {
            this.logFine("enpoint has been bound to locale port " + this.getLocalPort() + " (client mode)");
        }
    }

    protected abstract Dispatcher<EndpointHandle> getDefaultDispatcher() throws IOException;

    protected abstract Dispatcher<EndpointHandle> createDispatcher() throws IOException;

    protected final Dispatcher<EndpointHandle> createAndStartDispatcher(IEventHandler<EndpointHandle> eventHandler) throws IOException {
        Dispatcher<EndpointHandle> dispatcher = new Dispatcher<EndpointHandle>(this.nextId(), eventHandler);
        Thread t = new Thread(dispatcher);
        t.start();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                AbstractNioBasedEndpoint.this.close();
            }
        });
        return dispatcher;
    }

    private String nextId() {
        if (++nextId < 0) {
            nextId = 1;
        }
        return Integer.toString(nextId);
    }

    @Override
    public void close() {
        if (this.isOpen()) {
            try {
                this.logFine("closing " + this.toCompactString());
                this.channel.close();
            }
            catch (IOException ioe) {
                this.logFine("error occured by closing connection. Reason " + ioe.toString());
            }
        }
        if (!this.useDefaultDispatcher) {
            this.dispatcher.shutdown();
        }
    }

    @Override
    public final InetAddress getLocalAddress() {
        return this.socket.getLocalAddress();
    }

    @Override
    public final int getLocalPort() {
        return this.socket.getLocalPort();
    }

    @Override
    public final boolean isOpen() {
        return this.channel.isOpen();
    }

    public final void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public final int getReceiveBufferPreallocationSize() {
        return this.preallocationSize;
    }

    public final void setReceiveBufferPreallocationSize(int preallocationSize) {
        this.preallocationSize = preallocationSize;
    }

    public final void logFine(String msg) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("[/:" + this.getLocalPort() + " " + this.getId() + "] " + msg);
        }
    }

    protected final void sendDatagram(SocketAddress remoteAddress, ByteBuffer data) {
        DataPackage dp = new DataPackage(remoteAddress, data);
        this.logFine("add datagram package (" + dp + ") to write queue");
        if (this.isClientMode) {
            this.writeQueue.append(dp);
            this.writePhysical();
        } else {
            this.writeQueue.append(dp);
            this.dispatcher.announceWriteNeed(this.handle);
        }
    }

    protected final void writePhysical() {
        if (!this.writeQueue.isEmtpy()) {
            LinkedList<DataPackage> dataPackages = this.writeQueue.readAvailable();
            for (DataPackage dataPackage : dataPackages) {
                try {
                    this.logFine("send datagram package (" + dataPackage + ")");
                    dataPackage.writeTo(this.channel);
                    this.incNumberOfHandledOutgoingDatagram();
                }
                catch (IOException ioe) {
                    LOG.warning("couldn't write datagram to " + dataPackage.getAddress() + " .Reason: " + ioe.toString());
                }
            }
        }
    }

    protected final DataPackage receive() throws IOException {
        ByteBuffer data = ByteBuffer.allocate(this.getReceivePacketSize());
        data.order(this.byteOrder);
        SocketAddress address = this.channel.receive(data);
        if (address == null) {
            return null;
        }
        this.incNumberOfHandledIncomingDatagram();
        data.clear();
        return new DataPackage(address, data);
    }

    @Override
    public String toCompactString() {
        return this.getClass().getSimpleName() + " " + this.socket.getLocalAddress().getCanonicalHostName() + ":" + this.getLocalPort();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class WriteQueue {
        private LinkedList<DataPackage> bufferQueue = new LinkedList();

        private WriteQueue() {
        }

        synchronized boolean isEmtpy() {
            return this.bufferQueue.isEmpty();
        }

        synchronized void append(DataPackage dataPackage) {
            this.bufferQueue.add(dataPackage);
        }

        public synchronized LinkedList<DataPackage> readAvailable() {
            LinkedList<DataPackage> result = this.bufferQueue;
            this.bufferQueue = new LinkedList();
            return result;
        }
    }

    static final class DataPackage {
        private ByteBuffer data = null;
        private SocketAddress address = null;

        public DataPackage(SocketAddress address, ByteBuffer data) {
            this.address = address;
            this.data = data;
        }

        public final SocketAddress getAddress() {
            return this.address;
        }

        public ByteBuffer getData() {
            return this.data;
        }

        int writeTo(DatagramChannel channel) throws IOException {
            return channel.send(this.data, this.getAddress());
        }

        public String toString() {
            return "Receiver=" + this.address.toString() + " dataSize=" + this.data.limit();
        }
    }

    final class EndpointHandle
    implements IHandle {
        EndpointHandle() {
        }

        public SelectableChannel getChannel() {
            return AbstractNioBasedEndpoint.this.channel;
        }

        public AbstractNioBasedEndpoint getEndpoint() {
            return AbstractNioBasedEndpoint.this;
        }

        public void close() {
            AbstractNioBasedEndpoint.this.close();
        }

        public void check(long currentTime) {
        }
    }
}

