/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.datagram;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import org.xsocket.IEventHandler;
import org.xsocket.datagram.AbstractNioBasedEndpoint;
import org.xsocket.datagram.LocalDisconnectedEndpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DisconnectedEventHandler
implements IEventHandler<AbstractNioBasedEndpoint.EndpointHandle> {
    DisconnectedEventHandler() {
    }

    @Override
    public void onHandleRegisterEvent(AbstractNioBasedEndpoint.EndpointHandle handle) throws IOException {
    }

    @Override
    public void onHandleReadableEvent(AbstractNioBasedEndpoint.EndpointHandle handle) {
        final LocalDisconnectedEndpoint endpoint = (LocalDisconnectedEndpoint)handle.getEndpoint();
        if (endpoint.isOpen()) {
            try {
                final AbstractNioBasedEndpoint.DataPackage dataPackage = endpoint.receive();
                if (dataPackage != null) {
                    endpoint.getWorkerPool().execute(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            try {
                                LocalDisconnectedEndpoint localDisconnectedEndpoint = endpoint;
                                synchronized (localDisconnectedEndpoint) {
                                    endpoint.getAppHandler().onData(endpoint, dataPackage.getData(), dataPackage.getAddress());
                                }
                            }
                            catch (Throwable e) {
                                endpoint.logFine("error occured by performing onData task. Reason: " + e.toString());
                            }
                        }
                    });
                }
            }
            catch (IOException ioe) {
                endpoint.logFine("error occured while receiving. Reason: " + ioe.toString());
            }
        }
    }

    @Override
    public void onHandleWriteableEvent(AbstractNioBasedEndpoint.EndpointHandle handle) throws IOException {
        handle.getEndpoint().writePhysical();
    }

    @Override
    public void onDispatcherCloseEvent(final AbstractNioBasedEndpoint.EndpointHandle handle) {
        handle.getEndpoint().getWorkerPool().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    AbstractNioBasedEndpoint.EndpointHandle endpointHandle = handle;
                    synchronized (endpointHandle) {
                        handle.close();
                    }
                }
                catch (BufferUnderflowException bue) {
                }
                catch (Throwable e) {
                    handle.getEndpoint().logFine("error occured by performing onDispatcherCloseEvent. Reason: " + e.toString());
                }
            }
        });
    }
}

